﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using log4net;
using log4net.Config;
using log4net.Appender;
using log4net.Repository;
using System.Threading;
using System.Security.Principal;
using Shared.Model;

namespace Auditing
{
    public class Logger
    {
        public static void Log(LogType LogType, int SiteID, ObjectType ObjectType, SiteFunction Function, int ObjectID, string ObjectName, Status Status, bool ContainsPID, string EventData, Exception OriginalException = null)
        {
            Log(LogType, SiteID, ContainsPID, (int)ObjectType, ObjectID, ObjectName, (int)Function, (int)Status, EventData, OriginalException);
        }

        public static void Log(LogType LogType, int SiteID, ObjectType ObjectType, ResourceFunction Function, int ObjectID, string ObjectName, Status Status, bool ContainsPID, string EventData, Exception OriginalException = null)
        {
            Log(LogType, SiteID, ContainsPID, (int)ObjectType, ObjectID, ObjectName, (int)Function, (int)Status, EventData, OriginalException);
        }

        public static void Log(LogType LogType, int SiteID, ObjectType ObjectType, PatientFunction Function, int ObjectID, string ObjectName, Status Status, bool ContainsPID, string EventData, Exception OriginalException = null)
        {
            Log(LogType, SiteID, ContainsPID, (int)ObjectType, ObjectID, ObjectName, (int)Function, (int)Status, EventData, OriginalException);
        }

        public static void Log(LogType LogType, int SiteID, ObjectType ObjectType, FacilityFunction Function, int ObjectID, string ObjectName, Status Status, bool ContainsPID, string EventData, Exception OriginalException = null)
        {
            Log(LogType, SiteID, ContainsPID, (int)ObjectType, ObjectID, ObjectName, (int)Function, (int)Status, EventData, OriginalException);
        }

        public static void Log(LogType LogType, int SiteID, ObjectType ObjectType, AppointmentFunction Function, int ObjectID, string ObjectName, Status Status, bool ContainsPID, string EventData, Exception OriginalException = null)
        {
            Log(LogType, SiteID, ContainsPID, (int)ObjectType, ObjectID, ObjectName, (int)Function, (int)Status, EventData, OriginalException);
        }

        public static void Log(LogType LogType, int SiteID, ObjectType ObjectType, ScheduleFunction Function, int ObjectID, string ObjectName, Status Status, bool ContainsPID, string EventData, Exception OriginalException = null)
        {
            Log(LogType, SiteID, ContainsPID, (int)ObjectType, ObjectID, ObjectName, (int)Function, (int)Status, EventData, OriginalException);
        }

        public static void Log(LogType LogType, int SiteID, ObjectType ObjectType, SectionFunction Function, int ObjectID, string ObjectName, Status Status, bool ContainsPID, string EventData, Exception OriginalException = null)
        {
            Log(LogType, SiteID, ContainsPID, (int)ObjectType, ObjectID, ObjectName, (int)Function, (int)Status, EventData, OriginalException);
        }

        private static void Log(LogType LogType, int SiteID, bool ContainsPID, int ObjectType, int ObjectID, string ObjectName, int Function, int Status, string EventData, Exception OriginalException = null)
        {
            string messageData = "";
            AuditData eventItem = new AuditData();
            log4net.ILog log = null;

            log4net.Config.XmlConfigurator.Configure();

            // select logger
            if (LogType == LogType.Information)
            {
                log = log4net.LogManager.GetLogger("InformationLog");
            }

            if (LogType == LogType.Warning)
            {
                log = log4net.LogManager.GetLogger("WarningLog");
            }

            if (LogType == LogType.Error)
            {
                log = log4net.LogManager.GetLogger("ErrorLog");
            }

            if (LogType == LogType.Fatal)
            {
                log = log4net.LogManager.GetLogger("FatalErrorLog");
            }

            // populate event
            eventItem.EventDateTime = DateTime.Now;
            eventItem.SiteId = SiteID;
            eventItem.UserName = ((IPrincipal)Thread.CurrentPrincipal).Identity.Name;

            eventItem.ContainsPID = ContainsPID;
            eventItem.ObjectTypeId = ObjectType;
            eventItem.ObjectId = ObjectID;
            eventItem.ObjectName = (ObjectName == null) ? "" : ObjectName;
            eventItem.FunctionId = Function;
            eventItem.StatusId = Status;
            eventItem.EventData = (EventData == null) ? "" : EventData;
            
            log4net.ThreadContext.Properties["EventDateTime"] = eventItem.EventDateTime.ToString();
            log4net.ThreadContext.Properties["SiteID"] = eventItem.SiteId.ToString();
            log4net.ThreadContext.Properties["UserName"] = eventItem.UserName;
            log4net.ThreadContext.Properties["ObjectTypeId"] = eventItem.ObjectTypeId.ToString();
            log4net.ThreadContext.Properties["FunctionId"] = eventItem.FunctionId.ToString();
            log4net.ThreadContext.Properties["ObjectId"] = eventItem.ObjectId.ToString();
            log4net.ThreadContext.Properties["ObjectName"] = eventItem.ObjectName;
            log4net.ThreadContext.Properties["StatusId"] = eventItem.StatusId.ToString();
            log4net.ThreadContext.Properties["ContainsPID"] = (eventItem.ContainsPID) ? "1" : "0";
            log4net.ThreadContext.Properties["ContainsPID_astext"] = eventItem.ContainsPID.ToString();
            log4net.ThreadContext.Properties["ObjectName"] = eventItem.ObjectName;
            log4net.ThreadContext.Properties["EventData"] = eventItem.EventData;

            // write data
            if (OriginalException != null)
            {
                StringBuilder sb = new StringBuilder();
                sb.Append(string.Format("{0}\n", eventItem.EventData));

                Exception ex = OriginalException;
                while (ex != null)
                {
                    sb.Append("------------------------------------------------------------\n");
                    sb.Append(string.Format("{0}\n", ex.Message));
                    sb.Append(string.Format("Source-{0}\n", ex.Source));
                    sb.Append(string.Format("StackTrace-{0}\n", ex.StackTrace));
                    ex = ex.InnerException;
                }

                messageData = sb.ToString();
            }
            else
                messageData = eventItem.EventData;

            if (LogType == LogType.Information)
            {
                log.Info(messageData);
            }

            if (LogType == LogType.Warning)
            {
                log.Warn(messageData);
            }

            if (LogType == LogType.Error)
            {
                log.Error(messageData);
            }

            if (LogType == LogType.Fatal)
            {
                log.Fatal(messageData);
            }

            ILoggerRepository rep = LogManager.GetRepository();
            foreach (IAppender appender in rep.GetAppenders())
            {
                var buffered = appender as BufferingAppenderSkeleton;
                if (buffered != null)
                {
                    buffered.Flush();
                }
            }

        }
    }


}
