﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Auditing
{
    public class AuditData
    {
        public int AuditId { get; set; }
        public DateTime EventDateTime { get; set; }
        public int SiteId { get; set; }
        public string UserName { get; set; }
        public bool ContainsPID { get; set; }
        public int StatusId { get; set; }
        public int FunctionId { get; set; }
        public int ObjectTypeId { get; set; }
        public int ObjectId { get; set; }
        public string ObjectName { get; set; }
        public string EventData { get; set; }

        public AuditData() { }

        public AuditData(DateTime EventDate,
                            string userName,
                            bool containsPID,
                            int objecttypeID,
                            int objectID,
                            string objectName,
                            int function,
                            int status,
                            string eventData)
        {
            EventDateTime = EventDate;
            userName = UserName;
            ContainsPID = containsPID;
            StatusId = status;
            FunctionId = function;
            ObjectTypeId = objecttypeID;
            ObjectId = objectID;
            ObjectName = objectName;
            EventData = eventData;
        }

        public AuditData(DateTime EventDate,
                            int siteID,
                            string userName,
                            bool containsPID,
                            int objecttypeID,
                            int objectID,
                            string objectName,
                            int function,
                            int status,
                            string eventData)
        {
            EventDateTime = EventDate;
            SiteId = siteID;
            userName = UserName;
            ContainsPID = containsPID;
            StatusId = status;
            ObjectTypeId = objecttypeID;
            ObjectId = objectID;
            ObjectName = objectName;
            FunctionId = function;
            EventData = eventData;
        }
    }
}
