Introduction
============
This repository provides minimal fixes to FOIA VISTA code, in order to allow
for a functioning VistA instance. These fixes are needed for both Cache and
GT.M. This repository covers only non-Kernel routine; see the Kernel-GTM
project (https://github.com/shabiel/Kernel-GTM) for Kernel infrastructure
enhancements.

Fixes are under Apache 2.0 where applicable.

List of fixes/Change Log
------------------------
 * ICDEXA2 (passim): Don't convert codes to numbers. Codes may exceed implementation defined limit for numbers.
 * GET1+3^ORWORR1: Replace && with commas for if, to enforce 'and' with no side effects.
 * EN+16^DGRPD: Errant space needs to be removed.
 * PATIENT^MPIFXMLP: Change to ZPATIENT so that it won't be found by patient registration. We can't use MPI outside of VA.

Install Instructions
--------------------
These routines are not intended for installation. Instead, a patch generated by
`git diff $(git rev-list --max-parents=0 HEAD)..HEAD -- Routines/` is intended
to be applied to OSEHRA VistA in order to fix the routines.

Documentation
-------------
No documentation beyond this document.

Internal Interfaces
-------------------
Nothing new introduced beyond existing ICRs that are being used.

External Interfaces
-------------------
None.

Package Components
------------------
No package supplied.

Checksums
---------
```
DGRPD     value = 81056945
ICDEXA2   value = 81003688
MPIFXMLP  value = 91199700
ORWORR1   value = 10672924
```

Unit Tests
----------
Routine KBANTEST checks that the fixes are in effect. On GT.M, all the tests should fail.
Expected Output:
```
 ---------------------------------- KBANTEST ----------------------------------
MPIFXMLP - PATIENT^MPIFXMLP does not exist.-------------------  [OK]    0.037ms
ICDEXA2 - ICDEXA2 will work w/o converting ICDO to numbers........
 -------------------------------------------------------------  [OK]    1.550ms
ORWORR1 - GET1^ORWORR1 contains && that crashes GTM.----------  [OK]    0.055ms
DGRPD - Printing Patient Profile. Shouldn't crash.------------  [OK]    1.986ms

Ran 1 Routine, 4 Entry Tags
Checked 11 tests, with 0 failures and encountered 0 errors.
```

Future Plans
------------
If there any other commonly used non-Kernel routines that won't work in FOIA VistA, they
may be added here.
