package gov.va.med.esr.common.model.ee;


import java.util.Date;
import java.util.Objects;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.lookup.DataChangeSource;
import gov.va.med.esr.common.model.lookup.HealthBenefitPlanType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.model.AbstractKeyedEntity;

public class HealthBenefitPlan extends AbstractKeyedEntity implements Comparable<HealthBenefitPlan> {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 2290613490102671064L;
	
    private DataChangeSource   changeSource;
    private VAFacility         changeSite;
    private Date               changeDate;
    private HealthBenefitPlanType	planType;
    private HealthBenefitProfile healthBenefitProfile;
    
    
	/**
	 * Creates a new MonetaryBenefit object.
	 */
	public HealthBenefitPlan() {
		super();
	}

	// ----------------------------------------------------------------------------
	// Public method(s)
	// ----------------------------------------------------------------------------
	public HealthBenefitProfile getHealthBenefitProfile() {
		return this.healthBenefitProfile;
	}

	public void setHealthBenefitProfile(HealthBenefitProfile healthBenefitProfile) {
		this.validateOwner(this.healthBenefitProfile, healthBenefitProfile);
		this.healthBenefitProfile = healthBenefitProfile;
	}

	public HealthBenefitPlanType getPlanType() {
		return this.planType;
	}

	public void setPlanType(HealthBenefitPlanType planType) {
		this.planType = planType;
	}

   public Date getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public DataChangeSource getChangeSource() {
        return this.changeSource;
    }

    public void setChangeSource(DataChangeSource changeSource) {
        this.changeSource = changeSource;
    }

    public VAFacility getChangeSite() {
        return this.changeSite;
    }

    public void setChangeSite(VAFacility changeSite) {
        this.changeSite = changeSite;
    }

    public int compareTo(HealthBenefitPlan o) {
      if (o != null && getPlanType() != null)
          return getPlanType().compareTo(o.getPlanType());
      else
          return 1;
    }    
    
    public boolean Equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        
        HealthBenefitPlan other = (HealthBenefitPlan) obj;
        return Objects.equals(this.getPlanType(), other.getPlanType());
    }        
 
	/* (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
        builder.append("planType", this.planType);
        builder.append("changeDate", this.changeDate);
        builder.append("changeSource", this.changeSource);
        builder.append("changeSite", this.changeSite);
	}

}
