package gov.va.med.fw.util;

import java.util.Calendar;

import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

import gov.va.med.esr.jms.ccn.outboundResponse.CcnHttpResponseObject;
import gov.va.med.esr.webservices.client.ccn.GeneralUtils;

public class DasUtil {

	private static final Logger logger = Logger.getLogger(DasUtil.class);
	
	public static String FAILURE = "FAILURE";
    public static String SUCCESS = "SUCCESS";
    public static String FAILURE_CODE = "400";
    public static String SUCCESS_CODE = "201";
    
	/**
	 * This method parses the returned SeedingRequest Response From DAS
	 * The returned JSON message will look something like the following:
	 * {"code":201,"message":"SUCCESS:Request Processed: utFDocRefSeeeding"}";
	 * The "Processed" is the X-ConversationID POST Header. This header name
	 * has the value of the document Reference Id you submitted to DAS.
	 * @param jsonMessage
	 */
	
	public CcnHttpResponseObject parseHttpReturnJSON(String jsonMessage) throws Exception, JSONException {
		
		logger.debug("In CCNClient parseHttpRetureJSON jsonMessage "+jsonMessage );
		CcnHttpResponseObject ccnHttpResponseObj = null;
		try{
			
			JSONObject json = new JSONObject(jsonMessage);
			ccnHttpResponseObj = new CcnHttpResponseObject();
			String sCode = json.get("code").toString();
			ccnHttpResponseObj.setHttpResponseCode(sCode);
			
			if (GeneralUtils.isHttpResponseCodeOk(sCode)){
				ccnHttpResponseObj.setResponseStatus(SUCCESS);
			} else {
				ccnHttpResponseObj.setResponseStatus(FAILURE);
			}			

			String sMessage = (String)json.get("message");
			if (sMessage != null){
			     String[] sMessageArr = sMessage.split(":");			     
			     ccnHttpResponseObj.setDocRefId(sMessageArr[2].trim().toString().trim());
			}
			ccnHttpResponseObj.setResponseTime(getLatestDate("yyyy-MM-ddTHH:mm:ss"));
			
		} catch(JSONException e1){
			throw new Exception("JSONException "+e1.toString());
		}
		catch(Exception e){
			logger.error("Exception In the CCNClient the parseHttpReturnJSON "+e.toString());
		    throw new Exception("Exception" + e.toString());
		}
		
		return ccnHttpResponseObj;

	}//end of method
	
	
	public CcnHttpResponseObject parseOperationOutcomeJSON(String jsonMessage, String docRefId) throws Exception, JSONException {
		
				logger.debug("In CCNClient parseHttpRetureJSON jsonMessage "+jsonMessage );
				CcnHttpResponseObject ccnHttpResponseObj = null;
				
				try{					
					JSONObject json = new JSONObject(jsonMessage);
					ccnHttpResponseObj = new CcnHttpResponseObject();
					String idText = json.get("id").toString();
					if("allok".equals(idText))
					{
						ccnHttpResponseObj.setHttpResponseCode(SUCCESS_CODE);
						ccnHttpResponseObj.setResponseStatus(SUCCESS);
					}
					else if("exception".equals(idText))
					{
						ccnHttpResponseObj.setHttpResponseCode(FAILURE_CODE);
						ccnHttpResponseObj.setResponseStatus(FAILURE);
					}    
					ccnHttpResponseObj.setDocRefId(docRefId);					
					ccnHttpResponseObj.setResponseTime(getLatestDate("yyyy-MM-ddTHH:mm:ss"));
					
				} catch(JSONException e1){
					throw new Exception("JSONException "+e1.toString());
				}
				catch(Exception e){
					logger.error("Exception In the CCNClient the parseHttpReturnJSON "+e.toString());
				    throw new Exception("Exception" + e.toString());
				}
				
				return ccnHttpResponseObj;

			}
	
	/**
	 * This method creates the Indexed and Created value for the HRIF.
	 * @param sDateFormat - "yyyy-MM-dd'T'HH:mm:ss:ss" or "yyyy-MM-ddTHH:mm:ss" as an example
	 * @return
	 */
	public static String getLatestDate(String sDateFormat){
		String sReturn = "";
		Calendar cal = Calendar.getInstance();
		
		try{
			java.text.DateFormat df = new java.text.SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:ss");
			df.setTimeZone(java.util.TimeZone.getTimeZone("Zulu"));
			sReturn = df.format(cal.getTime());
			
		}catch(Exception e){
			logger.error("In the CCNClient method getLatestDate Exception method "+e.toString());
		}
		
		return sReturn;
		
	}//end of the method
	
	public String buildJsonStringFromOperationOutcome(String jsonMessage, String docRefId, String transactionId)
	{
		JSONObject jsonObject = new JSONObject(jsonMessage);					
		String httpResponseCode="",responseStatus="";
		String idText = jsonObject.get("id").toString();
		if("allok".equals(idText))
		{
			httpResponseCode = SUCCESS_CODE;
			responseStatus = SUCCESS;
		}
		else if("exception".equals(idText))
		{
			httpResponseCode = FAILURE_CODE;
			responseStatus = FAILURE;
		}    		
		logger.debug("buildJsonStringFromOperationOutcome. transactionId: "+transactionId);
		return "{\"data\":{\"app\":\"dasOperationOutcomeForTpaFileTransfer\",\"ackdata\":[{\"ccncontractor\":\"CCN_TRW_National\",\"docRefId\":\""+docRefId+"\",\"httpresponsecode\":\""+httpResponseCode+"\",\"httpresponsedescpt\":\"null\",\"status\":\""+responseStatus+"\",\"httpresponsetime\":\""+getLatestDate("yyyy-MM-ddTHH:mm:ss")+"\",\"transactionId\":\""+transactionId+"\"}]}}";		
	}
	
	public String buildJsonStringFromCcnOperationOutcome(String jsonMessage, String docRefId, String transactionId, String theReceivingId)
	{
		JSONObject jsonObject = new JSONObject(jsonMessage);					
		String httpResponseCode="",responseStatus="";
		String idText = jsonObject.get("id").toString();
		if("allok".equals(idText))
		{
			httpResponseCode = SUCCESS_CODE;
			responseStatus = SUCCESS;
		}
		else if("exception".equals(idText))
		{
			httpResponseCode = FAILURE_CODE;
			responseStatus = FAILURE;
		}    		
		logger.debug("buildJsonStringFromOperationOutcome. transactionId: "+transactionId);
		return "{\"data\":{\"app\":\"dasOperationOutcomeForCcnFileTransfer\",\"ackdata\":[{\"ccncontractor\":\"+theReceivingId+\",\"docRefId\":\""+docRefId+"\",\"httpresponsecode\":\""+httpResponseCode+"\",\"httpresponsedescpt\":\"null\",\"status\":\""+responseStatus+"\",\"httpresponsetime\":\""+getLatestDate("yyyy-MM-ddTHH:mm:ss")+"\",\"transactionId\":\""+transactionId+"\"}]}}";		
	}
	
}
