/**
 * 
 */
package gov.va.med.esr.webservices.client.ccn;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.json.*;
import org.apache.commons.io.IOUtils;

import gov.va.med.esr.ccn.inboundRequest.CcnServiceInfoMessage;
import gov.va.med.esr.jms.ccn.outboundResponse.CcnHttpResponseObject;

/**
 * This is the adapter class that abstracts all the service API details into an ES API that ES can use.  
 * Key parameters include ICN and two SimpleAddress objects, before and after submission.  
 * Two working CIS service operations are ReadActiveContactInfo and SubmitContactInfoUpdate.
 */

public class CCNClient {

    private static final Logger logger = Logger.getLogger(CCNClient.class);

    private String ccnRestUrl;
    private String ccnSenderId;
    private String ccnReceivingIds;
    private String ccnContentType;
    private String ccnDocumentDirectory;
    private String ccnDocumentDirectoryFromDas;
	private String ccnUrlOfESRDocuments;
    private String ccnUrlOfBinaryDAS;
    private String ccnUrlOfAttachedFilesInDAS;

	public static String FAILURE = "FAILURE";
    public static String SUCCESS = "SUCCESS";
    
    public String getCcnDocumentDirectoryFromDas() {
    	logger.debug("In the CCNClient the getCcnDocumentDirectoryFromDas is "+ccnDocumentDirectoryFromDas);
		return ccnDocumentDirectoryFromDas;
	}

	public void setCcnDocumentDirectoryFromDas(String ccnDocumentDirectoryFromDas) {
		logger.debug("In the CCNClient the setCcnDocumentDirectoryFromDas is "+ccnDocumentDirectoryFromDas);
		this.ccnDocumentDirectoryFromDas = ccnDocumentDirectoryFromDas;
	}
    
    

	public String getCcnUrlOfAttachedFilesInDAS() {
		return ccnUrlOfAttachedFilesInDAS;
	}

	public void setCcnUrlOfAttachedFilesInDAS(String ccnUrlOfAttachedFilesInDAS) {
		this.ccnUrlOfAttachedFilesInDAS = ccnUrlOfAttachedFilesInDAS;
	}

    
//    private String directoryLocation = "/u02/batchProcess/CCN/ToDAS";
    public String getCcnUrlOfBinaryDAS() {
		return ccnUrlOfBinaryDAS;
	}

	public void setCcnUrlOfBinaryDAS(String ccnUrlOfBinaryDAS) {
		this.ccnUrlOfBinaryDAS = ccnUrlOfBinaryDAS;
	}
    
    public void setCcnRestUrl(String restURL) {
    	logger.debug("In the CCNClient the restURL is "+restURL);
    	this.ccnRestUrl = restURL;
    }
    
    public String getCcnRestUrl(){
    	return this.ccnRestUrl;
    }
    
    public void setCcnSenderId(String senderId) {
    	logger.debug("In the CCNClient the setCcnSenderId is "+senderId);
    	this.ccnSenderId = senderId;
    }   
    
    public void setCcnReceivingIds(String receivingIds) {
    	logger.debug("In the CCNClient the setCcnReceivingIds is "+receivingIds);
    	this.ccnReceivingIds = receivingIds;
    } 
    
    public void setCcnContentType(String ccnContentType) {
    	logger.debug("In the CCNClient the setCcnReceivingIds is "+ccnContentType);
    	this.ccnContentType = ccnContentType;
    }  
    
    public void setCcnDocumentDirectory(String ccnDocumentDirectory){
    	logger.debug("In the CCNClient the setCcnDocumentDirectory is "+ccnDocumentDirectory);
    	this.ccnDocumentDirectory = ccnDocumentDirectory; 
    	logger.debug("In the CCNClient the this.setCcnDocumentDirectory is "+this.ccnDocumentDirectory);
    }
    
    public String getCcnDocumentDirectory(){
    	return this.ccnDocumentDirectory;
    }

    public void setCcnUrlOfESRDocuments(String ccnUrlOfESRDocuments){
    	logger.debug("In the CCNClient the setCcnUrlOfESRDocument is "+ccnUrlOfESRDocuments);
    	this.ccnUrlOfESRDocuments = ccnUrlOfESRDocuments;    	
    }    

  
    
    /**
     * This method sends message to DAS
     */
    
    public CcnHttpResponseObject sendMessageToDAS1(CcnServiceInfoMessage o ) throws Exception{
    	
    	CcnHttpResponseObject ccnHttpResponseObj = null;
    	
		String URL = this.ccnRestUrl; 
		//this is the url for DAS on local
		
		BufferedReader in = null;
		HttpURLConnection conn = null;
		OutputStream os = null;
		
		final String SenderId = this.ccnSenderId;
		final String ReceivingIds = this.ccnReceivingIds;
		final String ContentType = this.ccnContentType;
		final String DocumentDirectory = this.ccnDocumentDirectory;
		final String DocumentDirectoryFromDas = this.ccnDocumentDirectoryFromDas;
		final String urlForFile = this.ccnRestUrl;
		final String ccnUrlOfESRDocuments = this.ccnUrlOfESRDocuments;
		final String ccnUrlOfBinaryDAS  = this.ccnUrlOfBinaryDAS;
		//the ReceivingIds value come from the JSON Message sent across the WebLogic CCN Request Bridge,
		//not from the applicationContext-ccn.xml which come from the deployenvspecific.properties file.
		final String ccnReceivingIds = o.getReceivingIds();
		
		String sReturn = "";
          
		try{
			String filename = o.getFileName();
			//the FileURL string to pass into createFHIRJsonRequest
			//the url will look something like the following 
			//https://DNS.URL:PORT/esr/ccnFiles/theNameOfTheFile.txt
			//this is the url that is put into the JSON request message that the VA
			//will obtain the document.
			String sURLofFile = ccnUrlOfESRDocuments + o.getFileName();
			
			logger.debug("File URL:" + sURLofFile);
			
			//get the file
			String completeFileName = DocumentDirectory+getOperatingSystemFileSeparator()+filename;
			
			logger.debug("Complete File Name:" + completeFileName);

			try {
			    logger.debug("Getting filesize and file hash...");

			    String strFile = readFile(completeFileName);
			    String sFSize = getFileSize(strFile);
			    String sFileContentsHash = getMessageDigest(strFile.getBytes());
			    
			    logger.debug("File Size is: " + sFSize );
			    logger.debug("File Hash is: " + sFileContentsHash );
			}
			catch( Exception ex) {
			    logger.debug("Exception getting filesize and file hash:", ex);
			}
			//create the FHIR Message to send to DAS for Initial "Seeding" request
			String input = createFHIRJsonRequest(sURLofFile, sFSize, sFileContentsHash, gov.va.med.fw.util.StringUtils.stripXSS(o.getDocRefId()));

			logger.debug( "JSON request is: " + input );

			URL restURL = new URL(URL);
			
			conn = (HttpURLConnection)restURL.openConnection();
			conn.setDoOutput(true);
			conn.setDoInput(true);

			conn.setRequestMethod("POST");
			conn.setRequestProperty("Content-Type","application/json+fhir");
			conn.setRequestProperty("X-ConversationID", gov.va.med.fw.util.StringUtils.stripXSS(o.getDocRefId()));
			conn.setRequestProperty("X-RoutingSenderID", SenderId);
			conn.setRequestProperty("X-RoutingReceiverIDs", gov.va.med.fw.util.StringUtils.stripXSS(o.getReceivingIds()));
			conn.setRequestProperty("X-TransactionID", gov.va.med.fw.util.StringUtils.stripXSS(o.getDocRefId()));

			os = conn.getOutputStream();
			os.write(input.getBytes());
			os.flush();
			
			
			//200,201,202 is the correct response code is a succesful message has been returned.
			String sHttpResponseCode = ""+conn.getResponseCode();
			if (!GeneralUtils.isHttpResponseCodeOk(sHttpResponseCode)){
				logger.error("In the CCNClient did not get a 201 response "+conn.getResponseCode());
				throw new RuntimeException("Failed: HTTPErrorCode "+conn.getResponseCode());
			} 
			
			in = new BufferedReader( new InputStreamReader(conn.getInputStream()));
			
			String inputLine;
			while( ( inputLine = in.readLine()) != null){
				sReturn = inputLine;
			}
			logger.debug("In the CCNClient the response from the initial Seeding request http response is "+sReturn);
            //parse the returned message into the 
			ccnHttpResponseObj =	parseHttpReturnJSON(sReturn);
			
		}//end of try
		catch(JSONException e1){
			logger.error("In Aa the CCNClient the JSONException is "+e1.toString());
			if (ccnHttpResponseObj != null) {
				ccnHttpResponseObj.setHttpResponseCode("NoCodeJSONException");
				ccnHttpResponseObj.setHttpResponesMessage(e1.toString());
				ccnHttpResponseObj.setDocRefId(o.getDocRefId());
				ccnHttpResponseObj.setResponseTime(getLatestDate("yyyy-MM-ddTHH:mm:ss"));
				ccnHttpResponseObj.setResponseStatus(this.FAILURE);		
			}
		}
		catch(Exception e){
		
			String sCode = "";
			sCode = parseStringForErrorCode(e.toString());
			//if sCode is not a Number then make sCode "UnknownCode"
			logger.error("In Aa the CCNClient the Exception is "+e.toString());
			ccnHttpResponseObj  = new CcnHttpResponseObject();
			if (isStringANumber(sCode)){
				ccnHttpResponseObj.setHttpResponseCode(sCode);
			} else {
			   ccnHttpResponseObj.setHttpResponseCode("UnknownCode");
			}
			ccnHttpResponseObj.setHttpResponesMessage(e.toString());
			ccnHttpResponseObj.setDocRefId(o.getDocRefId());
			ccnHttpResponseObj.setResponseTime(getLatestDate("yyyy-MM-ddTHH:mm:ss"));
			ccnHttpResponseObj.setResponseStatus(this.FAILURE);			

		} finally{
			
			if (os != null) {
				IOUtils.closeQuietly(os);
			}
			
			if (conn != null){
				try {
					conn.disconnect();;
				} catch (Exception e) {
					logger.error("In the CCNClient the Exception is "+e.toString());
					e.printStackTrace();
				}
			}
			
			
			if (in != null){
				try {
					in.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}

    	return ccnHttpResponseObj;
    	
    }//end of method
    

	/**
	 * @param args
	 * @throws ECISFault 
	 * Executive test driver that emulates the ES Bridge and Queues
	 */
	public static void main(String[] args) throws Exception {

		System.out.println("Tests completed!!!");
	}
	
    private static void log(String msg) {
    	if(logger.isTraceEnabled()) {
    		logger.trace(msg);
    	}
    }
 
	/**
	 * The file to be read in order to obtain the file size and create the hash to the JSON Request.
	 * @return
	 */
	public static String readFile(String completePathAndFileName){
		File f1 = null;
		FileReader fr = null;
		BufferedReader br = null;
		String sFileStr = "";
		StringBuffer sb = new StringBuffer();
		try{
			
			//String s1 = DocumentDirectory+getOperatingSystemFileSeparator()+nameOfFile;
			//logger.debug("In the  method of CCNClient complete file path "+s1);
			
			//fr = new FileReader(DocumentDirectory+getOperatingSystemFileSeparator()+nameOfFile);
			fr = new FileReader(completePathAndFileName);
			br = new BufferedReader(fr);
			
			String inputLine ;
			
			while( ( inputLine = br.readLine())  !=null    ){
				sb.append(inputLine);
			}
			
		}catch(Exception e1){
			logger.error("In the CCNClient method getMessageDigest Exception method "+e1.toString());
		} finally {
		   if (fr != null) {
		      IOUtils.closeQuietly(fr);
		   }
		}
		
		return sb.toString();
		
	}//end of method
	
	/**
	 * As part of the HFIR items in the JSON Request a int of the file size must be provided.
	 * @param sFile
	 * @return
	 */
	public static String getFileSize(String sFileContents){
		
		int iFileSize = 0;
		if (sFileContents != null){
			iFileSize = sFileContents.length();
		}
		
		return ""+iFileSize;
		
	}//end of method
	
	/**
	 * As part of the HFIR message the content must have a SHA-1 digest.
	 * @param bFile1
	 * @return
	 */
	public static String getMessageDigest(byte[] bFile1){
		
		byte[] passbyte;
		String sReturn = "";
		
		try {
			
			MessageDigest md = MessageDigest.getInstance("SHA-1");
			passbyte = md.digest(bFile1);
			//now make base64
			//this is for Java 6 to make a base64
			sReturn = DatatypeConverter.printBase64Binary(passbyte);
			
		} catch (NoSuchAlgorithmException e1) {
			logger.error("In the CCNClient method getMessageDigest Exception method "+e1.toString());
		}
		
		return sReturn;
		
	}//end of method
	
	/**
	 * This method provides the correct file separator for the directory to file to obtain from the 
	 * file system.
	 * @return
	 */	
	private static String getOperatingSystemFileSeparator(){
		
		return System.getProperty("file.separator");
		
	}//end of method
	
	
	public static String generateBase64UUID(){
		
		UUID uuid = UUID.randomUUID();
		return uuid.toString();
		
	}//end of method	
	
	/**
	 * This is the method that creates the JSON Request String to send to DAS
	 * 
	 * @param FileUrl
	 * @param filesize
	 * @param theHashOfTheFileContents
	 * @return
	 */
	public static String createFHIRJsonRequest(String FileUrl, String filesize, String theHashOfTheFileContents,
			String docRefId) {

		String sReturn = "";
		StringBuffer sb = new StringBuffer(10000);

		try {

			sb.append("{");
			sb.append("\"id\":");
			sb.append("\"");
			sb.append("DocumentReference/");
			sb.append(docRefId);
			sb.append("\"");
			sb.append(",");
			sb.append("\"resourceType\": \"DocumentReference\",");
			sb.append("\"text\": {");
			sb.append("\"fhir_comments\":[{");
			sb.append("\"div\":");
			sb.append("\"This is a text file with insurance related seeding request information, caret delimited.\"");
			sb.append("}]");
			sb.append("},");
			sb.append("\"status\": \"generated\",");
			sb.append("\"indexed\":");
			sb.append("\"");
			sb.append(getLatestDate("yyyy-MM-ddTHH:mm:ss"));
			sb.append("\",");

			sb.append("\"type\": {");
			sb.append("\"coding\":[{");
			sb.append("\"system\":");
			sb.append("\"http://loinc.org\",");
			sb.append("\"code\": \"LP173405-4\"");
			sb.append("}]");
			sb.append("},");

			sb.append("\"content\": [");
			sb.append("{");
			sb.append("\"attachment\": {");
			sb.append("\"contentType\": \"application/text\",");
			sb.append("\"data\": \"\",");
			sb.append("\"url\": ");
			sb.append("\"");
			sb.append(FileUrl);
			sb.append("\",");
			sb.append("\"language\": \"en-US\",");
			sb.append("\"size\": ");
			sb.append(filesize);
			sb.append(",");
			sb.append("\"hash\": ");
			sb.append("\"");
			sb.append(theHashOfTheFileContents);
			sb.append("\",");
			sb.append("\"title\": \"The Health-Insurance Related Seeding Request File.\"");
			sb.append("}");
			sb.append("}");
			sb.append("]");
			sb.append("}");

		} catch (Exception e) {
			logger.error("In the CCNClient method createFHIRJsonRequest Exception method " + e.toString());
		}

		return sb.toString();

	}// end of method
	

	/**
	 * This method creates the Indexed and Created value for the HRIF.
	 * @param sDateFormat - "yyyy-MM-dd'T'HH:mm:ss:ss" or "yyyy-MM-ddTHH:mm:ss" as an example
	 * @return
	 */
	public static String getLatestDate(String sDateFormat){
		String sReturn = "";
		Calendar cal = Calendar.getInstance();
		
		try{
			java.text.DateFormat df = new java.text.SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:ss");
			df.setTimeZone(java.util.TimeZone.getTimeZone("Zulu"));
			sReturn = df.format(cal.getTime());
			
		}catch(Exception e){
			logger.error("In the CCNClient method getLatestDate Exception method "+e.toString());
		}
		
		return sReturn;
		
	}//end of the method
	
	
	/**
	 * This method parses the returned SeedingRequest Response From DAS
	 * The returned JSON message will look something like the following:
	 * {"code":201,"message":"SUCCESS:Request Processed: utFDocRefSeeeding"}";
	 * The "Processed" is the X-ConversationID POST Header. This header name
	 * has the value of the document Reference Id you submitted to DAS.
	 * @param jsonMessage
	 */
	
	public CcnHttpResponseObject parseHttpReturnJSON(String jsonMessage) throws Exception, JSONException {
		
logger.debug("In CCNClient parseHttpRetureJSON jsonMessage "+jsonMessage );
		CcnHttpResponseObject ccnHttpResponseObj = null;
		try{
			
			JSONObject json = new JSONObject(jsonMessage);
			
			if (json == null){
				return null;
			}

			ccnHttpResponseObj = new CcnHttpResponseObject();

			String sCode = json.get("code").toString();
			ccnHttpResponseObj.setHttpResponseCode(sCode);
			
			//if (sCode.trim().equals("201")){
			if (GeneralUtils.isHttpResponseCodeOk(sCode)){
				ccnHttpResponseObj.setResponseStatus(this.SUCCESS);
			} else {
				ccnHttpResponseObj.setResponseStatus(this.FAILURE);
			}
			

			String sMessage = (String)json.get("message");
			if (sMessage != null){
			     String[] sMessageArr = sMessage.split(":");
                 //the thrid element should be the document ref id
			     
			     ccnHttpResponseObj.setDocRefId(sMessageArr[2].trim().toString().trim());
			}
			ccnHttpResponseObj.setResponseTime(getLatestDate("yyyy-MM-ddTHH:mm:ss"));
			
		} catch(JSONException e1){
			throw new Exception("JSONException "+e1.toString());
		}
		catch(Exception e){
			logger.error("Exception In the CCNClient the parseHttpReturnJSON "+e.toString());
		    throw new Exception("Exception" + e.toString());
		}
		
		return ccnHttpResponseObj;

	}//end of method
	
	
	/**
	 * This string will look like the following 
	 * java.lang.RuntimeException: Failed: HTTPErrorCode>500
	 * This is the retured String fromt the throw new RuntimeException
	 * This method attempts to obtaint he error code so parse on the ">" character
	 */
	private String parseStringForErrorCode(String s){
		
		String sReturn = "";
		
		try{
			
			String[] sArr = s.split(">");
			if (sArr != null){
				if (sArr.length > 1){
					//get the second element which is the http error code
					sReturn = sArr[1];
				}
			}
				
				
		}catch(Exception e){
			sReturn = "";
		}

		return sReturn;
				
	}//end of method
	
	
	/**
	 * This method is used to determine if the Http Response Code is a Number
	 * @param s
	 * @return
	 */
	private boolean isStringANumber(String s){
		
		boolean b = true;
		
		for (char c : s.toCharArray()){
			if (!Character.isDigit(c)){
				b = false;
			    break;	
			}
		}
		
		return b;
		
	}//end of method
	

	
}//end of class
