def startTransaction():
  edit()
  startEdit()
  
def commitTransaction():
  save()
  activate(block='true')

def rollbackTransaction():
  undo()
  stopEdit()

def main():
  connect()
  
  startTransaction()

  cd('/')
  cmo.createCluster('dq_cl')
  
  cd('/Clusters/dq_cl')
  cmo.setClusterMessagingMode('unicast')
  
  cd('/Clusters/dq_cl/DynamicServers/dq_cl')
  cmo.setDynamicClusterSize(0)
  cmo.setMaxDynamicClusterSize(8)
  cmo.setServerNamePrefix('dq_ms')
  cmo.setIgnoreSessionsDuringShutdown(false)
  cmo.setCalculatedMachineNames(true)
  cmo.setDynamicClusterShutdownTimeoutSeconds(0)
  cmo.setWaitForAllSessionsDuringShutdown(false)
  cmo.setCalculatedListenPorts(false)
  cmo.setMachineMatchType('name')
  cmo.setMinDynamicClusterSize(1)
  cmo.setDynamicClusterCooloffPeriodSeconds(900)
  cmo.setMachineNameMatchExpression('localhost')
  
  cd('/')
  cmo.createServerTemplate('dq_msTemplate')
  
  cd('/ServerTemplates/dq_msTemplate')
  #cmo.setCustomIdentityKeyStorePassPhraseEncrypted('Nhiappdev')
  cmo.setCustomIdentityKeyStoreType('JKS')
  cmo.setKeyStores('CustomIdentityAndCustomTrust')
  cmo.setCustomTrustKeyStorePassPhrase('changeit')
  cmo.setCustomTrustKeyStoreFileName('config/certs/trust.jks')
  cmo.setCustomTrustKeyStoreType('JKS')
  cmo.setCustomIdentityKeyStoreFileName('config/certs/SERVER.jks')
  cmo.setListenPort(7102)
  
  cd('/ServerTemplates/dq_msTemplate/SSL/dq_msTemplate')
  cmo.setHostnameVerificationIgnored(true)
  cmo.setServerPrivateKeyAlias('SERVER.DNS   ')
  cmo.setEnabled(true)
  cmo.setInboundCertificateValidation('BuiltinSSLValidationOnly')
  cmo.setOutboundCertificateValidation('BuiltinSSLValidationOnly')
  #cmo.setServerPrivateKeyPassPhraseEncrypted('Nhiappdev')
  cmo.setUseServerCerts(true)
  cmo.setListenPort(10102)
  
  cd('/ServerTemplates/dq_msTemplate/WebServer/dq_msTemplate/WebServerLog/dq_msTemplate')
  cmo.setNumberOfFilesLimited(false)
  
  cd('/ServerTemplates/dq_msTemplate/ServerStart/dq_msTemplate')
  cmo.setBeaHome('/u01/app/oracle/weblogic')
  #cmo.setPasswordEncrypted('weblogic123')
  cmo.setJavaVendor('Sun')
  cmo.setJavaHome('/u01/app/oracle/java/latest')
  cmo.setClassPath('$CLASSPATH:config/dq')
  cmo.setArguments('-Xms2048m -Xmx2048m -Djava.security.egd=file:/dev/./urandom -Dweblogic.security.SSL.minimumProtocolVersion=TLSv1')
  cmo.setUsername('weblogic')
  
  cd('/ServerTemplates/dq_msTemplate/ServerDiagnosticConfig/dq_msTemplate')
  cmo.setWLDFDiagnosticVolume('Low')
  
  cd('/Clusters/dq_cl/DynamicServers/dq_cl')
  cmo.setServerTemplate(getMBean('/ServerTemplates/dq_msTemplate'))
  cmo.setDynamicClusterSize(1)
  cmo.setMaxDynamicClusterSize(200)
  
  cd('/JDBCSystemResources/adapter')
  set('Targets',jarray.array([ObjectName('com.bea:Name=adapter_cl,Type=Cluster'), ObjectName('com.bea:Name=dq_cl,Type=Cluster')], ObjectName))
  
  cd('/JDBCSystemResources/adapter_XA')
  set('Targets',jarray.array([ObjectName('com.bea:Name=adapter_cl,Type=Cluster'), ObjectName('com.bea:Name=dq_cl,Type=Cluster')], ObjectName))
  
  commitTransaction()

main()
