#=========================================================================================================#
#                                                                                                         #
#                                          WLST_script                                                    #
# Date : 2/9/2017                                                                                         #
# Environment: 1). DEV                                                                                    #
#                                                                                                         #
# Purpose: At the end of the successful execution, it  results in, for the current Weblogic domain:       #
#    1. destroys the existing MaxThreadsConstraints object named, 'MaxThreadsConstraint-0'                #
#    2. destroys the existing MinThreadsConstraints object named, 'MinThreadsConstraint-0'                #
#    3. destroys the existing WorkManager bean object named, 'wm/Adapter'                                 #
#    4. creates 3 new WorkManagers named, a).'wm/OutboundRD', b).'wm/OutboundQD' and c)'wm/OutboundPD'    #
#    5. creates pair of MAX and MIN thread constraints for the new WorkManagers created as in 4           #
# This is an WLST offline configuration script to be run in an existing domain.                           #
#                                                                                                         #
#                                                                                                         #
# Usage:                                                                                                  #
#      java weblogic.WLST <WLST_script>  <absolute file name of the properies>                             #
#                                                                                                         #
#=========================================================================================================#

def connectToServer():
  try:
      url=protocol+ '://'+ host +':'+AdminPort
      connect(username, pwd, url)
      #connect("weblogic","weblogic123","t3://localhost:7001")
  except WLSTException:
    print ("*There was a problem connecting to server.")
    CancelEdit('y')
    exit()
    
    
def disconnectFromServer():
  if connected=="true":
    disconnect(force="true")

#this function deletes the workmanager and the ThreadConstraints
import sys
import os
import jarray
import dircache
from java.io import File
from java.lang import String
def delete_workmanager(domainName, ServerName, workManagerName, maxThreadConstraintName, minThreadConstraintName): 
   edit()
   startEdit()
   print ('======= Deleting WorkManager and attatched objects. name : ======= '+ workManagerName)
   cd('edit:/SelfTuning/' + domainName + '/WorkManagers/')
   
   delete(workManagerName,'WorkManagers')
   delete(maxThreadConstraintName,'MaxThreadsConstraints')
   delete(minThreadConstraintName,'MinThreadsConstraints')
   print (' Done. WorkManager Deleted...')
   save()
   activate(block="true")
   
#this function creates the workmanager  
import sys
import os
import jarray
import dircache
from java.io import File
from java.lang import String
def create_workmanager(domainName, ServerName, workManagerName, maxThreadConstraintName, MxThreadcount, minThreadConstraintName, MinThreadcount): 
   edit()
   startEdit()
   print ('======= Creating a WorkManager name as =======' + workManagerName)
   cd('edit:/SelfTuning/' + domainName + '/WorkManagers/')

   #cmo.unSet('ConnectionPoolName')

   create(workManagerName,'WorkManagers')
   cd('edit:/SelfTuning/' + domainName + '/WorkManagers/' + workManagerName)
   cmo.addTarget(getMBean("/Servers/"+ ServerName))
   #cmo.addTarget(getMBean("/Servers/"+ "adapter_devl_admin"))
   save()
   print (' WorkManager Created...')

   print ('======= Creating MaxThreadsConstraint =======' + maxThreadConstraintName)
   cd('edit:/SelfTuning/' + domainName + '/MaxThreadsConstraints/')
   try:
     create(maxThreadConstraintName,'MaxThreadsConstraints')
   except Exception:
     print ('Issue in Creating MaxThreads exiting')
   cd('edit:/SelfTuning/' + domainName + '/MaxThreadsConstraints/' + maxThreadConstraintName)
   cmo.addTarget(getMBean("/Servers/"+ ServerName))
   set('Count',MxThreadcount)
   save()

   print ('======= Creating MinThreadsConstraint =======' + minThreadConstraintName)
   cd('edit:/SelfTuning/' + domainName + '/MinThreadsConstraints/')
   try:
     create(minThreadConstraintName,'MinThreadsConstraints')
   except Exception:
     print ('Issue In Creating MinThreads ')
   cd ('edit:/SelfTuning/' + domainName + '/MinThreadsConstraints/' + minThreadConstraintName)
   cmo.addTarget(getMBean("/Servers/"+ ServerName))
   set('Count',MinThreadcount)
   save()

   print ('======= Assigning the MaxThreadConstraint to the WorkManager =======')
   cd('edit:/SelfTuning/' + domainName + '/WorkManagers/' + workManagerName)
   bean=getMBean('/SelfTuning/' + domainName + '/MaxThreadsConstraints/' + maxThreadConstraintName)
   cmo.setMaxThreadsConstraint(bean)
   save()

   print ('======= Assigning the MinThreadConstraint to the WorkManager =======')
   cd('edit:/SelfTuning/' + domainName + '/WorkManagers/' + workManagerName)
   bean=getMBean('/SelfTuning/' + domainName + '/MinThreadsConstraints/' + minThreadConstraintName)
   cmo.setMinThreadsConstraint(bean)

   save()
   activate(block="true")
   #disconnect()

   

def readFile():
      delWM = {}
      addWM = {}
      del_list=[]
      add_list=[]
      f = open(sys.argv[1])
      for line in f:
        if not line.strip().startswith("#"):
          if '=' in line:
		key, value = line.split('=')
		#print(key +' = '+value)
		if 'add_workmanager' in key:
		  addWM[key] = value
		  add_list.append(value)
		if 'del_workmanager' in key:
		  delWM[key] = value
		  del_list.append(value)
           
      f.close()
      
      return del_list, add_list
      
def main():
  hideDisplay()
  hideDumpStack('true')
  

  if len(sys.argv)==2:
    propertiesFile = sys.argv[1]
  else :
    print('***************************************************************************************************')
    print('Error: This program takes one and only one argument in the command line.')
    print('Please supply the absolute file name of the properties file in the commandline args list.')
    print('usage: ....wlserver\server\bin> java weblogic.WLST <installWKMGR.py> <installWKMGR.properties>. exiting')
    print('***************************************************************************************************')
    exit()
    
  
  
  #propertiesFile="C:/vetsez/ehx17/py scripts/latest_2_3_2017/install.properties"
  loadProperties(propertiesFile)
  del_list, add_list = readFile()
  try:
      #connectToServer('weblogic','weblogic123','t3://localhost:7001')
      
      connectToServer()
      
      
      ########################################
      # create WorkManagers
      ########################################
      
      
      #start create_workmanagers now...
     
      if connected=="true":
        for index in range(len(add_list)):
        # print (i, val)
          #create_workmanager(domainName, ServerName, sygma_list[index][0], sygma_list[index][1], int(sygma_list[index][2]), sygma_list[index][3], int(sygma_list[index][4]))
          sygma_list = add_list[index].split( )
          create_workmanager(domainName, ServerName, sygma_list[0], sygma_list[1], int(sygma_list[2]), sygma_list[3], int(sygma_list[4]))
      else:
        print ("Failed to connect to server.")
     
      #end create_workmanagers now...

      #start delete_workmanagers now...
      if connected=="true":
        for index in range(len(del_list)):
          delta_list = del_list[index].split( )
          delete_workmanager(domainName, ServerName, delta_list[0], delta_list[1], delta_list[2])
      else:
        print ("Failed to connect to server.")

      #end delete_workmanagers now...
      
      print ('==> WorkManager Creation Finished ... Please Double Check from AdminConsole...')
  finally:
    disconnectFromServer()
    hideDumpStack('false')

main()
