#!/bin/sh

echo "Installing Dependencies"
yum -y install libaio initscripts zip unzip vim bc net-tools openssl

echo "Adding oracle user."
groupadd dba
useradd oracle -g dba
mkdir -p /u01/app
chown -R oracle:dba /u01/app

echo "Adding USER     to dba group."
usermod -a -G dba USER    

echo "Downloading installers..."
SOFTWARE_DIR="/u01/provision/Software/ehx"
if [ ! -d $SOFTWARE_DIR ]; then
  mkdir -p $SOFTWARE_DIR
  curl https://downloads.vetsez.net/Downloads/jdk-8u121-linux-x64.tar.gz -o $SOFTWARE_DIR/jdk-8u121-linux-x64.tar.gz
  curl https://downloads.vetsez.net/Downloads/fmw_12.2.1.2.0_wls_Disk1_1of1.zip -o $SOFTWARE_DIR/fmw_12.2.1.2.0_wls_Disk1_1of1.zip
  curl https://downloads.vetsez.net/Downloads/oracle-xe-11.2.0-1.0.x86_64.rpm.zip -o $SOFTWARE_DIR/oracle-xe-11.2.0-1.0.x86_64.rpm.zip
fi

echo "Installing JDK."
if [ ! -d /u01/app/oracle/java ]; then
  runuser -l oracle << STOP
  mkdir -p /u01/app/oracle/java
  tar -C /u01/app/oracle/java -xzf /u01/provision/Software/ehx/jdk-8u121-linux-x64.tar.gz
  pushd /u01/app/oracle/java
  ln -s jdk1.8.0_121 latest
  popd
STOP
else
  echo "JDK already installed!"
fi

echo "Instaling weblogic"
if [ ! -d /u01/app/oracle/oraInventory ]; then
  runuser -l oracle << STOP
  echo "  Creating oraInst.loc."
  mkdir -p /u01/app/oracle/oraInventory
  cat << STOP2 >/u01/app/oracle/oraInventory/oraInst.loc
  inventory_loc=/u01/app/oracle/oraInventory
  inst_group=dba
STOP2
  echo "  Running WebLogic Installer."
  export JAVA_HOME=/u01/app/oracle/java/latest
  pushd /tmp
  unzip /u01/provision/Software/ehx/fmw_12.2.1.2.0_wls_Disk1_1of1.zip
  /u01/app/oracle/java/latest/bin/java -Djava.security.egd=file:/dev/./urandom -jar fmw_12.2.1.2.0_wls.jar -silent -responseFile /u01/provision/wls.rsp -invPtrLoc /u01/app/oracle/oraInventory/oraInst.loc
  echo "  Configure WebLogic to use /dev/urandom."
  cat << STOP2 >>/u01/app/oracle/weblogic/oracle_common/common/bin/commBaseEnv.sh
  # use /dev/urandom to generate random numbers to speed up weblogic.
  # change made here so that everything we use in WL installation
  # CAN benefit.
  export JAVA_OPTIONS="\\\$JAVA_OPTIONS -Djava.security.egd=file:/dev/./urandom"
  export CONFIG_JVM_ARGS="\\\$CONFIG_JVM_ARGS -Djava.security.egd=file:/dev/./urandom"
STOP2
STOP
else
  echo "Weblogic is already installed!"
fi

echo "Installing Oracle XE"
unzip $SOFTWARE_DIR/oracle-xe-11.2.0-1.0.x86_64.rpm.zip -d /tmp/XE
pushd /tmp/XE/Disk1
rpm -ivh oracle-xe-11.2.0-1.0.x86_64.rpm >/tmp/XE/install.log
/etc/init.d/oracle-xe configure responseFile=/u01/provision/xe.rsp >>/tmp/XE/install.log
popd

echo "Add Java, Oracle and WebLogic to paths."
tee -a ~USER    /.bash_profile ~oracle/.bash_profile << STOP
export JAVA_HOME=/u01/app/oracle/java/latest
export WL_HOME=/u01/app/oracle/weblogic
export PATH=\$WL_HOME/oracle_common/common/bin:\$JAVA_HOME/bin:\$PATH
. /u01/app/oracle/product/11.2.0/xe/bin/oracle_env.sh
STOP
tee -a ~USER    /.bashrc ~oracle/.bashrc << STOP
alias debugwl='cd /u01/app/domains/ehx_devl && ./startDomainDebug.sh'
alias debugwlm='cd /u01/app/domains/ehx_devl && ./startDomainDebugWithMocks.sh'
alias stopwl='cd /u01/app/domains/ehx_devl && bin/stopWebLogic.sh'
alias logwl='cd /u01/app/domains/ehx_devl && tail -f servers/admin/logs/ehx_devl.out'
STOP

echo "Set up the eHX schema."
echo "  Log output can be found in /tmp/BuildDB.log."
runuser -l oracle << STOP
pushd /u01/provision/DBScripts
. ./BuildDB.sh &>/tmp/BuildDB.log
popd
STOP

echo "Set up ehx_devl weblogic domain."
runuser -l USER     << STOP
wlst.sh /u01/provision/ehx_devl.py
cp /u01/provision/weblogic/* /u01/app/domains/ehx_devl
STOP

echo "Give everyone in dba group write permission on /u01/app."
chmod -R g+w /u01/app
