<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:n3="http://www.w3.org/1999/xhtml"
	xmlns:n1="urn:hl7-org:v3"
	xmlns:n2="urn:hl7-org:v3/meta/voc"
	xmlns:sdtc="urn:hl7-org:sdtc"
	xmlns:voc="urn:hl7-org:v3/voc"
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:section="urn:gov.va.med"
	xmlns:msxsl="urn:schemas-microsoft-com:xslt">

	<xsl:import href="cda2detailCommon.xslt"/>
	<xsl:import href="detailCommon.xsl"/>
	<xsl:import href="../common.xsl"/>
	<xsl:output method="html" indent="yes" version="4.01" encoding="ISO-8859-1"/>

	<xsl:template name="displaySource">
		<head>
			<link type="text/css" href="nhin.css" rel="stylesheet"/>

			<h2 align="center">
				<xsl:call-template name="documentTitle">
					<xsl:with-param name="root" select="."/>
				</xsl:call-template>
			</h2>
		</head>
	</xsl:template>

	<xsl:template name="displayTitle">
		<div style="text-align:center;">
			<span style="font-size:larger;font-weight:bold">
				<xsl:value-of select="n1:code/@displayName"/>
			</span>
		</div>
	</xsl:template>

	<xsl:template name="displayReportDates">
		<b>
			<xsl:text>Created On: </xsl:text>
		</b>
		<xsl:call-template name="getCreatedOnDate"/>
		<xsl:if test="n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:low/@value">
			<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
			<b>
				<xsl:text>Date Range: </xsl:text>
			</b>
			<xsl:choose>
				<xsl:when test="string-length(n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:low/@value)=0">
					<xsl:call-template name="na"/>
				</xsl:when>
				<xsl:when test="starts-with(n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:low/@value,' ')">
					<xsl:call-template name="na"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="formatDateLong">
						<xsl:with-param name="dateString" select="n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:low/@value"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			<b>
				<xsl:text disable-output-escaping="yes"> - </xsl:text>
			</b>
			<xsl:choose>
				<xsl:when test="string-length(n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:high/@value)=0">
					<xsl:call-template name="na"/>
				</xsl:when>
				<xsl:when test="starts-with(n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:high/@value,' ')">
					<xsl:call-template name="na"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="formatDateLong">
						<xsl:with-param name="dateString" select="n1:documentationOf/n1:serviceEvent/n1:performer/n1:effectiveTime/n1:high/@value"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="displayPatientBlock">
		<table width='100%' class="first">
			<xsl:variable name="patientRole" select="n1:recordTarget/n1:patientRole"/>
			<tr>
				<td width='15%' valign="top">
					<b>
						<xsl:text>Patient: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:choose>
						<xsl:when test="$patientRole/n1:patient/n1:name[@use='L']"> 
							<xsl:call-template name="getName">
								<xsl:with-param name="name" select="$patientRole/n1:patient/n1:name[@use='L']"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="getName">
								<xsl:with-param name="name" select="$patientRole/n1:patient/n1:name"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="$patientRole/n1:addr">
						<xsl:call-template name="getAddress">
							<xsl:with-param name="addr" select="$patientRole/n1:addr"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:choose>
						<xsl:when test="$patientRole/n1:telecom/@value">
							<xsl:for-each select="$patientRole/n1:telecom">
								<xsl:call-template name="getTelecom">
									<xsl:with-param name="telecom" select="."/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<br/>
							<b>
								<xsl:text>tel: </xsl:text>
							</b>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td width='15%' align='right' valign="top">
					<b>
						<xsl:text>Patient ID: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:if test="string-length($patientRole/n1:id/@extension)>0">
						<xsl:value-of select="$patientRole/n1:id/@extension"/>
					</xsl:if>
				</td>
			</tr>

			<!-- Alternative/Former Names -->
			<xsl:if test="$patientRole/n1:patient/n1:name[@use='P']">
			<tr>
				<td width='15%' valign="top">
					<b>
						<xsl:text>Alias or Former Names: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:for-each select="$patientRole/n1:patient/n1:name[@use='P']">
						<xsl:call-template name="getName">
							<xsl:with-param name="name" select="."/>
						</xsl:call-template>
						<br/>
					</xsl:for-each>
				</td>
			</tr>
			</xsl:if>
			
			<tr>
				<td width='15%' valign="top">
					<b>
						<xsl:text>Birthdate: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:call-template name="formatDateLong">
						<xsl:with-param name="dateString" select="$patientRole/n1:patient/n1:birthTime/@value"/>
					</xsl:call-template>
				</td>
				<td width='15%' align='right' valign="top">
					<b>
						<xsl:text>Sex: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:call-template name="getGenderString"/>
				</td>
			</tr>

			<tr>
				<td width='15%' valign="top">
					<b>
						<xsl:text>Birthplace: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:if test="$patientRole/n1:patient/n1:birthplace/n1:place/n1:addr">
						<xsl:call-template name="getAddress">
							<xsl:with-param name="addr" select="$patientRole/n1:patient/n1:birthplace/n1:place/n1:addr"/>
						</xsl:call-template>
					</xsl:if>
				</td>
				<td width='15%' align='right' valign="top">
					<b>
						<xsl:text>Marital Status: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:choose>
						<xsl:when test="$patientRole/n1:patient/n1:maritalStatusCode/@displayName">
							<xsl:value-of select="$patientRole/n1:patient/n1:maritalStatusCode/@displayName"/>
						</xsl:when>
					</xsl:choose>
				</td>
			</tr>

			<tr>
				<td width='15%' valign="top"/>
				<td width='35%' valign="top"/>
				<td width='15%' align='right' valign="top">
					<b>
						<xsl:text>Religious Affiliation: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:choose>
						<xsl:when test="$patientRole/n1:patient/n1:religiousAffilliationCode/@displayName">
							<xsl:value-of select="$patientRole/n1:patient/n1:religiousAffilliationCode/@displayName"/>
						</xsl:when>
					</xsl:choose>
				</td>
			</tr>

			<tr>
				<td width='15%' valign="top"/>
				<td width='35%' valign="top"/>
				<td width='15%' align='right' valign="top">
					<b>
						<xsl:text>Race: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:for-each select="$patientRole/n1:patient/n1:raceCode">
						<xsl:choose>
							<xsl:when test="$patientRole/n1:patient/n1:raceCode/@displayName">
								<xsl:value-of select="$patientRole/n1:patient/n1:raceCode/@displayName"/>
								<br/>
							</xsl:when>
						</xsl:choose>
					</xsl:for-each>
				</td>
			</tr>

			<tr>
				<td width='15%' valign="top"/>
				<td width='35%' valign="top"/>
				<td width='15%' align='right' valign="top">
					<b>
						<xsl:text>Ethnicity: </xsl:text>
					</b>
				</td>
				<td width='35%' valign="top">
					<xsl:choose>
						<xsl:when test="$patientRole/n1:patient/n1:ethnicGroupCode/@displayName">
							<xsl:value-of select="$patientRole/n1:patient/n1:ethnicGroupCode/@displayName"/>
						</xsl:when>
					</xsl:choose>
				</td>
			</tr>

			<xsl:variable name="hasLanguages">
				<xsl:call-template name="isLanguageFound">
					<xsl:with-param name="patientRole" select="$patientRole"/>
				</xsl:call-template>
			</xsl:variable>
			<tr>
				<td width="15%" valign="top">
					<b>
						<xsl:text>Language(s):</xsl:text>
					</b>
				</td>
				<td width="35%" valign="top">
				<xsl:choose>
					<xsl:when test="$hasLanguages='true'">
						<xsl:call-template name="displayLanguages">
							<xsl:with-param name="patientRole" select="$patientRole"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise><xsl:text>--</xsl:text></xsl:otherwise>
				</xsl:choose>
				</td>
				<td width="15%" valign="top"></td>
				<td width="35%" valign="top"></td>
			</tr>
		</table>
	</xsl:template>

	<xsl:template match="n1:languageCode">
		<xsl:variable name="codeString">
			<xsl:apply-templates select="." mode="data"/>
		</xsl:variable>
		<xsl:if test="string-length(normalize-space($codeString))>0">
			<li>
				<xsl:value-of select="$codeString"/>
			</li>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="displayAuthorBlock">
		<br/>
		<table width='100%' class="first">
			<tr>
				<td width="15%" valign="top">
					<b>
						<xsl:text>Authoring Date: </xsl:text>
					</b>
				</td>
				<td width="35%" valign="top">
					<xsl:variable name="dateString">
						<xsl:choose>
							<xsl:when test="string-length(./n1:author/n1:time/@value)>0"> 
								<xsl:value-of select="./n1:author/n1:time/@value"/>
							</xsl:when>
							<xsl:when test="string-length(./n1:author/n1:time/n1:low/@value)>0"> 
								<xsl:value-of select="./n1:author/n1:time/n1:low/@value"/>
							</xsl:when>
							<xsl:when test="string-length(./n1:author/n1:time/n1:high/@value)>0"> 
								<xsl:value-of select="./n1:author/n1:time/n1:high/@value"/>
							</xsl:when>
						</xsl:choose>
					</xsl:variable>
					<xsl:call-template name="formatDateShort">
						<xsl:with-param name="dateString" select="$dateString"/>
					</xsl:call-template> 
				</td>
			</tr>
			<xsl:for-each select="n1:author">
			<tr>
				<td width="15%" valign="top">
					<b>
						<xsl:text>Authoring Source: </xsl:text>
					</b>
				</td>
				<td width="35%" valign="top">
					
					<!--<b><xsl:text>Assigned Author</xsl:text></b><br/>-->
					<xsl:variable name="authorName">
						<xsl:call-template name="getName">
							<xsl:with-param name="name" select="./n1:assignedAuthor/n1:assignedPerson/n1:name"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$authorName='' or string-length($authorName)=0">
							<b><xsl:text>Author Name not given</xsl:text></b> 
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$authorName"/>
						</xsl:otherwise>
					</xsl:choose>
					
					<xsl:if test="./n1:assignedAuthor/n1:addr">
						<xsl:call-template name="getAddress">
							<xsl:with-param name="addr" select="./n1:assignedAuthor/n1:addr"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:choose>
						<xsl:when test="./n1:assignedAuthor/n1:telecom">
							<xsl:for-each select="./n1:assignedAuthor/n1:telecom">
								<xsl:call-template name="getTelecom">
									<xsl:with-param name="telecom" select="."/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<br/><b><xsl:text>tel: AUTHOR PHONE MISSING</xsl:text></b>
						</xsl:otherwise>
					</xsl:choose>
					<br/>
					<br/>
					<!-- <b><xsl:text>Organization</xsl:text></b><br/>-->
					<xsl:call-template name="getName">
						<xsl:with-param name="name" select="./n1:assignedAuthor/n1:representedOrganization/n1:name"/>
					</xsl:call-template>
					<xsl:if test="./n1:assignedAuthor/n1:representedOrganization/n1:addr">
						<xsl:call-template name="getAddress">
							<xsl:with-param name="addr" select="./n1:assignedAuthor/n1:representedOrganization/n1:addr"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:choose>
						<xsl:when test="./n1:assignedAuthor/n1:representedOrganization/n1:telecom">
							<xsl:for-each select="./n1:assignedAuthor/n1:representedOrganization/n1:telecom">
								<xsl:call-template name="getTelecom">
									<xsl:with-param name="telecom" select="."/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<br/><b><xsl:text>tel: ORGANIZATION PHONE MISSING</xsl:text></b>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td width="15%" valign="top"/>
				<td width="35%" valign="top"/>
			</tr>
			</xsl:for-each>
	
		</table>
	</xsl:template>
	
	<xsl:template name="getOrganizationInfo">
		<xsl:param name="orgBlock"/>
		<xsl:call-template name="getName">
			<xsl:with-param name="name" select="$orgBlock/n1:name"/>
		</xsl:call-template>
		<xsl:if test="$orgBlock/n1:addr">
			<xsl:call-template name="getAddress">
				<xsl:with-param name="addr" select="$orgBlock/n1:addr"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:choose>
			<xsl:when test="$orgBlock/n1:telecom">
				<xsl:for-each select="$orgBlock/n1:telecom">
					<xsl:call-template name="getTelecom">
						<xsl:with-param name="telecom" select="."/>
					</xsl:call-template>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<br/><b><xsl:text>tel: ORGANIZATION PHONE MISSING</xsl:text></b>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="displaySourceBlock">
		<table width="100%" class="second">
			<tr>
				<td width="15%" valign="top">
					<b>
						<xsl:text>Custodian Source:</xsl:text>
					</b>
				</td>
				<td width="35%" valign="top">
				<xsl:choose>
					<xsl:when test="./n1:informant">
						<xsl:for-each select="./n1:informant">
							<xsl:call-template name="getOrganizationInfo">
								<xsl:with-param name="orgBlock" select="./n1:assignedEntity/n1:representedOrganization"/>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:when>
					<xsl:when test="./n1:custodian">
						<xsl:for-each select="n1:custodian">
							<xsl:call-template name="getOrganizationInfo">
								<xsl:with-param name="orgBlock" select="./n1:assignedCustodian/n1:representedCustodianOrganization"/>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="getOrganizationInfo">
							<xsl:with-param name="orgBlock" select="./n1:assignedAuthor/n1:representedOrganization"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>						
				</td> 
				<td width="15%" valign="top"/>
				<td width="35%" valign="top"/>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template name="displayHcProviderBlock">
		<xsl:if test="n1:documentationOf/n1:serviceEvent/n1:performer">
			<br/>
			<br/>
			<b><xsl:text>Providers:</xsl:text></b> 
			<table style="font-size:14p" border="1">
				<thead>
					<tr>
						<th class="first">Provider Name</th>
						<th class="first">Provider's Organization</th>
						<th class="first">Provider Role</th>
						<th class="first">Phone/Email/URL</th>
						<th class="first">Address</th>
						<th class="first">Date Range</th>
						<th class="first">Provider Type</th>
						<th class="first">Provider ID</th>
						<th class="first">Provider Patient ID</th>
					</tr>
				</thead>
				<tbody>
			<xsl:for-each select="n1:documentationOf/n1:serviceEvent/n1:performer">
					<tr>
						<!-- Provider Name  -->
						<td class="second">
							<xsl:variable name="entryName">
								<xsl:call-template name="getName">
									<xsl:with-param name="name" select="./n1:assignedEntity/n1:assignedPerson/n1:name"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:variable name="providerName">
								<xsl:choose>
									<xsl:when test="string-length($entryName)>0">
										<xsl:value-of select="$entryName"/>
									</xsl:when>
									<xsl:otherwise>--</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$providerName"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
							</div>
						</td>
						
						<!-- Provider Org -->
						<td class="second">
							<xsl:variable name="orgName">
								<xsl:choose>
									<xsl:when test="./n1:assignedEntity/n1:representedOrganization/n1:name and string-length(./n1:assignedEntity/n1:representedOrganization/n1:name)>0">
										<xsl:value-of select="./n1:assignedEntity/n1:representedOrganization/n1:name"/>
									</xsl:when>
									<xsl:otherwise>--</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$orgName"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
							</div>
						</td>
						
						<!-- Provider Role  -->
						<td class="second">
							<xsl:variable name="role">
								<xsl:call-template name="getProviderRole">
									<xsl:with-param name="performer" select="."/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:variable name="providerRole">
								<xsl:choose>
									<xsl:when test="string-length($role)>0">
										<xsl:value-of select="$role"/>
									</xsl:when>
									<xsl:otherwise>--</xsl:otherwise>
								</xsl:choose>
							</xsl:variable>
							<div style="overflow:hidden; white-space:nowrap; width:200px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$providerRole"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
							</div>
						</td>
						
						<!-- Provider Phone/email/URL -->
						<td class="second">	
							<div style="overflow:hidden; white-space:nowrap; width:200px;">
							<xsl:variable name="telecomStr">
								<xsl:for-each select="./n1:assignedEntity/n1:telecom">
									<xsl:value-of select="./@value"/>
								</xsl:for-each>
							</xsl:variable>
							<xsl:choose>
								<xsl:when test="$telecomStr and string-length($telecomStr)>0">
									<xsl:value-of select="$telecomStr"/><xsl:text> </xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>--</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
							</div>
						</td>
						
						<!-- Provider Address -->
						<td class="second" >
							<div style="overflow:hidden; white-space:nowrap; width:200px;">
							<xsl:variable name="addrStr">
								<xsl:if test="./n1:assignedEntity/n1:addr">
									<xsl:call-template name="getSingleLineAddress">
										<xsl:with-param name="addr" select="./n1:assignedEntity/n1:addr"/>
									</xsl:call-template>
								</xsl:if>
							</xsl:variable>
							<xsl:choose>
								<xsl:when test="$addrStr and string-length($addrStr) > 0">
									<xsl:value-of select="$addrStr"/>
								</xsl:when>
								<xsl:otherwise><xsl:text>--</xsl:text></xsl:otherwise>
							</xsl:choose>
							</div>
						</td>
						
						<!-- Date Range -->
						<xsl:variable name="startDateString">
							<xsl:call-template name="formatDateShort">
								<xsl:with-param name="dateString" select="./n1:time/n1:low/@value"/>
							</xsl:call-template> 
						</xsl:variable>
						
						<xsl:variable name="endDateString">
							<xsl:call-template name="formatDateShort">
								<xsl:with-param name="dateString" select="./n1:time/n1:high/@value"/>
							</xsl:call-template> 
						</xsl:variable>
						
						<td class="second">
							<div style="overflow:hidden; white-space:nowrap; width:200px;">
							<xsl:choose>
								<xsl:when test="string-length($startDateString) = 0 and string-length($endDateString) > 0">
									<xsl:value-of select="$endDateString"/>
								</xsl:when>
								<xsl:when test="string-length($startDateString) > 0 and string-length($endDateString) = 0">
									<xsl:value-of select="$startDateString"/>
								</xsl:when>
								<xsl:when test="string-length($startDateString) > 0 and string-length($endDateString) > 0">
									<xsl:value-of select="$startDateString"/> - <xsl:value-of select="$endDateString"/>
								</xsl:when>
								<xsl:otherwise><xsl:text>--</xsl:text></xsl:otherwise>
							</xsl:choose>
							</div>
						</td>
						
						<!-- Provider Type  -->
						<td class="second">
							<div style="overflow:hidden; white-space:nowrap; width:200px;">
							<xsl:choose>
								<xsl:when test="./n1:assignedEntity/n1:code/@displayName">
									<xsl:value-of select="./n1:assignedEntity/n1:code/@displayName"/>
								</xsl:when>
								<xsl:when test="./n1:assignedEntity/n1:code/@code">
									<xsl:choose>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '100000000X'">
											<xsl:text>Behavioral Health and Social Service Providers</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '110000000X'"> 
											<xsl:text>Chiropractic Providers</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '120000000X'"> 
											<xsl:text>Dental Providers</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '130000000X'"> 
											<xsl:text>Dietary and Nutritional Service Providers</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '140000000X'"> 
											<xsl:text>Emergency Medical Service Providers</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '150000000X'"> 
											<xsl:text>Eye and Vision Service Providers</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '160000000X'"> 
											<xsl:text>Nursing Service Providers</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '180000000X'"> 
											<xsl:text>Pharmacy Service Providers (Individuals)</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '200000000X'"> 
											<xsl:text>Allopathic &amp; Osteopathic Physicians</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '210000000X'"> 
											<xsl:text>Podiatric Medicine and Surgery Providers</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '220000000X'"> 
											<xsl:text>Respiratory, Rehabilitative and Restorative Service Providers</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '230000000X'"> 
											<xsl:text>Speech, Language and Hearing Providers</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '250000000X'"> 
											<xsl:text>Agencies</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '260000000X'"> 
											<xsl:text>Ambulatory Health Care Facilities</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '280000000X'"> 
											<xsl:text>Hospitals</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '290000000X'"> 
											<xsl:text>Laboratories</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '300000000X'"> 
											<xsl:text>Managed Care Organizations</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '310000000X'"> 
											<xsl:text>Nursing and Custodial Care Facilities</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '320000000X'"> 
											<xsl:text>Residential Treatment Facilities</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '330000000X'"> 
											<xsl:text>Suppliers (including Pharmacies and Durable Medical Equipment)</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '360000000X'"> 
											<xsl:text>Physician Assistants and Advanced Practice Nursing Providers</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '370000000X'"> 
											<xsl:text>Nursing Service Related Providers</xsl:text> 
										</xsl:when>
										<xsl:when test="./n1:assignedEntity/n1:code/@code = '380000000X'"> 
											<xsl:text>Respite Care Facility</xsl:text> 
										</xsl:when>
									</xsl:choose>
								</xsl:when>
								<xsl:when test="./n1:assignedEntity/n1:code/n1:originalText">
									<xsl:value-of select="./n1:assignedEntity/n1:code/n1:originalText"/>
								</xsl:when>
								<xsl:otherwise><xsl:text>--</xsl:text></xsl:otherwise>
							</xsl:choose>
							</div>
						</td>
						
						<!-- National Provider Id -->
						<td class="second">
							<div style="overflow:hidden; white-space:nowrap; width:200px;">
							<xsl:choose>
								<xsl:when test="./n1:assignedEntity/n1:id/@extension">
									<xsl:value-of select="./n1:assignedEntity/n1:id/@extension"/>
								</xsl:when>
								<xsl:otherwise><xsl:text>--</xsl:text></xsl:otherwise>
							</xsl:choose>
							</div>
						</td>
						
						<!-- Provider Patient ID -->
						<td class="second">
							<div style="overflow:hidden; white-space:nowrap; width:200px;">
							<xsl:choose>
								<xsl:when test="./n1:assignedEntity/sdtc:patient/sdtc:id/@extension">
									<xsl:value-of select="./n1:assignedEntity/sdtc:patient/sdtc:id/@extension"/>
								</xsl:when>
								<xsl:otherwise><xsl:text>--</xsl:text></xsl:otherwise>
							</xsl:choose>
							</div>
						</td>
					</tr>	
			</xsl:for-each>
			</tbody>
		</table>
		<br/>
		<br/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="displayTableOfContents">
		<div style="margin-bottom:35px">
			<h3>
				<a name="toc">Table of Contents</a>
			</h3>
			<ul>
				<xsl:for-each select="n1:component/n1:structuredBody/n1:component/n1:section/n1:title">
					<xsl:sort/>
					<xsl:variable name="compFound">
						<xsl:call-template name="componentFound">
							<xsl:with-param name="compSection" select="../."/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($compFound)>0">
							<li>
								<a style="font-family:georgia;font-size:12pt"  href="#{generate-id(.)}">
									<xsl:value-of select="."/>
								</a>
							</li>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
			</ul>
		</div>
	</xsl:template>

	<xsl:template name="displayContents">
		<xsl:apply-templates select="n1:component/n1:structuredBody/n1:component">
			<xsl:sort select="n1:section/n1:title"/>
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template name="displayContactInfoBlock">
	
		<table width='100%' class="first">
			<!-- 
			<tr>
				<td width="15%" valign="top" align='left'>
					<b>Contacts: </b>
				</td>
				<td width="85%"/>
			</tr>
			-->
			<xsl:for-each select="n1:participant[@typeCode='IND']/n1:associatedEntity">
				<tr>
					<td width="15%" valign="top" align='left'>
						<b>Contact: </b>
					</td>
					<td width="35%" valign="top">
						<xsl:call-template name="getParticipant">
							<xsl:with-param name="participant" select="."/>
						</xsl:call-template>
					</td>
					<td/>
				</tr>
				<tr>
					<td width="15%" valign="top" align='left'/>
					<td/>
					<td/>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>

	<xsl:template name="getParticipant">
		<xsl:param name="participant"/>
		<p>
			<xsl:call-template name="getName">
				<xsl:with-param name="name" select="$participant/n1:associatedPerson/n1:name"/>
			</xsl:call-template>
			<xsl:if test="$participant/n1:addr">
				<xsl:choose>
					<xsl:when test="$isKaiser">
						<xsl:call-template name="getSingleAddress">
							<xsl:with-param name="addr" select="$participant/n1:addr"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="getAddress">
							<xsl:with-param name="addr" select="$participant/n1:addr"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="$participant/n1:telecom/@value">
					<xsl:for-each select="$participant/n1:telecom">
						<xsl:call-template name="getTelecom">
							<xsl:with-param name="telecom" select="."/>
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<br/>
					<b>
						<xsl:text>tel: CONTACT PHONE MISSING</xsl:text>
					</b>
				</xsl:otherwise>
			</xsl:choose>
			<br/>
			<b>Relationship: </b>
			<xsl:if test="$participant/n1:code">
				<xsl:choose>
					<xsl:when test="$participant/n1:code/@displayName">
						<xsl:value-of select="$participant/n1:code/@displayName"/>
					</xsl:when>
					<xsl:when test="$participant/n1:code/n1:originalText">
						<xsl:value-of select="$participant/n1:code/n1:originalText"/>
					</xsl:when>
					<xsl:when test="$participant/n1:code/@code">
						<xsl:value-of select="$participant/n1:code/@code"/>
					</xsl:when>
				</xsl:choose>
			</xsl:if>
			<br/>
			<b>Contact Type: </b>
			<xsl:if test="$participant/@classCode">
				<xsl:choose>
					<xsl:when test="$participant/@classCode='AGNT'">
						<xsl:text>Agent</xsl:text> 
					</xsl:when>
					<xsl:when test="$participant/@classCode='CAREGIVER'">
						<xsl:text>Caregiver</xsl:text> 
					</xsl:when>
					<xsl:when test="$participant/@classCode='ECON'">
						<xsl:text>Emergency Contact</xsl:text> 
					</xsl:when>
					<xsl:when test="$participant/@classCode='GUARD'">
						<xsl:text>Guardian</xsl:text> 
					</xsl:when>
					<xsl:when test="$participant/@classCode='NOK'">
						<xsl:text>Next of kin</xsl:text> 
					</xsl:when>
					<xsl:when test="$participant/@classCode='PRS'">
						<xsl:text>Personal</xsl:text> 
					</xsl:when>
				</xsl:choose>
			</xsl:if>
		</p>
	</xsl:template>

	<xsl:template name="getSingleAddress">
		<xsl:param name="addr"/>
		<xsl:if test="$addr/n1:streetAddressLine != ' '">
			<br/>
			<xsl:if test="string-length($addr/n1:streetAddressLine)>0">
				<xsl:value-of select="$addr/n1:streetAddressLine"/>
			</xsl:if>

			<br/>
			<xsl:value-of select="$addr/n1:city"/>,
			<xsl:value-of select="$addr/n1:state"/>,
			<xsl:value-of select="$addr/n1:postalCode"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getAddress">
		<xsl:param name="addr"/>
		<xsl:if test="$addr/n1:streetAddressLine != ' '">
			<xsl:for-each select="$addr/n1:streetAddressLine">
				<br/>
				<xsl:if test="string-length($addr/n1:streetAddressLine)>0">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
		<br/>
		
		<xsl:value-of select="$addr/n1:city"/>
		<xsl:if test="string-length($addr/n1:city)>0 and string-length($addr/n1:state)>0">
			<xsl:text>, </xsl:text>
		</xsl:if>
		<xsl:if test="string-length($addr/n1:state)>0">
			<xsl:value-of select="$addr/n1:state"/>
		</xsl:if>
		<xsl:if test="string-length($addr/n1:state)>0 and string-length($addr/n1:postalCode)>0">
			<xsl:text>, </xsl:text>
		</xsl:if>
		<xsl:if test="string-length($addr/n1:state)>0">
			<xsl:value-of select="$addr/n1:postalCode"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getSingleLineAddress">
		<xsl:param name="addr"/>
		<xsl:if test="$addr/n1:streetAddressLine and $addr/n1:streetAddressLine != ' '">
			<xsl:for-each select="$addr/n1:streetAddressLine">
				<xsl:if test="string-length($addr/n1:streetAddressLine)>0">
					<xsl:text> </xsl:text>
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
		
		<xsl:if test="$addr/n1:city"> 
			<xsl:text> </xsl:text>
			<xsl:value-of select="$addr/n1:city"/>
		</xsl:if>
		
		<xsl:if test="string-length($addr/n1:city)>0 and string-length($addr/n1:state)>0">
			<xsl:text>, </xsl:text>
		</xsl:if>
		<xsl:if test="string-length($addr/n1:state)>0">
			<xsl:value-of select="$addr/n1:state"/>
		</xsl:if>
		<xsl:if test="string-length($addr/n1:state)>0 and string-length($addr/n1:postalCode)>0">
			<xsl:text>, </xsl:text>
		</xsl:if>
		<xsl:if test="string-length($addr/n1:state)>0">
			<xsl:value-of select="$addr/n1:postalCode"/>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getTelecom">
		<xsl:param name="telecom"/>
		<br/>
		<xsl:if test="string-length($telecom/@value)>0">
			<xsl:value-of select="$telecom/@value"/>
			<xsl:choose>
				<xsl:when test="./@use='HP' ">
					<b>
						<xsl:text> Home</xsl:text>
					</b>
				</xsl:when>
				<xsl:when test="./@use='WP' ">
					<b>
						<xsl:text> Work</xsl:text>
					</b>
				</xsl:when>
				<xsl:when test="./@use='HV' ">
					<b>
						<xsl:text> Vacation</xsl:text>
					</b>
				</xsl:when>
				<xsl:when test="./@use='MC' ">
					<b>
						<xsl:text> Mobile</xsl:text>
					</b>
				</xsl:when>
				<xsl:otherwise>
					<b>
						<xsl:text></xsl:text>
					</b>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="getSingleLineTelecom">
		<xsl:param name="telecom"/>
		<xsl:if test="string-length($telecom/@value)>0">
			<xsl:text> </xsl:text>
			<xsl:value-of select="$telecom/@value"/>
			<xsl:choose>
				<xsl:when test="./@use='HP' ">
					<b>
						<xsl:text> Home</xsl:text>
					</b>
				</xsl:when>
				<xsl:when test="./@use='WP' ">
					<b>
						<xsl:text> Work</xsl:text>
					</b>
				</xsl:when>
				<xsl:when test="./@use='HV' ">
					<b>
						<xsl:text> Vacation</xsl:text>
					</b>
				</xsl:when>
				<xsl:when test="./@use='MC' ">
					<b>
						<xsl:text> Mobile</xsl:text>
					</b>
				</xsl:when>
				<xsl:otherwise>
					<b>
						<xsl:text></xsl:text>
					</b>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text> </xsl:text>
		</xsl:if>
	</xsl:template>

	<!-- Get Author  -->
	<xsl:template name="getAuthor">
		<xsl:variable name="author"/>
		<xsl:call-template name="getName">
			<xsl:with-param name="name" select="n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name"/>
		</xsl:call-template>
		<xsl:choose>
			<xsl:when test="$author">
				<xsl:value-of select="n1:author/n1:assignedAuthor/n1:assignedPerson/n1:name"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!-- non XML Body -->

	<xsl:template name="nonXMLBody">
		<xsl:param name="nonXMLBody" select="n1:component/n1:nonXMLBody" />
		<MediaType>
			<xsl:value-of select="$nonXMLBody/n1:text/@mediaType" />
		</MediaType>
		<Representation>
			<xsl:value-of select="$nonXMLBody/n1:text/@representation" />
		</Representation>
		<Text>
			<xsl:value-of select="$nonXMLBody/n1:text" />
		</Text>
	</xsl:template>
	
	<xsl:template match="n1:component/n1:nonXMLBody">
		<xsl:choose>
			<!-- if there is a reference, use that in an IFRAME -->
			<xsl:when test="n1:text/n1:reference">
				<IFRAME name="nonXMLBody" id="nonXMLBody" WIDTH="100%" HEIGHT="66%" src="{n1:text/n1:reference/@value}" />
			</xsl:when>
			<xsl:when test="n1:text/@mediaType='text/plain'">
				<pre>
					<xsl:value-of select="n1:text/text()" />
				</pre>
			</xsl:when>
			<xsl:otherwise>
				<CENTER>Cannot display the text</CENTER>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- StructuredBody -->

	<!-- Component/Section -->
	<xsl:template match="n1:component/n1:section">
		<xsl:apply-templates select="n1:title"/>
		<xsl:choose>
		
			<!-- Problems -->
			<xsl:when test="n1:code[@code=$loincProblemCode]">
				<xsl:choose>
					<xsl:when test="n1:entry">
						<xsl:call-template name="formatNarrativeBlockComments">
							<xsl:with-param name="table" select="n1:text/n1:table[@ID=$problemsCommentsTableId]"/>
						</xsl:call-template>
						<xsl:call-template name="displayProblemTable">
							<xsl:with-param select="./n1:text/n1:table[@ID=$problemsTableId]" name="table"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="./n1:text"/>				
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- Allergies -->
			<xsl:when test="n1:code[@code=$loincAllergyCode]">
				<xsl:choose>
					<xsl:when test="n1:entry">
						<xsl:call-template name="formatNarrativeBlockComments">
							<xsl:with-param name="table" select="n1:text/n1:table[@ID=$allergiesCommentTableId]"/>
						</xsl:call-template>
						<xsl:call-template name="displayAllergyTable">
							<xsl:with-param name="table" select="./n1:text/n1:table[@ID=$allergiesTableId]"/>
						</xsl:call-template>
						<xsl:call-template name="displayAllergyConsolTable">
							<xsl:with-param name="table" select="./n1:text/n1:table[@ID=$allergiesTableConsolId]"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="./n1:text"/>				
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- Medications -->
			<xsl:when test="n1:code[@code=$loincMedCode]">
				<xsl:choose>
					<xsl:when test="n1:entry">
						<xsl:call-template name="formatNarrativeBlockComments">
							<xsl:with-param name="table" select="n1:text/n1:table[@ID=$medicationsCommentsTableId]"/>
						</xsl:call-template>
						<xsl:call-template name="displayMedsTable">
							<xsl:with-param name="table" select="./n1:text/n1:table[@ID=$medicationsTableId]"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="./n1:text"/>				
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- Encounters -->
			<xsl:when test="n1:code[@code=$loincEncounterCode]">
				<xsl:choose>
					<xsl:when test="n1:entry">
						<xsl:call-template name="formatNarrativeBlockComments">
							<xsl:with-param name="table" select="n1:text/n1:table[@ID=$encountersCommentsTableId]"/>
						</xsl:call-template>
						<xsl:call-template name="displayEncounterTable">
							<xsl:with-param name="table" select="./n1:text/n1:table[@ID=$encountersTableId]" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="./n1:text"/>				
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- Results -->
			<xsl:when test="n1:code[@code=$loincResultsCode]">
				<xsl:choose>
					<xsl:when test="n1:entry">
						<xsl:call-template name="formatNarrativeBlockComments">
							<xsl:with-param name="table" select="n1:text/n1:div[@ID=$resultsDivId]/n1:table[@ID=$resultsCommentsTableId]"/>
						</xsl:call-template>
						<xsl:call-template name="displayResultsTable">
							<xsl:with-param  name="table" select="./n1:text/n1:div[@ID=$resultsDivId]/n1:table[@ID=$resultsTableId]"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="./n1:text"/>				
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- Procedures -->
			<xsl:when test="n1:code[@code=$loincProceduresCode]">
				<xsl:choose>
					<xsl:when test="n1:entry">
						<xsl:call-template name="formatNarrativeBlockComments">
							<xsl:with-param name="table" select="n1:text/n1:table[@ID=$proceduresCommentsTableId]"/>
						</xsl:call-template>
						<xsl:call-template name="displayProcedureTable">
							<xsl:with-param name="table" select="./n1:text/n1:table[@ID=$proceduresTableId]"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="./n1:text"/>				
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- Immunizations -->
			<xsl:when test="n1:code[@code=$loincImmunizationsCode]">
				<xsl:choose>
					<xsl:when test="n1:entry">
						<xsl:call-template name="formatNarrativeBlockComments">
							<xsl:with-param name="table" select="n1:text/n1:table[@ID=$immunizationsCommentsTableId]"/>
						</xsl:call-template>
						<xsl:call-template name="displayImmunizationTable">
							<xsl:with-param name="table" select="./n1:text/n1:table[@ID=$immunizationsTableId]"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="./n1:text"/>				
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- Vital Signs -->
			<xsl:when test="n1:code[@code=$loincVitalsCode]">
				<xsl:choose>
					<xsl:when test="n1:entry">
						<xsl:call-template name="formatNarrativeBlockComments">
							<xsl:with-param name="table" select="n1:text/n1:table[@ID=$vitalSignsCommentsTableId]"/>
						</xsl:call-template>
						<xsl:call-template name="displayVitalsTable">
							<xsl:with-param name="table" select="./n1:text/n1:table[@ID=$vitalSignsTableId]"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="./n1:text"/>				
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- Advance Directives -->
			<xsl:when test="n1:code[@code=$loincAdvDirectivesCode]">
				<xsl:choose>
					<xsl:when test="n1:entry">
						<xsl:call-template name="formatNarrativeBlockComments">
							<xsl:with-param name="table" select="n1:text/n1:table[@ID=$advDirectivesCommentsTableId]"/>
						</xsl:call-template>
						<xsl:call-template name="displayAdvDirectivesTable">
							<xsl:with-param name="table" select="./n1:text/n1:table[@ID=$advDirectivesTableId]"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="./n1:text"/>				
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- Payment Sources (Insurance Provider) -->
			<xsl:when test="n1:code[@code=$loincPaymentSourcesCode]">
				<xsl:choose>
					<xsl:when test="n1:entry">
						<xsl:call-template name="formatNarrativeBlockComments">
							<xsl:with-param name="table" select="n1:text/n1:table[@ID=$payerCommentsTableId]"/>
						</xsl:call-template>
						<xsl:call-template name="displayInsProviderTable">
							<xsl:with-param name="table" select="./n1:text/n1:table[@ID=$payerTableId]"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="./n1:text"/>				
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<!-- Treatment Plan (Plan of Care) -->
			<xsl:when test="n1:code[@code=$loincPlanOfCareCode]">
				<xsl:choose>
					<xsl:when test="n1:entry">
					
						<xsl:call-template name="formatNarrativeBlockComments">
							<xsl:with-param name="table" select="n1:text/n1:div[@ID=$planOfCareDivId]/n1:table[@id=$planOfCareCommentsTableId]"/>
						</xsl:call-template>
						<br/>
						
						<!-- Future Encounters -->
						<xsl:if test="n1:text/n1:div[@ID=$planOfCareDivId]/n1:div[@id=$futureEncountersDivId]">
							<xsl:call-template name="displayFutureEncountersTable">
								<xsl:with-param name="table" select="n1:text/n1:div[@ID=$planOfCareDivId]/n1:div[@id=$futureEncountersDivId]/n1:table[@id=$futureEncountersTableId]"/>
							</xsl:call-template>
						</xsl:if>
						
						<!-- Future Supply -->
						<xsl:if test="n1:text/n1:div[@ID=$planOfCareDivId]/n1:div[@id=$futureSupplyDivId]">
							<xsl:call-template name="displayFutureSupplyTable">
								<xsl:with-param name="table" select="n1:text/n1:div[@ID=$planOfCareDivId]/n1:div[@id=$futureSupplyDivId]/n1:table[@id=$futureSupplyTableId]"/>
							</xsl:call-template>
						</xsl:if>
						
						<!-- Future Act -->
						<xsl:if test="n1:text/n1:div[@ID=$planOfCareDivId]/n1:div[@id=$futureActDivId]">
							<xsl:call-template name="displayFutureActTable">
								<xsl:with-param name="table" select="n1:text/n1:div[@ID=$planOfCareDivId]/n1:div[@id=$futureActDivId]/n1:table[@id=$futureActTableId]"/>
							</xsl:call-template>
						</xsl:if>
						
						<!-- Future Procedure -->
						<xsl:if test="n1:text/n1:div[@ID=$planOfCareDivId]/n1:div[@id=$futureProcedureDivId]">
							<xsl:call-template name="displayFutureProcedureTable">
								<xsl:with-param name="table" select="n1:text/n1:div[@ID=$planOfCareDivId]/n1:div[@id=$futureProcedureDivId]/n1:table[@id=$futureProcedureTableId]"/>
							</xsl:call-template>
						</xsl:if>
						
						<!-- Future Substance -->
						<xsl:if test="n1:text/n1:div[@ID=$planOfCareDivId]/n1:div[@id=$futureSubstanceDivId]">
							<xsl:call-template name="displayFutureSubstanceTable">
									<xsl:with-param name="table" select="n1:text/n1:div[@ID=$planOfCareDivId]/n1:div[@id=$futureSubstanceDivId]/n1:table[@id=$futureSubstanceTableId]"/>
							</xsl:call-template>
						</xsl:if>
						
						<!-- Future Observation -->
						<xsl:if test="n1:text/n1:div[@ID=$planOfCareDivId]/n1:div[@id=$futureObservationDivId]">
							<xsl:call-template name="displayFutureObservationTable">
								<xsl:with-param name="table" select="n1:text/n1:div[@ID=$planOfCareDivId]/n1:div[@id=$futureObservationDivId]/n1:table[@id=$futureObservationTableId]"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="./n1:text"/>				
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>

	<!-- Display Vitals Table -->
	<xsl:template name="displayVitalsTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:tr/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[1]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[1]/n1:content),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayVitalsDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[1]),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayVitalsDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="displayVitalsDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="dateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[1]/n1:content">
					<xsl:value-of select="./n1:td[1]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[1]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="dateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($dateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>

			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Date/Time -->
						<div style="overflow:hidden; white-space:nowrap; width:150px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- TEMP -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Heart Rate -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- Respitory Rate -->
						<div style="overflow:hidden; white-space:nowrap; width:300px;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- BP -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Height -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=7"> <!-- Height Lying -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=8"> <!-- BMI -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=9"> <!-- Weight -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=10"> <!-- O2 Saturation -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=11"> <!-- Head Circumference -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
					</div>
					</xsl:when>
					<xsl:when test="position()=12"> <!-- Body Surface Area -->
						<div style="overflow:hidden; white-space:nowrap; width:150px;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=13"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:280px;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="displayVitalsEntry">
		<xsl:param name="string" />
		<xsl:param name="delimiter" />
		
		<xsl:choose>
			<xsl:when test="$delimiter and contains($string, $delimiter)">
			
				<xsl:call-template name="flyoverSpan">
					<xsl:with-param name="data" select="substring-before($string, $delimiter)" />
					<xsl:with-param name="freeText" select="''" />
					<xsl:with-param name="deSquigglefy" select="''" />
				</xsl:call-template>
				<hr/>
				
				<!-- call myself to display the other tokens -->
				<xsl:call-template name="displayVitalsEntry">
					<xsl:with-param name="string" select="substring-after($string, $delimiter)" />
					<xsl:with-param name="delimiter" select="$delimiter" />
				</xsl:call-template>
				
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="flyoverSpan">
					<xsl:with-param name="data" select="$string" />
					<xsl:with-param name="freeText" select="''" />
					<xsl:with-param name="deSquigglefy" select="''" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- Display Encounter Table -->
	<xsl:template name="displayEncounterTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:tr/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[1]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[1]/n1:content),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayEncounterDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">							
							<xsl:sort select="substring(normalize-space(./n1:td[1]),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayEncounterDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="displayEncounterDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="dateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[1]/n1:content">
					<xsl:value-of select="./n1:td[1]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[1]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="dateString">
			<xsl:call-template name="convertDate">
				<xsl:with-param name="dateValue" select="normalize-space($dateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Date/Time -->
						<div style="overflow:hidden; white-space:nowrap; width:auto; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Encounter Type -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Encounter Description -->
						<div style="overflow:hidden; white-space:nowrap; width:360px;height:1em">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- Free Text -->
						<xsl:variable name="data">
							<xsl:call-template name="replaceSquigglesWithBreaks">
								<xsl:with-param name="text" select="$dataValue"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="lenTest" select="string-length($data)" />
						<xsl:choose>
							<xsl:when test="$lenTest &gt; 25">
								<textarea rows="10" style="overflow-y:auto;width:240px;text-align:left resize:none">
									<xsl:value-of select="$data"/>
								</textarea>
							</xsl:when>
							<xsl:otherwise>
								<div style="overflow:hidden; white-space:nowrap; width:360px;height:1em">
									<xsl:call-template name="flyoverSpan">
										<xsl:with-param name="data" select="$dataValue" />
										<xsl:with-param name="freeText" select="'yes'" />
										<xsl:with-param name="deSquigglefy" select="'yes'" />
									</xsl:call-template>
								</div>
							</xsl:otherwise>	
						</xsl:choose>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Admission Type -->
						<div style="overflow:hidden; white-space:nowrap; width:240px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Provider -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=7"> <!-- Admission Source -->
						<div style="overflow:hidden; white-space:nowrap; width:100px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=8"> <!-- Facility Location -->
						<div style="overflow:hidden; white-space:nowrap; width:100px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=9"> <!-- In Facility Duration -->
						<div style="overflow:hidden; white-space:nowrap; width:100px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=10"> <!-- Reason for Visit -->
						<div style="overflow:hidden; white-space:nowrap; width:100px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=11"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=12"> <!-- Patient Class -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=13"> <!-- Discharge Disposition -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=14"> <!--  HC Facility Name -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=15"> <!--  HC Facility Location -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=16"> <!--  HC Facility ID -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=17"> <!-- HC Facility Address -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>
	
	<!-- Display Vitals Table -->
	<xsl:template name="displayMedsTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:tr/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[4]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[4]/n1:content),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayMedDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[4]),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayMedDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="displayMedDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="onsetDateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[4]/n1:content">
					<xsl:value-of select="./n1:td[4]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[4]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="orderDateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($onsetDateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="expirationDateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[5]/n1:content">
					<xsl:value-of select="./n1:td[5]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[5]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="expirationDateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($expirationDateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="filledDateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[10]/n1:content">
					<xsl:value-of select="./n1:td[10]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[10]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="filledDateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($filledDateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<!-- Med stop date -->
		<xsl:variable name="stopEntry">
			<xsl:choose>
				<xsl:when test="./n1:td[14]/n1:content">
					<xsl:value-of select="./n1:td[14]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[14]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
				
		<xsl:variable name="stopEntryString">
			<xsl:call-template name="convertDate">
				<xsl:with-param name="dateValue" select="normalize-space($stopEntry)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<!-- Administrative Timing -->
		<xsl:variable name="adminTimingEntry">
			<xsl:choose>
				<xsl:when test="./n1:td[15]/n1:content">
					<xsl:value-of select="./n1:td[15]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[15]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="adminTimingString">
			<xsl:call-template name="translateAdminTimingEntry">
				<xsl:with-param name="adminTimingEntry" select="$adminTimingEntry"/>
			</xsl:call-template> 
		</xsl:variable>

		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Medications --> 
						<div style="overflow:hidden; white-space:nowrap; width:280; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Brand Name -->
						<div style="overflow:hidden; white-space:nowrap; width:180px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Medication Status -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- Order Date -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$orderDateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Order Expiration Date -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$expirationDateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Provider (Ordering) -->
						<div style="overflow:hidden; white-space:nowrap; width:140px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=7"> <!-- Prescription Number-->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=8"> <!-- Fill Status -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=9"> <!-- Quantity Dispensed -->
						<div style="overflow:hidden; white-space:nowrap; width:80px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=10"> <!-- Dispense Date  -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$filledDateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=11"> <!-- Sig -->
						<div style="overflow:hidden; white-space:nowrap; width:300px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=12"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:200px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=13"> <!-- Reaction -->
						<div style="overflow:hidden; white-space:nowrap; width:200px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=14"> <!-- Indicate Medication Stopped -->
						<div style="overflow:hidden; white-space:nowrap; width:280px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=15"> <!-- Administrative Timing -->
						<div style="overflow:hidden; white-space:nowrap; width:500px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$adminTimingString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=16"> <!-- Route Code -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=17"> <!-- Body Site -->
						<div style="overflow:hidden; white-space:nowrap; width:200px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=18"> <!-- Dose Qualtity -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=19"> <!-- Dose Restriction -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=20"> <!-- Product Form -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=21"> <!-- Delivery Method -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=22"> <!--Drug Manufacturerd  -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=23"> <!-- Medication Type -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=24"> <!-- Indication -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=25"> <!-- Vehicle -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=26"> <!-- Dose Indicator -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=27"> <!-- Order Number -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=28"> <!-- Total Fills -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=29"> <!-- Fulfillment Instructions -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=30"> <!-- Dispensing Provider -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=31"> <!-- Pharmacy Location -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=32"> <!-- Fill Number -->
						<div style="overflow:hidden; white-space:nowrap; width:100px">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:otherwise/> 
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>
	
	<!-- Problem Table -->
	<xsl:template name="displayProblemTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:tr/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[5]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[5]/n1:content),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayProblemDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[5]),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayProblemDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="displayProblemDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="onsetDateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[5]/n1:content">
					<xsl:value-of select="./n1:td[5]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[5]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="onsetDateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($onsetDateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="resolveDateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[6]/n1:content">
					<xsl:value-of select="./n1:td[6]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[6]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="resolveDateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($resolveDateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="timeOfDeathDateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[10]/n1:content">
					<xsl:value-of select="./n1:td[10]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[10]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="timeOfDeathDateString">
			<xsl:call-template name="formatDateTimeShortFromUtc">
				<xsl:with-param name="dateString" select="normalize-space($timeOfDeathDateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
		
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Problem -->
					
						<xsl:variable name="problem">
							<xsl:choose>
								<xsl:when test="contains($dataValue,'Pregnancy')">
									<xsl:variable name="origEntry" select="text()"/>
									<xsl:variable name="firstPart" select="substring-after($origEntry, '(')" />
									<xsl:variable name="datePart" select="substring-before($firstPart, ')')" />
									<xsl:variable name="origDate" select="normalize-space($datePart)"/>
									<xsl:variable name="dateStr">
										<xsl:call-template name="formatDateShort">
											<xsl:with-param name="dateString" select="$origDate"/>
										</xsl:call-template>
									</xsl:variable>
									<xsl:variable name="entryStr" select="concat('Pregnancy ( ', $dateStr, ' )')"/>
									<xsl:value-of select="$entryStr"/>
								</xsl:when>
								<xsl:otherwise><xsl:value-of select="$dataValue"/></xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						
						<div style="overflow:hidden; white-space:nowrap; width:240px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$problem" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Status -->
						<div style="overflow:hidden; white-space:nowrap; width:80px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Problem Code -->
						<div style="overflow:hidden; white-space:nowrap; width:150px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- Problem Type -->
						<div style="overflow:hidden; white-space:nowrap; width:150px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Onset Date -->
						<div style="overflow:hidden; white-space:nowrap; width:100px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$onsetDateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Resolve Date -->
						<div style="overflow:hidden; white-space:nowrap; width:100px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$resolveDateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=7"> <!-- Cause of Death -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=8"> <!-- Age at Onset  -->
						<div style="overflow:hidden; white-space:nowrap; width:80px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=9"> <!-- Age at Death  -->
						<div style="overflow:hidden; white-space:nowrap; width:80px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=10"> <!-- Time of Death  -->
						<div style="overflow:hidden; white-space:nowrap; width:120px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$timeOfDeathDateValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=11"> <!-- Provider  -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=12"> <!-- Source  -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>

	<!-- Advance Directives -->
	<xsl:template name="displayAdvDirectivesTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:tr/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[3]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[3]/n1:content),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayAdvDirectivesDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[3]),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayAdvDirectivesDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="displayAdvDirectivesDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="dateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[3]/n1:content">
					<xsl:value-of select="./n1:td[3]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[3]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="onsetDateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($dateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
		
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Advance Directive Type -->
						<div style="overflow:hidden; white-space:nowrap; width:240px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Title -->
						<div style="overflow:hidden; white-space:nowrap; width:240px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Effective Date -->
						<div style="overflow:hidden; white-space:nowrap; width:100px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$onsetDateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- Custodian -->
						<div style="overflow:hidden; white-space:nowrap; width:150px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:100px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Advance Directive Reference -->
						<div style="overflow:hidden; white-space:nowrap; width:160px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>

	<!--  Allergy HITSP Table -->
	<xsl:template name="displayAllergyTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:tr/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
			<xsl:choose>
				<xsl:when test="./n1:td[5]/n1:content">
					<xsl:for-each select="$table/n1:tbody/n1:tr">
						<xsl:sort select="substring(normalize-space(./n1:td[5]/n1:content),1,8)" order="descending"/>
						<tr class="second">
							<xsl:call-template name="displayAllergyDataRow">
								<xsl:with-param name="tableRow" select="."/>
							</xsl:call-template>
						</tr>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:for-each select="$table/n1:tbody/n1:tr">
						<xsl:sort select="substring(normalize-space(./n1:td[5]),1,8)" order="descending"/>
						<tr class="second">
							<xsl:call-template name="displayAllergyDataRow">
								<xsl:with-param name="tableRow" select="."/>
							</xsl:call-template>
						</tr>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>	
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="displayAllergyDataRow">
		<xsl:param name="tableRow"/>
		
		<xsl:variable name="dateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[5]/n1:content">
					<xsl:value-of select="./n1:td[5]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[5]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="eventDateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($dateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
		
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Allergen -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue"/>
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Reaction -->
						<div style="overflow:hidden; white-space:nowrap; width:240px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue"/>
							<xsl:with-param name="freeText" select="'yes'"/>
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Severity -->
						<div style="overflow:hidden; white-space:nowrap; width:100px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue"/>
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- Event Type -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue"/>
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Event Date -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$eventDateString"/>
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue"/>
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
				</td>
		</xsl:for-each>
	</xsl:template>

	<!--  Allergy Consol Table -->
	<xsl:template name="displayAllergyConsolTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:tr/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
			<xsl:choose>
				<xsl:when test="./n1:td[6]/n1:content">
					<xsl:for-each select="$table/n1:tbody/n1:tr">
						<xsl:sort select="substring(normalize-space(./n1:td[6]/n1:content),1,8)" order="descending"/>
						<tr class="second">
							<xsl:call-template name="displayAllergyConsolDataRow">
								<xsl:with-param name="tableRow" select="."/>
							</xsl:call-template>
						</tr>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:for-each select="$table/n1:tbody/n1:tr">
						<xsl:sort select="substring(normalize-space(./n1:td[6]),1,8)" order="descending"/>
						<tr class="second">
							<xsl:call-template name="displayAllergyConsolDataRow">
								<xsl:with-param name="tableRow" select="."/>
							</xsl:call-template>
						</tr>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>	
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="displayAllergyConsolDataRow">
		<xsl:param name="tableRow"/>
		
		<xsl:variable name="dateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[6]/n1:content">
					<xsl:value-of select="./n1:td[6]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[6]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="eventDateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($dateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
		
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Allergen -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue"/>
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Allergen Severity -->
						<div style="overflow:hidden; white-space:nowrap; width:240px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue"/>
							<xsl:with-param name="freeText" select="'yes'"/>
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Reaction -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- Reaction Severity-->
								<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="displayVitalsEntry">
							<xsl:with-param name="string" select="$dataValue" />
							<xsl:with-param name="delimiter" select="'//'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Event Type -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue"/>
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Event Date -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$eventDateString"/>
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=7"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:200px; padding-right:5px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue"/>
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
				</td>
		</xsl:for-each>
	</xsl:template>
 	 	
	<!-- Results Table -->
	<xsl:template name="displayResultsTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="$table/n1:tbody/n1:tr">
					<tr class="second">
						<xsl:call-template name="displayResultsDataRow">
							<xsl:with-param name="tableRow" select="."/>
						</xsl:call-template>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="displayResultsDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="dateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[1]/n1:content">
					<xsl:value-of select="./n1:td[1]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[1]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="effectiveDateString">
			<xsl:call-template name="convertDate">
				<xsl:with-param name="dateValue" select="normalize-space($dateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
				
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
		
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Date/Time -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$effectiveDateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Result Type -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- Result -->
						<div style="overflow:hidden; white-space:nowrap; width:260px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Unit -->
						<div style="overflow:hidden; white-space:nowrap; width:240px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Interpretation -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=7"> <!-- Reference Range -->
						<div style="overflow:hidden; white-space:nowrap;width:240px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=8"> <!-- Comments -->
						<xsl:variable name="data">
							<xsl:call-template name="replaceSquigglesWithBreaks">
								<xsl:with-param name="text" select="$dataValue"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="lenTest" select="string-length($data)" />
						<xsl:choose>
							<xsl:when test="$lenTest &gt; 25">
								<textarea rows="10" style="overflow-y:auto;width:240px;text-align:left resize:none">
									<xsl:value-of select="$data"/>
								</textarea>
							</xsl:when>
							<xsl:otherwise>
								<div style="overflow:hidden; white-space:nowrap; width:360px;height:1em">
									<xsl:call-template name="flyoverSpan">
										<xsl:with-param name="data" select="$dataValue" />
										<xsl:with-param name="freeText" select="'yes'" />
										<xsl:with-param name="deSquigglefy" select="'yes'" />
									</xsl:call-template>
								</div>
							</xsl:otherwise>	
						</xsl:choose>
					</xsl:when>
					<xsl:when test="position()=9"> <!-- Status -->
						<div style="overflow:hidden; white-space:nowrap;width:240px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=10"> <!-- Analyte Status -->
						<div style="overflow:hidden; white-space:nowrap;width:240px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>
	
	<!-- Immunization Table -->
	<xsl:template name="displayImmunizationTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:tr/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
			<xsl:choose>
				<xsl:when test="./n1:td[3]/n1:content">
					<xsl:for-each select="$table/n1:tbody/n1:tr">
						<xsl:sort select="substring(normalize-space(./n1:td[3]/n1:content),1,8)" order="descending"/>
						<tr class="second">
							<xsl:call-template name="displayImmunizationDataRow">
								<xsl:with-param name="tableRow" select="."/>
							</xsl:call-template>
						</tr>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:for-each select="$table/n1:tbody/n1:tr">
						<xsl:sort select="substring(normalize-space(./n1:td[3]),1,8)" order="descending"/>
						<tr class="second">
							<xsl:call-template name="displayImmunizationDataRow">
								<xsl:with-param name="tableRow" select="."/>
							</xsl:call-template>
						</tr>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>	
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="displayImmunizationDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="dateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[3]/n1:content">
					<xsl:value-of select="./n1:td[3]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[3]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="effectiveDateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($dateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
				
		<xsl:for-each select="$tableRow/n1:td">

			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
		
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Immunization -->
						<div style="overflow:hidden; white-space:nowrap; width:300px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Series -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Date Issued -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$effectiveDateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- Reaction -->
						<div style="overflow:hidden; white-space:nowrap; width:260px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Comments -->
						<div style="overflow:hidden; white-space:nowrap; width:240px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Immunization Refused -->
						<div style="overflow:hidden; white-space:nowrap; width:80px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=7"> <!-- Refusal Reason -->
						<div style="overflow:hidden; white-space:nowrap; width:240px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=8"> <!-- Provider -->
						<div style="overflow:hidden; white-space:nowrap; width:240px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=9"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:180px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=10"> <!-- Product Reference -->
						<div style="overflow:hiden; white-space:nowrap; width:240px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=11"> <!-- Comment Reference -->
						<div style="overflow:hidden; white-space:nowrap; width:240px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=12"> <!-- Reaction Reference -->
						<div style="overflow:hidden; white-space:nowrap; width:240px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>
	
	<!--  Insurance Provider Table -->
	<xsl:template name="displayInsProviderTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:tr/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[3]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[3]/n1:content),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayInsProviderDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[3]),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayInsProviderDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="displayInsProviderDataRow">
		<xsl:param name="tableRow"/>
		
		<xsl:variable name="covBeginDateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[8]/n1:content">
					<xsl:value-of select="./n1:td[8]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[8]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="covBeginDateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($covBeginDateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="covEndDateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[9]/n1:content">
					<xsl:value-of select="./n1:td[9]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[9]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="covEndDateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($covEndDateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="patdobDateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[15]/n1:content">
					<xsl:value-of select="./n1:td[15]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[15]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="patdobString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($patdobDateValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="subdobDateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[21]/n1:content">
					<xsl:value-of select="./n1:td[21]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[21]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="subdobString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($subdobDateValue)"/>
			</xsl:call-template> 
		</xsl:variable>	

		<xsl:variable name="guarDateValue">
			<xsl:choose>
				<xsl:when test="./n1:td[22]/n1:content">
					<xsl:value-of select="./n1:td[22]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[22]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="guarDateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($guarDateValue)"/>
			</xsl:call-template> 
		</xsl:variable>	
		
		<xsl:for-each select="$tableRow/n1:td">

			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Result ID -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=2"> <!-- Group Number  -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=3"> <!-- Insurance Type  -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=4"> <!-- Info Src ID -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=5"> <!-- Info Src Addr  -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=6"> <!-- Info Src Telecom  -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=7"> <!-- Info Src Name -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=8"> <!-- Coverage Begin Date -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$covBeginDateString"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=9"> <!-- Coverage End Date -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$covEndDateString"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=10"> <!--Member ID -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=11"> <!-- Relationship Type -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=12"> <!-- Patient Addr -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=13"> <!-- Patient Phone -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=14"> <!--Patient Name -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=15"> <!-- Patient DOB -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$patdobString"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=16"> <!-- Finacially Responsible Party -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=17"> <!-- Sunsvriber ID -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=18"> <!-- Subscriber Addr -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=19"> <!-- Subscriber Phone-->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=20"> <!-- Subscriber Name -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=21"> <!-- Subscriber DOB -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$subdobString"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>			
					<xsl:when test="position()=22"> <!-- Guarantor Date of Financial Responsibility -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$guarDateString"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>									
					<xsl:when test="position()=23"> <!-- Guarantor Addr -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=24"> <!-- Guarantor Phone -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=25"> <!-- Guarantor Name -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
					<xsl:when test="position()=26"> <!-- Health Plan Name -->
						<div style="overflow:hidden; white-space:nowrap; width:180px; padding-right:5px;">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$dataValue"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</div>
					</xsl:when>	
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>
 	
	<!--  Procedure Table -->
	<xsl:template name="displayProcedureTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:tr/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[1]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[1]/n1:content),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayProcedureDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[1]),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayProcedureDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
	</xsl:template>
	
	<xsl:template name="displayProcedureDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="timeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[1]/n1:content">
					<xsl:value-of select="./n1:td[1]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[1]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="dateString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($timeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Date/Time -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Procesure Type -->
						<div style="overflow:hidden; white-space:nowrap; width:180px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Procesure Description -->
						<div style="overflow:hidden; white-space:nowrap; width:240px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!--Procedure Type Details -->
						<xsl:variable name="data">
							<xsl:call-template name="replaceSquigglesWithBreaks">
								<xsl:with-param name="text" select="$dataValue"/>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="lenTest" select="string-length($data)" />
						<xsl:choose>
							<xsl:when test="$lenTest &gt; 25">
								<textarea rows="10" style="overflow-y:auto;width:240px;text-align:left resize:none">
									<xsl:value-of select="$data"/>
								</textarea>
							</xsl:when>
							<xsl:otherwise>
								<div style="overflow:hidden; white-space:nowrap; width:360px;height:1em">
									<xsl:call-template name="flyoverSpan">
										<xsl:with-param name="data" select="$dataValue" />
										<xsl:with-param name="freeText" select="'yes'" />
										<xsl:with-param name="deSquigglefy" select="'yes'" />
									</xsl:call-template>
								</div>
							</xsl:otherwise>	
						</xsl:choose>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Provider -->
						<div style="overflow:hidden; white-space:nowrap; width:280px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Body Site -->
						<div style="overflow:hidden; white-space:nowrap; width:180px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=7"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:280px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:otherwise>
						<div style="overflow:hidden; white-space:nowrap; width:280px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="displayFutureEncountersTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<caption style="text-align:left"><b><xsl:value-of select="$table/../n1:title"/></b></caption>
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[1]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[1]/n1:content),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayFutureEncounterDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[1]),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayFutureEncounterDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>

	<xsl:template name="displayFutureEncounterDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="timeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[1]/n1:content">
					<xsl:value-of select="./n1:td[1]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[1]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="dateString">
			<xsl:call-template name="convertDate">
				<xsl:with-param name="dateValue" select="normalize-space($timeValue)"/>
			</xsl:call-template> 
		</xsl:variable>

		<xsl:variable name="facilityTimeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[9]/n1:content">
					<xsl:value-of select="./n1:td[9]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[9]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="facilityTimeString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($facilityTimeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Date/Time -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Encounter Type -->
						<div style="overflow:hidden; white-space:nowrap; width:180px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Description -->
						<div style="overflow:hidden; white-space:nowrap; width:240px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- Admission Type -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Provider -->
						<div style="overflow:hidden; white-space:nowrap; width:280px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Admission Source -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=7"> <!-- Facility Location -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=8"> <!-- In Facility Duration (time) -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$facilityTimeString" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=9"> <!-- Reason for Visit -->
						<div style="overflow:hidden; white-space:nowrap; width:280px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=10"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=11"> <!-- Patient Class -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=12"> <!-- Patient Class -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=13"> <!-- Patient Class -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=14"> <!-- Patient Class -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=15"> <!-- Patient Class -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=16"> <!-- Patient Class -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="displayFutureSupplyTable">
		<xsl:param name="table"/>
				
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<caption style="text-align:left"><b><xsl:value-of select="$table/../n1:title"/></b></caption>
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[1]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[1]/n1:content),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayFutureSupplyDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[1]),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayFutureSupplyDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>

	<xsl:template name="displayFutureSupplyDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="timeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[3]/n1:content">
					<xsl:value-of select="./n1:td[3]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[3]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="dateString">
			<xsl:call-template name="convertDate">
				<xsl:with-param name="dateValue" select="normalize-space($timeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="authoredTimeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[8]/n1:content">
					<xsl:value-of select="./n1:td[86]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[8]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="authoredTimeString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($authoredTimeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="facilityTimeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[11]/n1:content">
					<xsl:value-of select="./n1:td[11]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[1]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="facilityTimeString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($facilityTimeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="admissionTimeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[12]/n1:content">
					<xsl:value-of select="./n1:td[12]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[12]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="admissionTimeString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($admissionTimeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Supply -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Manufacturer -->
						<div style="overflow:hidden; white-space:nowrap; width:180px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Date/Time -->
						<div style="overflow:hidden; white-space:nowrap; width:240px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- ID -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Description -->
						<div style="overflow:hidden; white-space:nowrap; width:280px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Code -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=7"> <!-- Reason -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=8"> <!-- Authored Time -->
						<div style="overflow:hidden; white-space:nowrap; width:280px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$authoredTimeString" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=9"> <!-- Assigned Person -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=10"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=11"> <!-- Facility Time -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$facilityTimeString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=12"> <!-- Admission Time -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$admissionTimeString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="displayFutureActTable">
		<xsl:param name="table"/>
				
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<caption style="text-align:left"><b><xsl:value-of select="$table/../n1:title"/></b></caption>
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[3]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[3]/n1:content),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayFutureActDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[3]),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayFutureActDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>

	<xsl:template name="displayFutureActDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="timeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[3]/n1:content">
					<xsl:value-of select="./n1:td[3]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[3]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="dateString">
			<xsl:call-template name="convertDate">
				<xsl:with-param name="dateValue" select="normalize-space($timeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!--Activity -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Activity Status -->
						<div style="overflow:hidden; white-space:nowrap; width:180px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Date/Time -->
						<div style="overflow:hidden; white-space:nowrap; width:240px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dateString" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="displayFutureProcedureTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<caption style="text-align:left"><b><xsl:value-of select="$table/../n1:title"/></b></caption>
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[1]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[1]/n1:content),1,8)" order="descending"/>
							<xsl:message>SortDate: <xsl:value-of select="substring-before(normalize-space(./n1:td[1]/n1:content), ' ')"/></xsl:message>
							<tr class="second">
								<xsl:call-template name="displayFutureProcedureDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[1]),1,8)" order="descending"/>
							<xsl:message>SortDate: <xsl:value-of select="substring-before(normalize-space(./n1:td[1]), ' ')"/></xsl:message>
							<tr class="second">
								<xsl:call-template name="displayFutureProcedureDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>

	<xsl:template name="displayFutureProcedureDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="timeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[1]/n1:content">
					<xsl:value-of select="./n1:td[1]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[1]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="dateString">
			<xsl:call-template name="convertDate">
				<xsl:with-param name="dateValue" select="normalize-space($timeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		
		<xsl:variable name="authoredTimeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[6]/n1:content">
					<xsl:value-of select="./n1:td[6]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[6]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="authoredTimeString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($authoredTimeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="facilityTimeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[9]/n1:content">
					<xsl:value-of select="./n1:td[9]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[9]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="facilityTimeString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($facilityTimeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="admissionTimeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[10]/n1:content">
					<xsl:value-of select="./n1:td[10]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[10]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="admissionTimeString">
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString" select="normalize-space($admissionTimeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Date/Time -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Procedure Type -->
						<div style="overflow:hidden; white-space:nowrap; width:180px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Procedure Description -->
						<div style="overflow:hidden; white-space:nowrap; width:280px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- Procedure Type Details -->
						<div style="overflow:hidden; white-space:nowrap; width:280px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Provider -->
						<div style="overflow:hidden; white-space:nowrap; width:280px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Body Site -->
						<div style="overflow:hidden; white-space:nowrap; width:150px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=7"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:280px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="displayFutureSubstanceTable">
		<xsl:param name="table"/>
		
		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<caption style="text-align:left"><b><xsl:value-of select="$table/../n1:title"/></b></caption>
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[4]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[4]/n1:content),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayFutureSubstanceDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[4]),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayFutureSubstanceDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>

	<xsl:template name="displayFutureSubstanceDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="timeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[4]/n1:content">
					<xsl:value-of select="./n1:td[4]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[4]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="dateString">
			<xsl:call-template name="convertDate">
				<xsl:with-param name="dateValue" select="normalize-space($timeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:variable name="expirationTimeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[5]/n1:content">
					<xsl:value-of select="./n1:td[5]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[5]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="expirationDateString">
			<xsl:call-template name="convertDate">
				<xsl:with-param name="dateValue" select="normalize-space($expirationTimeValue)"/>
			</xsl:call-template> 
		</xsl:variable>

		<xsl:variable name="dispenseTimeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[10]/n1:content">
					<xsl:value-of select="./n1:td[10]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[10]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="dispenseDateString">
			<xsl:call-template name="convertDate">
				<xsl:with-param name="dateValue" select="normalize-space($dispenseTimeValue)"/>
			</xsl:call-template> 
		</xsl:variable>

		<!-- Administrative Timing -->
		<xsl:variable name="adminTimingEntry">
			<xsl:choose>
				<xsl:when test="./n1:td[15]/n1:content">
					<xsl:value-of select="./n1:td[15]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[15]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="adminTimingString">
			<xsl:call-template name="translateAdminTimingEntry">
				<xsl:with-param name="adminTimingEntry" select="$adminTimingEntry"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
						
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Medication -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Medication Brand Name-->
						<div style="overflow:hidden; white-space:nowrap; width:180px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Medication Status -->
						<div style="overflow:hidden; white-space:nowrap; width:240px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=4"> <!-- Order Date -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dateString" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=5"> <!-- Order Expiration -->
						<div style="overflow:hidden; white-space:nowrap; width:280px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$expirationDateString" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=6"> <!-- Provider (Ordering) -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=7"> <!-- Prescription Number -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=8"> <!-- Fill Status -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=9"> <!-- Quantity Dispensed -->
						<div style="overflow:hidden; white-space:nowrap; width:100px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=10"> <!-- Dispense Date -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=11"> <!-- Sig -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=12"> <!-- Source -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=13"> <!-- Reaction -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=14"> <!-- Indicate Medication Stopped -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=15"> <!-- Administrative Timing -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$adminTimingString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=16"> <!-- Route Code -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=17"> <!-- Body Site -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=18"> <!-- Dose Quantity -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=19"> <!-- Dose Restriction -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=20"> <!-- Product Form -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=21"> <!-- Delivery Methos -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=22"> <!-- Drug Manufacture -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=23"> <!-- Medication Type -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=24"> <!-- Indication -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=25"> <!-- Vehicle -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=26"> <!-- Dose Indicator -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=27"> <!-- Order Number -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=28"> <!-- Total Fills -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=29"> <!-- Fulfillment Instructions -->
						<div style="overflow:hidden; white-space:nowrap; width:300px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=30"> <!-- Dispensing Provider -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=31"> <!-- Pharmacy Location -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=32"> <!-- Fill Number -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="displayFutureObservationTable">
		<xsl:param name="table"/>

		<!--  Get the table -->
		<table style="font-size:14p" border="1">
			<caption style="text-align:left"><b><xsl:value-of select="$table/../n1:title"/></b></caption>
			<thead>
				<tr>
					<xsl:for-each select="$table/n1:thead/n1:th">
						<th class="first"><xsl:value-of select="."/></th>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:choose>
					<xsl:when test="./n1:td[3]/n1:content">
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[3]/n1:content),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayFutureObservationDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$table/n1:tbody/n1:tr">
							<xsl:sort select="substring(normalize-space(./n1:td[3]),1,8)" order="descending"/>
							<tr class="second">
								<xsl:call-template name="displayFutureObservationDataRow">
									<xsl:with-param name="tableRow" select="."/>
								</xsl:call-template>
							</tr>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>	
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>

	<xsl:template name="displayFutureObservationDataRow">
		<xsl:param name="tableRow"/>

		<xsl:variable name="timeValue">
			<xsl:choose>
				<xsl:when test="./n1:td[3]/n1:content">
					<xsl:value-of select="./n1:td[3]/n1:content"/> 
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./n1:td[3]"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="dateString">
			<xsl:call-template name="convertDate">
				<xsl:with-param name="dateValue" select="normalize-space($timeValue)"/>
			</xsl:call-template> 
		</xsl:variable>
		
		<xsl:for-each select="$tableRow/n1:td">
		
			<xsl:variable name="dataValue">
				<xsl:choose>
					<xsl:when test="./n1:content">
						<xsl:value-of select="./n1:content"/> 
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="."/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			
			<td>
				<xsl:choose>
					<xsl:when test="position()=1"> <!-- Observation -->
						<div style="overflow:hidden; white-space:nowrap; width:200px;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dateString" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=2"> <!-- Observation Status -->
						<div style="overflow:hidden; white-space:nowrap; width:180px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dataValue" />
							<xsl:with-param name="freeText" select="''" />
							<xsl:with-param name="deSquigglefy" select="''" />
						</xsl:call-template>
						</div>
					</xsl:when>
					<xsl:when test="position()=3"> <!-- Date/Time -->
						<div style="overflow:hidden; white-space:nowrap; width:240px;;">
						<xsl:call-template name="flyoverSpan">
							<xsl:with-param name="data" select="$dateString" />
							<xsl:with-param name="freeText" select="'yes'" />
							<xsl:with-param name="deSquigglefy" select="'yes'" />
						</xsl:call-template>
						</div>
					</xsl:when>
				</xsl:choose>
			</td>
		</xsl:for-each>
	</xsl:template>

	<!--   flyover -->
	<xsl:template name="flyoverSpan">
		<xsl:param name="data"/>
		<xsl:param name="freeText"/>
		<xsl:param name="deSquigglefy"/>
		<xsl:element name="span">
			<xsl:attribute name="onmouseover">
				<xsl:choose>
					<xsl:when test="$freeText and string-length($freeText)>0">
						<xsl:text>DisplayTip(this,25,-50,1)</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>DisplayTip(this,25,-50,0)</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="$data and string-length($data)>0">
					<xsl:choose>
						<xsl:when test="$deSquigglefy and string-length($deSquigglefy)>0">
							<xsl:call-template name="replaceSquigglesWithBreaks">
								<xsl:with-param name="text" select="$data"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$data"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="na"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>

	<xsl:template name="replaceSquigglesWithBreaks">
		<xsl:param name="text"/>
		<xsl:if test="$text">
			<xsl:choose>
				<xsl:when test="contains($text,'~')">
					<xsl:value-of select="substring-before($text,'~')"/>
					<br/>
					<xsl:call-template name="replaceSquigglesWithBreaks">
						<xsl:with-param name="text" select="substring-after($text,'~')"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$text"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<!--   Title  -->
	<xsl:template match="n1:title">
		<xsl:variable name="compFound">
			<xsl:call-template name="componentFound">
				<xsl:with-param name="compSection" select="../."/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($compFound)>0">
				<h3>
					<span style="font-weight:bold;line-height:40%">
						<a name="{generate-id(.)}" href="#toc">
							<xsl:value-of select="."/>
						</a>
					</span>
				</h3>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

	<!--   Text   -->
	<xsl:template match="n1:text">
		<xsl:apply-templates />
	</xsl:template>

	<!--   paragraph  -->
	<xsl:template match="n1:paragraph">
		<p>
			<xsl:apply-templates/>
		</p>
	</xsl:template>

	<!--     Content w/ deleted text is hidden -->
	<xsl:template match="n1:content[@revised='delete']"/>

	<!--   content  -->
	<xsl:template match="n1:content">
		<xsl:apply-templates/>
	</xsl:template>


	<!--   list  -->
	<xsl:template match="n1:list">
		<xsl:if test="n1:caption">
			<span style="font-weight:bold; ">
				<xsl:apply-templates select="n1:caption"/>
			</span>
		</xsl:if>
		<ul>
			<xsl:for-each select="n1:item">
				<li>
					<xsl:apply-templates />
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>

	<xsl:template match="n1:list[@listType='ordered']">
		<xsl:if test="n1:caption">
			<span style="font-weight:bold; ">
				<xsl:apply-templates select="n1:caption"/>
			</span>
		</xsl:if>
		<ol>
			<xsl:for-each select="n1:item">
				<li>
					<xsl:apply-templates />
				</li>
			</xsl:for-each>
		</ol>
	</xsl:template>


	<!--   caption  -->
	<xsl:template match="n1:caption">
		<xsl:apply-templates/>
		<xsl:text>: </xsl:text>
	</xsl:template>

	<!--      Tables   -->
	<xsl:template match="n1:table/@*|n1:thead/@*|n1:tfoot/@*|n1:tbody/@*|n1:colgroup/@*|n1:col/@*|n1:tr/@*|n1:th/@*|n1:td/@*">
		<xsl:copy>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="n1:table">
		<table>

			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</table>
	</xsl:template>

	<xsl:template match="n1:thead">
		<thead>

			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</thead>
	</xsl:template>

	<xsl:template match="n1:tfoot">
		<tfoot>

			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</tfoot>
	</xsl:template>

	<xsl:template match="n1:tbody">
		<tbody>

			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</tbody>
	</xsl:template>

	<xsl:template match="n1:colgroup">
		<colgroup>

			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</colgroup>
	</xsl:template>

	<xsl:template match="n1:col">
		<col>

			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</col>
	</xsl:template>

	<xsl:template match="n1:tr">
		<tr>

			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</tr>
	</xsl:template>

	<xsl:template match="n1:th">
		<th>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</th>
	</xsl:template>

	<xsl:template match="n1:td">
		<td>
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</td>
	</xsl:template>

	<xsl:template match="n1:table/n1:caption">
		<span style="font-weight:bold; ">
			<xsl:apply-templates/>
		</span>
	</xsl:template>

	<!--   RenderMultiMedia 

         this currently only handles GIF's and JPEG's.  It could, however,
	 be extended by including other image MIME types in the predicate
	 and/or by generating <object> or <applet> tag with the correct
	 params depending on the media type  @ID  =$imageRef     referencedObject
 -->
	<xsl:template match="n1:renderMultiMedia">
		<xsl:variable name="imageRef" select="@referencedObject"/>
		<xsl:choose>
			<xsl:when test="//n1:regionOfInterest[@ID=$imageRef]">
				<!-- Here is where the Region of Interest image referencing goes -->
				<xsl:if test='//n1:regionOfInterest[@ID=$imageRef]//n1:observationMedia/n1:value[@mediaType="image/gif" or @mediaType="image/jpeg"]'>
					<br clear='all'/>
					<xsl:element name='img'>
						<xsl:attribute name='src'>
							<xsl:value-of select='//n1:regionOfInterest[@ID=$imageRef]//n1:observationMedia/n1:value/n1:reference/@value'/>
						</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<!-- Here is where the direct MultiMedia image referencing goes -->
				<xsl:if test='//n1:observationMedia[@ID=$imageRef]/n1:value[@mediaType="image/gif" or @mediaType="image/jpeg"]'>
					<br clear='all'/>
					<xsl:element name='img'>
						<xsl:attribute name='src'>
							<xsl:value-of select='//n1:observationMedia[@ID=$imageRef]/n1:value/n1:reference/@value'/>
						</xsl:attribute>
					</xsl:element>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- 	Stylecode processing   
	  Supports Bold, Underline and Italics display

-->

	<xsl:template match="//n1:*[@styleCode]">

		<xsl:if test="@styleCode='Bold'">
			<xsl:element name='b'>
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>

		<xsl:if test="@styleCode='Italics'">
			<xsl:element name='i'>
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>

		<xsl:if test="@styleCode='Underline'">
			<xsl:element name='u'>
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:if>

		<xsl:if test="contains(@styleCode,'Bold') and contains(@styleCode,'Italics') and not (contains(@styleCode, 'Underline'))">
			<xsl:element name='b'>
				<xsl:element name='i'>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:element>
		</xsl:if>

		<xsl:if test="contains(@styleCode,'Bold') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Italics'))">
			<xsl:element name='b'>
				<xsl:element name='u'>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:element>
		</xsl:if>

		<xsl:if test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and not (contains(@styleCode, 'Bold'))">
			<xsl:element name='i'>
				<xsl:element name='u'>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:element>
		</xsl:if>

		<xsl:if test="contains(@styleCode,'Italics') and contains(@styleCode,'Underline') and contains(@styleCode, 'Bold')">
			<xsl:element name='b'>
				<xsl:element name='i'>
					<xsl:element name='u'>
						<xsl:apply-templates/>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:if>

	</xsl:template>

	<!-- 	Superscript or Subscript   -->
	<xsl:template match="n1:sup">
		<xsl:element name='sup'>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="n1:sub">
		<xsl:element name='sub'>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>

	<!--  Bottomline  -->

	<xsl:template name="displayBottomLine">
		<p>
			<xsl:variable name="found"/>
			<xsl:call-template name="getName">
				<xsl:with-param name="name" select="n1:legalAuthenticator/n1:assignedEntity/n1:representedOrganization/n1:name"/>
			</xsl:call-template>
			<xsl:choose>
				<xsl:when test="$found">
					<b>
						<xsl:text>Electronically generated by: </xsl:text>
						<xsl:value-of select="$found"/>
					</b>
				</xsl:when>
				<xsl:otherwise>
					<b>
						<xsl:text disable-output-escaping="yes">Electronically generated on:&amp;nbsp; </xsl:text>
						<xsl:value-of select="$found"/>
					</b>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="string-length(n1:effectiveTime/@value)=0">
					<xsl:call-template name="na"/>
				</xsl:when>
				<xsl:when test="starts-with(n1:effectiveTime/@value,' ')">
					<xsl:call-template name="na"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="dateFound"/>
					<xsl:call-template name="formatDateLong">
						<xsl:with-param name="dateString" select="n1:effectiveTime/@value"/>
					</xsl:call-template>
					<xsl:if test="($dateFound) and not ($found)">
						<xsl:text disable-output-escaping="yes">&amp;nbsp;on&amp;nbsp; </xsl:text>
						<xsl:value-of select="$dateFound"/>
					</xsl:if>
					<xsl:if test="($dateFound) and ($found)">
						<xsl:value-of select="$dateFound"/>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</p>
		<div id="TipBox" style="display:none;position:absolute;font-size:12px;font-weight:bold;font-family:verdana;border:#72B0E6 solid 1px;padding:15px;color:black;background-color:#FFFFFF;">
			<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
		</div>
	</xsl:template>

	<!-- Allergy table 
	<xsl:template match="n1:component/n1:section[n1:code/@code=$loincAllergyCode]/n1:text/n1:table/n1:tbody">
		<xsl:apply-templates>
			<xsl:sort select="n1:td[3]" order="descending"/>
		</xsl:apply-templates>
	</xsl:template>
-->
	<xsl:template match="n1:component/n1:section[n1:templateId/@root='2.16.840.1.113883.10.20.1.11']/n1:text/n1:table/n1:tbody">
		<xsl:apply-templates>
			<xsl:sort select="n1:td[3]" order="descending"/>
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template match="n1:component/n1:section[n1:templateId/@root='2.16.840.1.113883.10.20.1.8']/n1:text/n1:table/n1:tbody">
		<xsl:apply-templates>
			<xsl:sort select="n1:td[5]" order="descending"/>
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template match="n1:component/n1:section[n1:templateId/@root='2.16.840.1.113883.10.20.1.16' or n1:templateId/@root='2.16.840.1.113883.10.20.1.14' or n1:templateId/@root='2.16.840.1.113883.10.20.1.6' or n1:templateId/@root='2.16.840.1.113883.10.20.1.3']/n1:text/n1:table/n1:tbody">
		<xsl:apply-templates>
			<xsl:sort select="n1:td[2]" order="descending"/>
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template match="n1:component/n1:section[n1:templateId/@root='2.16.840.1.113883.10.20.1.11']/n1:text/n1:table/n1:tbody/n1:tr/n1:td[3]">
		<td>
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString"
				 select="text()"/>
			</xsl:call-template>
		</td>
	</xsl:template>

	<xsl:template match="n1:component/n1:section[n1:templateId/@root='2.16.840.1.113883.10.20.1.8']/n1:text/n1:table/n1:tbody/n1:tr/n1:td[5]">
		<td>
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString"
					 select="text()"/>
			</xsl:call-template>
		</td>
	</xsl:template>

	<xsl:template match="n1:component/n1:section[n1:templateId/@root='2.16.840.1.113883.10.20.1.16' or n1:templateId/@root='2.16.840.1.113883.10.20.1.14' or n1:templateId/@root='2.16.840.1.113883.10.20.1.6' or n1:templateId/@root='2.16.840.1.113883.10.20.1.3']/n1:text/n1:table/n1:tbody/n1:tr/n1:td[2]">
		<td>
			<xsl:call-template name="formatDateShort">
				<xsl:with-param name="dateString"
					 select="concat(substring(text(),1,4),substring(text(),6,2),substring(text(),9,2))"/>
			</xsl:call-template>
		</td>
	</xsl:template>

	<xsl:template name="na">
		<span title="Not Available">
			<xsl:text></xsl:text> <!-- If blank from MDHT then blank in stylesheet -->
		</span>
	</xsl:template>

	<!-- free text processing -->

	<xsl:template name="freeText">
		<xsl:param name="text"/>

	</xsl:template>

	<xsl:template name="display1LineBreak">
		<br/>
	</xsl:template>

	<xsl:template name="displayVitalsMultiSeparator">
		<xsl:call-template name="display1LineBreak"/>
	</xsl:template>

	<xsl:template name="displayVitalRow">
		<xsl:param name="row"/>
		<tr class="second">
			<xsl:call-template name="displayVitalItems">
				<xsl:with-param name="row" select="$row"/>
			</xsl:call-template>
		</tr>
	</xsl:template>

	<xsl:template name="displayVitalsDateItem">
		<xsl:param name="rowData"/>
		<td>
			<div style="overflow:hidden; white-space:nowrap; width:80px;">
				<xsl:call-template name="displayVitalsDate">
					<xsl:with-param name="rowData" select="$rowData"/>
				</xsl:call-template>
			</div>
		</td>
	</xsl:template>

	<xsl:template name="displayVitalsTempItem">
		<xsl:param name="temp"/>
		<td>
			<div style="overflow:hidden; white-space:nowrap; width:70px;">
				<xsl:call-template name="displayVitalsTemp">
					<xsl:with-param name="temp" select="$temp"/>
				</xsl:call-template>
			</div>
		</td>
	</xsl:template>

	<xsl:template name="displayVitalsSourceItem">
		<xsl:param name="row"/>
		<td>
			<div style="overflow:hidden; white-space:nowrap; width:150px;">
				<xsl:call-template name="displayVitalsSource">
					<xsl:with-param name="row" select="$row"/>
				</xsl:call-template>
			</div>
		</td>
	</xsl:template>

	<xsl:template name="displayVitalsPoxItem">
		<xsl:param name="pox"/>
		<td>
			<div style="overflow:hidden; white-space:nowrap; width:70px;">
				<xsl:call-template name="displayVitalsPox">
					<xsl:with-param name="pox" select="$pox"/>
				</xsl:call-template>
			</div>
		</td>
	</xsl:template>

	<xsl:template name="displayVitalsWeightItem">
		<xsl:param name="weight"/>
		<td>
			<div style="overflow:hidden; white-space:nowrap; width:70px;">
				<xsl:call-template name="displayVitalsWeight">
					<xsl:with-param name="weight" select="$weight"/>
				</xsl:call-template>
			</div>
		</td>
	</xsl:template>

	<xsl:template name="displayVitalsHeightItem">
		<xsl:param name="height"/>
		<td>
			<div style="overflow:hidden; white-space:nowrap; width:70px;">
				<xsl:call-template name="displayVitalsHeight">
					<xsl:with-param name="height" select="$height"/>
				</xsl:call-template>
			</div>
		</td>
	</xsl:template>

	<xsl:template name="displayVitalsBpItem">
		<xsl:param name="row"/>
		<td>
			<div style="overflow:hidden; white-space:nowrap; width:70px;">
				<xsl:call-template name="displayVitalsBp">
					<xsl:with-param name="row" select="$row"/>
				</xsl:call-template>
			</div>
		</td>
	</xsl:template>

	<xsl:template name="displayVitalsRespItem">
		<xsl:param name="resp"/>
		<td>
			<div style="overflow:hidden; white-space:nowrap; width:70px;">
				<xsl:call-template name="displayVitalsResp">
					<xsl:with-param name="resp" select="$resp"/>
				</xsl:call-template>
			</div>
		</td>
	</xsl:template>

	<xsl:template name="displayVitalsPulseItem">
		<xsl:param name="pulse"/>
		<td>
			<div style="overflow:hidden; white-space:nowrap; width:70px;">
				<xsl:call-template name="displayVitalsPulse">
					<xsl:with-param name="pulse" select="$pulse"/>
				</xsl:call-template>
			</div>
		</td>
	</xsl:template>

	<xsl:template name="getWeightResult">
		<xsl:param name="wt" />
		<xsl:for-each select="$wt">
			<xsl:if test="position()>1">
				<br/>
			</xsl:if>
			<xsl:choose>
				<xsl:when test="string-length(n1:value/@value)>1">
					<xsl:variable name="weightResult" select="n1:value/@value"/>
					<xsl:choose>
						<xsl:when test="n1:value/@unit">
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="concat($weightResult,n1:value/@unit)"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="flyoverSpan">
								<xsl:with-param name="data" select="$weightResult"/>
								<xsl:with-param name="freeText" select="''" />
								<xsl:with-param name="deSquigglefy" select="''" />
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="na"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>

	</xsl:template>

  <xsl:template name="formatNbComments">
  	<xsl:param name="title"/>
    <xsl:param name="comments"/>
  <div>
    <table class="comments">
      <tbody>
        <tr>
          <td>
          	<xsl:choose>
          		<xsl:when test="$title">
          			<xsl:value-of select="$title"/><xsl:text>: </xsl:text>
          		</xsl:when>
          	</xsl:choose>
            <xsl:value-of select="$comments"/>
          </td>
        </tr>
      </tbody>
    </table>
    <br/>
  </div>
  </xsl:template>

  <xsl:template name="formatNarrativeBlockComments">
  	<xsl:param name="table"/>
	<div>
		<table class="comments">
			<tbody>
				<xsl:for-each select="$table/n1:thead/n1:tr/n1:th">
					<tr class="first" align='left'><b><xsl:value-of select="."/></b></tr>
				</xsl:for-each>
				<xsl:for-each select="$table/n1:tbody/n1:tr">
					<tr class="second">
						<xsl:apply-templates select="./n1:td"/>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</div>
  </xsl:template>

</xsl:stylesheet>
