<#include "parsingFunctions.ftl">

<#macro displayAllergenWithDefault code={}>
<#-- BR for Displaying codes.  1) codeDisplayName 2) translationDisplayname 3)originalTextReference 4) originalText 5) Name -->
<#if ! code??>
	--
	<#return>
</#if>
<#if code.codeDisplayName??>
	${code.codeDisplayName}
<#elseif code.translations??>
	<#list code.translations as tran>
		${tran.codeDisplayName!"--"}
	</#list>
<#elseif code.codeOriginalTextMap??>
	<#assign omap = code.codeOriginalTextMap>
	<${omap.name} 
	<#list omap.attributes as attr>
		${attr.reference}="${attr.value}"
	</#list>
	>${omap.value!"--"}
	</${omap.name}>
<#elseif code.codeOriginalText??>
	${code.codeOriginalText}
<#elseif code.names??>
	<#list code.names as name>
		${name} <#if name_has_next>, </#if>
	</#list>
<#else>
	--
</#if>
</#macro>

<#macro displayReactionWithDefault reaction={}>
	<#if reaction.codeDisplayName??>
		${reaction.codeDisplayName}
	<#elseif reaction.translations??>
		<#list reaction.translations as trans>
			${tran.codeDisplayName!"--"}
		</#list>
	<#elseif reaction.textreferences??>
		<#assign omap = reaction.textreferences>
		<#if omap.value??>
			${omap.value}
		</#if>
	</#if>
</#macro>

<#-- Severity With out interpretation codes -->
<#macro displaySeverity severity = {}>
	<#-- value/@displayName  value/translation/@displayName  text/refernce/@value -->
	<#if severity.codeDisplayName??>
		${severity.codeDisplayName}
	<#elseif severity.translations??>
		<#list severity.translations as trans>
			<#if tran.codeDsiplayName??>
				${tran.codeDisplayName}
			</#if>
		</#list>
	<#elseif severity.textreferences??>
		<#assign omap = reaction.textreferences>
			<#if omap.value??>
				${omap.value}
			</#if>
	<#else>
		--
	</#if>
</#macro>

<#macro displayInterpretationCode interps = []>
	<#if interps??>
		<#list interps as interp>
			<#if interp.codeDisplayName??>
				(Interpretation=${interp.codeDisplayName})
			</#if>
		</#list>
	</#if>
</#macro>
