package gov.va.ccd.components.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openhealthtools.mdht.uml.cda.Encounter;
import org.openhealthtools.mdht.uml.cda.Entry;
import org.openhealthtools.mdht.uml.cda.ccd.ContinuityOfCareDocument;
import org.openhealthtools.mdht.uml.cda.ccd.EncountersSection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import gov.va.ccd.components.transform.Transformer;
import gov.va.ccd.mapper.TemplateMapper;

public class EncounterComponent extends AbstractComponent<EncountersSection>
{
	private static final Logger LOG = LoggerFactory.getLogger(EncounterComponent.class);

	public EncounterComponent(final ContinuityOfCareDocument ccdDocument)
	{
		super(ccdDocument.getEncountersSection(), ccdDocument);
	}

	@Override
	protected String generateXml()
	{

		try
		{
			Configuration cfg = TemplateMapper.getInstance().getCfg();
			Template temp = cfg.getTemplate("Encounter.xml");
			/* Merge data-model with template */

			StringWriter out = new StringWriter();

			temp.process(values, out);
			return out.toString();
		}
		catch(IOException e)
		{
			// CCR 177986
			LOG.error("error occurred", e);
		}
		catch(TemplateException e)
		{
			//CCR 177986
			LOG.error("error occurred from template" , e); 
		}
		
		return StringUtils.EMPTY;
	}

	@Override
	protected void createObjects()
	{
		List<Map<String, Object>> encounters = new ArrayList<Map<String, Object>>();
		Map<String, Object> encompassing = new HashMap<String, Object>();
		boolean firstPass = true;
		if(ccdDocument.getComponentOf() != null)
		{
			Transformer.mapEncompassingEncouner(encompassing, ccdDocument.getComponentOf().getEncompassingEncounter());
		}
		for(Entry entry : section.getEntries())
		{
			Map<String, Object> map = new HashMap<String, Object>();
			if(firstPass)
			{
				map.put("encompassing", encompassing);
				firstPass = false;
			}
			// Basically switch each type to see if this is a supported
			// type.
			if(entry.getEncounter() != null)
			{
				Encounter encounter = entry.getEncounter();

				Transformer.mapEncounterItem(map, encounter, narrativeText);
				// entry relationships For reason
				Transformer.mapObservationReason(map, encounter.getEntryRelationships(), narrativeText);
				if(!map.isEmpty())
				{
					encounters.add(map);
				}
			}
		}

		if(CollectionUtils.isNotEmpty(encounters))
		{
			values.put("encounters", encounters);
		}
	}
}
