package gov.va.soapui;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.request.AddWSSUsernameTokenAction;
import com.eviware.soapui.impl.wsdl.actions.request.AddWSTimestampAction;
import com.eviware.soapui.impl.wsdl.actions.request.AddWsaHeadersToRequestAction;
import com.eviware.soapui.impl.wsdl.actions.request.ApplyOutgoingWSSToRequestAction;
import com.eviware.soapui.impl.wsdl.actions.request.RemoveAllOutgoingWSSFromRequestAction;
import com.eviware.soapui.impl.wsdl.actions.request.RemoveWsaHeadersFromRequestAction;
import com.eviware.soapui.impl.wsdl.support.wss.DefaultWssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.plugins.auto.PluginRequestEditorView;
import com.eviware.soapui.support.editor.Editor;
import com.eviware.soapui.support.editor.views.xml.source.XmlSourceEditorView;
import com.eviware.soapui.support.editor.xml.XmlEditor;
import java.util.List;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

@PluginRequestEditorView(viewId = "PluginEditorView")
public class ConnectXmlRequestEditor extends XmlSourceEditorView {

    private ModelItem modelItem;
    private JMenu applyMenu;
    private JMenu wsaApplyMenu;
        
    public ConnectXmlRequestEditor(Editor<?> editor, ModelItem modelItem) {
        super((XmlEditor) editor, modelItem, false, "CONNECT XML");
        SoapUI.log("Loading CONNECT plugin");
        this.modelItem = modelItem;
    }

    @Override
    public void setEditable(boolean enabled) {

    }

    @Override
    public boolean saveDocument(boolean validate) {
        return true;
    }
    
    public ModelItem getModelItem() {
        return modelItem;
    }
    
    protected void buildPopup(JPopupMenu inputPopup, RSyntaxTextArea editArea) {
            super.buildPopup(inputPopup, editArea);

            inputPopup.insert(new JSeparator(), 2);
            inputPopup.insert(new AddWSSUsernameTokenAction((WsdlRequest) getModelItem()), 3);
            inputPopup.insert(new AddWSTimestampAction((WsdlRequest) getModelItem()), 4);
            inputPopup.insert(applyMenu = new JMenu("Outgoing WSS"), 5);
            inputPopup.insert(wsaApplyMenu = new JMenu("WS-A headers"), 6);
            inputPopup.insert(new JSeparator(), 7);

            inputPopup.addPopupMenuListener(new PopupMenuListener() {

                public void popupMenuCanceled(PopupMenuEvent e) {

                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {

                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    applyMenu.removeAll();
                    WsdlRequest request = (WsdlRequest) getModelItem();
                    DefaultWssContainer wss = request.getOperation().getInterface().getProject().getWssContainer();
                    List<OutgoingWss> outgoingWssList = wss.getOutgoingWssList();
                    applyMenu.setEnabled(!outgoingWssList.isEmpty());

                    for (OutgoingWss outgoing : outgoingWssList) {
                        applyMenu.add(new ApplyOutgoingWSSToRequestAction((WsdlRequest) getModelItem(), outgoing));
                        applyMenu.add(new CONNECTApplyOutgoingWSSToRequestAction((WsdlRequest) getModelItem(), outgoing));
                    }
                    applyMenu.add(new RemoveAllOutgoingWSSFromRequestAction((WsdlRequest) getModelItem()));

                    wsaApplyMenu.removeAll();
                    wsaApplyMenu.add(new AddWsaHeadersToRequestAction((WsdlRequest) getModelItem()));
                    wsaApplyMenu.add(new RemoveWsaHeadersFromRequestAction((WsdlRequest) getModelItem()));
                    wsaApplyMenu.setEnabled(request.getWsaConfig().isWsaEnabled());
                }
            });
        }
}
