/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.soapui;

import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.AssertionWrapper;

/**
 *
 * @author adambell
 */
public final class CONNECTSAMLUtil {
    private CONNECTSAMLUtil() {
        // Complete
    }
    
     /**
     * Parse a SAML Assertion to obtain a SAMLKeyInfo object from
     * the Subject of the assertion
     * 
     * @param assertion The SAML Assertion
     * @param data The RequestData instance used to obtain configuration
     * @param docInfo A WSDocInfo instance
     * @param bspCompliant Whether to process tokens in compliance with the BSP spec or not
     * @return a SAMLKeyInfo object
     * @throws WSSecurityException
     */
    public static SAMLKeyInfo getCredentialFromSubject(
        CONNECTAssertionWrapper assertion, 
        RequestData data,
        WSDocInfo docInfo,
        boolean bspCompliant
    ) throws WSSecurityException {
        if (assertion.getSaml1() != null) {
            return SAMLUtil.getCredentialFromSubject(assertion.getSaml1(), data, docInfo, bspCompliant);
        } else {
            return SAMLUtil.getCredentialFromSubject(assertion.getSaml2(), data, docInfo, bspCompliant);
        }
    }
    
}
