/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.soapui;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.saml.ext.SAMLCallback;
import org.apache.ws.security.saml.ext.bean.KeyInfoBean;
import org.apache.ws.security.saml.ext.bean.SubjectBean;
import org.apache.ws.security.saml.ext.builder.SAML2Constants;
import org.opensaml.common.SAMLVersion;

/**
 *
 * @author adambell
 */
public class CONNECTSAML2CallbackHandler extends AbstractCONNECTSAMLCallbackHandler {

    /**
     * Use this is for signed assertions
     */
    public CONNECTSAML2CallbackHandler(Crypto crypto, String alias, String assertionTypeFriendlyName, String confirmationMethodFriendlyName) throws Exception {
        super(crypto, alias, assertionTypeFriendlyName, confirmationMethodFriendlyName);
        if (this.certs == null) {
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias(alias);
            this.certs = crypto.getX509Certificates(cryptoType);
        }
    }
    
    /**
     * Use this is for unsigned assertions
     */
    public CONNECTSAML2CallbackHandler(String assertionTypeFriendlyName, String confirmationMethodFriendlyName) {
        super(assertionTypeFriendlyName, confirmationMethodFriendlyName);
    }

    @Override
    public void setConfirmationMethod(String confirmationMethodFriendlyName) {
        if (confirmationMethodFriendlyName.equals(CONNECTSAMLEntry.HOLDER_OF_KEY_CONFIRMATION_METHOD)) {
            confirmationMethod = SAML2Constants.CONF_HOLDER_KEY;
        } else if (confirmationMethodFriendlyName.equals(CONNECTSAMLEntry.SENDER_VOUCHES_CONFIRMATION_METHOD)) {
            confirmationMethod = SAML2Constants.CONF_SENDER_VOUCHES;
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; i++) {
            if (callbacks[i] instanceof CONNECTSAMLCallback) {
                CONNECTSAMLCallback callback = (CONNECTSAMLCallback) callbacks[i];
                callback.setSamlVersion(SAMLVersion.VERSION_20);
                callback.setIssuer(issuer);
                callback.setIssuerFormat(issuerFormat);
                SubjectBean subjectBean = new SubjectBean(subjectName, subjectQualifier, confirmationMethod);
                if (subjectNameIDFormat != null) {
                    subjectBean.setSubjectNameIDFormat(subjectNameIDFormat);
                }
                if (SAML2Constants.CONF_HOLDER_KEY.equals(confirmationMethod)) {
                    try {
                        KeyInfoBean keyInfo = createKeyInfo();
                        subjectBean.setKeyInfo(keyInfo);
                    } catch (Exception ex) {
                        throw new IOException("Problem creating KeyInfo: " + ex.getMessage());
                    }
                }
                callback.setSubject(subjectBean);
                createAndSetStatement(null, callback);
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
    }
    
}
