/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.soapui;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.request.ApplyOutgoingWSSToRequestAction;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.event.ActionEvent;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import org.w3c.dom.Document;

/**
 *
 * @author Adam Bell
 */
public class CONNECTApplyOutgoingWSSToRequestAction extends AbstractAction {
    private final WsdlRequest request;
    private final CONNECTOutgoingWss outgoing;
    public CONNECTApplyOutgoingWSSToRequestAction(WsdlRequest request, OutgoingWss outgoing) {
        super("Apply CONNECT SAML using: \" " + outgoing.getName() + " \"");
        this.request = request;
        this.outgoing = new CONNECTOutgoingWss(outgoing);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String req = request.getRequestContent();

        try {
            UISupport.setHourglassCursor();
            Document dom = XmlUtils.parseXml(req);
            outgoing.processOutgoing(dom, new DefaultPropertyExpansionContext(request));
            StringWriter writer = new StringWriter();
            XmlUtils.serialize(dom, writer);
            request.setRequestContent(writer.toString());
        } catch (Exception e1) {
            UISupport.showErrorMessage(e1);
        } finally {
            UISupport.resetCursor();
        }
    }
    
}
