CREATE OR REPLACE PROCEDURE facility_procedure(facility_name IN VARCHAR2, facility_number IN VARCHAR2, home_community_id IN VARCHAR2) AS
soap_request	varchar(30000);
soap_response	varchar(30000);
http_req		utl_http.req;
http_resp		utl_http.resp;

BEGIN
soap_request := 
'<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:par="http://partner.service.nvap.DNS   /">
   <soapenv:Header/>
   <soapenv:Body>
      <par:updatePartnerList>
         <partner>
            <communityIdPrefix>urn:oid:</communityIdPrefix>
            <contact></contact>
            <domain>N/A</domain>
            <name>'|| facility_name ||'</name>
            <number>'|| facility_number ||'</number>
            <oid>'|| home_community_id ||'</oid>
         </partner>
         <announce>false</announce>
      </par:updatePartnerList>
   </soapenv:Body>
</soapenv:Envelope>';

http_req := utl_http.begin_request('http://nvpapp-dem-DNS   /PartnerOnboardingBean/PartnerOnboardingBeanService', 'POST', 'HTTP/1.1');
utl_http.set_header(http_req, 'Content-Type', 'text/xml;charset=UTF-8');
utl_http.set_header(http_req, 'Content-Length', length(soap_request));

utl_http.write_text(http_req, soap_request);
http_resp := utl_http.get_response(http_req);

utl_http.read_text(http_resp, soap_response);
utl_http.end_response(http_resp);
END;
