CREATE TABLE ADAPTER.FACILITIES_OPERATIONS
(
  FACILITY_ID                 NUMBER,
  IN_ALLOW_PATIENT_DICOVERY   VARCHAR2(1 BYTE),
  IN_ALLOW_DOC_QUERY          VARCHAR2(1 BYTE),
  IN_ALLOW_DOC_RETRIEVE       VARCHAR2(1 BYTE),
  OUT_ALLOW_PATIENT_DICOVERY  VARCHAR2(1 BYTE),
  OUT_ALLOW_DOC_QUERY         VARCHAR2(1 BYTE),
  OUT_ALLOW_DOC_RETRIEVE      VARCHAR2(1 BYTE),
  ON_OFF_BOARD                VARCHAR2(1 BYTE)
);


--  There is no statement for index ADAPTER.SYS_C0058738.
--  The object is created when the parent object is created.

ALTER TABLE ADAPTER.FACILITIES_OPERATIONS ADD (
  CONSTRAINT BI_ON_OFF_BOARD
  CHECK (ON_OFF_BOARD IN ('Y','N'))
  ENABLE VALIDATE);

ALTER TABLE ADAPTER.FACILITIES_OPERATIONS ADD (
  CONSTRAINT IN_CHECK_DOC_QUERY
  CHECK (IN_ALLOW_DOC_QUERY IN ('Y','N') )
  ENABLE VALIDATE);

ALTER TABLE ADAPTER.FACILITIES_OPERATIONS ADD (
  CONSTRAINT IN_CHECK_DOC_RETRIEVE
  CHECK (IN_ALLOW_DOC_RETRIEVE IN ('Y','N'))
  ENABLE VALIDATE);

ALTER TABLE ADAPTER.FACILITIES_OPERATIONS ADD (
  CONSTRAINT IN_CHECK_PATIENT_DICOVERY
  CHECK (IN_ALLOW_PATIENT_DICOVERY IN ('Y','N'))
  ENABLE VALIDATE);

ALTER TABLE ADAPTER.FACILITIES_OPERATIONS ADD (
  CONSTRAINT OUT_CHECK_DOC_QUERY
  CHECK (OUT_ALLOW_DOC_QUERY IN ('Y','N') )
  ENABLE VALIDATE);

ALTER TABLE ADAPTER.FACILITIES_OPERATIONS ADD (
  CONSTRAINT OUT_CHECK_DOC_RETRIEVE
  CHECK (OUT_ALLOW_DOC_RETRIEVE IN ('Y','N'))
  ENABLE VALIDATE);

ALTER TABLE ADAPTER.FACILITIES_OPERATIONS ADD (
  CONSTRAINT OUT_CHECK_PATIENT_DICOVERY
  CHECK (OUT_ALLOW_PATIENT_DICOVERY IN ('Y','N'))
  ENABLE VALIDATE);

ALTER TABLE ADAPTER.FACILITIES_OPERATIONS ADD (
  PRIMARY KEY
  (FACILITY_ID)
  ENABLE VALIDATE);
