set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool Adapter6.8.5_update.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/
SET DEFINE OFF;


alter trigger ADAPTER.INT_FAC_TRG disable;

declare
  OLD_FACILITY_ID NUMBER;
  NEW_FACILITY_ID NUMBER;
begin
  -- CCM-137 - Temporarily Deactivate MHV C-CDA CCD Filter for Compensation and Pension NotesA
  select FACILITY_ID into OLD_FACILITY_ID
  from ADAPTER.INT_FACILITIES
  where FACILITY_NUMBER = 'MHV';

  select ADAPTER.INT_FAC_SEQ.NEXTVAL into NEW_FACILITY_ID from DUAL;

  insert into ADAPTER.INT_FACILITIES(FACILITY_ID, FACILITY_NUMBER, FACILITY_NAME)
  values (NEW_FACILITY_ID, 'MHV-D', 'My HealthE Vet (disabled)');

  update ADAPTER.INT_FAC_FILT
  set FACILITY_ID = NEW_FACILITY_ID
  where FACILITY_ID = OLD_FACILITY_ID
  and ROOT_NAME in ('progressNotes', 'consultnotes', 'encounterDocs')
  and OBJ_NAME = 'nationalTitleService'
  and PARAM in ('COMPENSATION & PENSION', 'COMPENSATION &amp; PENSION');
  -- CCM-137 - Temporarily Deactivate MHV C-CDA CCD Filter for Compensation and Pension Notes end

  -- CCM-103 - (Defect) MHV Data Filter Incorrectly Filtering Outpatient Encounters
  update ADAPTER.INT_FAC_FILT
  set FACILITY_ID = NEW_FACILITY_ID
  where FACILITY_ID = OLD_FACILITY_ID
  and ROOT_NAME = 'visits'
  and OBJ_NAME = 'documents'
  and PARAM = '10';
  -- CCM-103 - (Defect) MHV Data Filter Incorrectly Filtering Outpatient Encounters end
end;
/

commit;

alter trigger ADAPTER.INT_FAC_TRG enable;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;
