set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool 8.0.0_Update_Script.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/
SET DEFINE OFF;

CREATE SEQUENCE ADAPTER.BINARY_ID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;

CREATE SEQUENCE ADAPTER.DOCUMENT_REFERENCE_ID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;

CREATE SEQUENCE ADAPTER.SUBSCRIPTION_ID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;

CREATE TABLE ADAPTER.BINARIES
(
  BINARY_ID          NUMBER,
  RESOURCE_ID        VARCHAR2(36 BYTE)                 NOT NULL,
  CREATED_TIME       TIMESTAMP(6) WITH LOCAL TIME ZONE NOT NULL,
  LAST_UPDATED_TIME  TIMESTAMP(6) WITH LOCAL TIME ZONE NOT NULL,
  FHIR_RESOURCE      BLOB
)
LOB (FHIR_RESOURCE) STORE AS BASICFILE (TABLESPACE ADAPTER_LOBDATA01)
TABLESPACE ADAPTER_DATA01;

CREATE UNIQUE INDEX ADAPTER.BINARIES_PK ON ADAPTER.BINARIES
(BINARY_ID)
TABLESPACE ADAPTER_INDEX01;

CREATE UNIQUE INDEX ADAPTER.BINARIES_UK1 ON ADAPTER.BINARIES
(RESOURCE_ID)
TABLESPACE ADAPTER_INDEX01;

CREATE OR REPLACE TRIGGER ADAPTER.BINARY_ID_TRG
BEFORE INSERT
ON ADAPTER.BINARIES
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
BEGIN
-- For Toad:  Highlight column BINARY_ID
  if :NEW.BINARY_ID is null then
    :NEW.BINARY_ID := BINARY_ID_SEQ.NEXTVAL;
  end if;
END BINARY_ID_TRG;
/

ALTER TABLE ADAPTER.BINARIES ADD (
  CONSTRAINT BINARIES_PK
  PRIMARY KEY
  (BINARY_ID)
  USING INDEX ADAPTER.BINARIES_PK
  ENABLE VALIDATE);

CREATE TABLE ADAPTER.DOCUMENT_REFERENCES
(
  DOCUMENT_REFERENCE_ID  NUMBER,
  RESOURCE_ID            VARCHAR2(36 BYTE)                 NOT NULL,
  PATIENT_ID             VARCHAR2(17 BYTE)                 NOT NULL,
  CREATED_TIME           TIMESTAMP(6) WITH LOCAL TIME ZONE NOT NULL,
  LAST_UPDATED_TIME      TIMESTAMP(6) WITH LOCAL TIME ZONE NOT NULL,
  FHIR_RESOURCE          BLOB
)
LOB (FHIR_RESOURCE) STORE AS BASICFILE (TABLESPACE ADAPTER_LOBDATA01)
TABLESPACE ADAPTER_DATA01;

CREATE UNIQUE INDEX ADAPTER.DOCUMENT_REFERENCES_PK ON ADAPTER.DOCUMENT_REFERENCES
(DOCUMENT_REFERENCE_ID)
TABLESPACE ADAPTER_INDEX01;

CREATE UNIQUE INDEX ADAPTER.DOCUMENT_REFERENCES_UK1 ON ADAPTER.DOCUMENT_REFERENCES
(RESOURCE_ID)
TABLESPACE ADAPTER_INDEX01;

CREATE OR REPLACE TRIGGER ADAPTER.DOCUMENT_REFERENCE_ID_TRG
BEFORE INSERT
ON ADAPTER.DOCUMENT_REFERENCES
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
begin
  if :NEW.DOCUMENT_REFERENCE_ID is null then
    :new.DOCUMENT_REFERENCE_ID := DOCUMENT_REFERENCE_ID_SEQ.NEXTVAL;
  end if;
end;
/

ALTER TABLE ADAPTER.DOCUMENT_REFERENCES ADD (
  CONSTRAINT DOCUMENT_REFERENCES_PK
  PRIMARY KEY
  (DOCUMENT_REFERENCE_ID)
  USING INDEX ADAPTER.DOCUMENT_REFERENCES_PK
  ENABLE VALIDATE);

CREATE TABLE ADAPTER.SUBSCRIPTIONS
(
  SUBSCRIPTION_ID    NUMBER                     NOT NULL,
  RESOURCE_ID        VARCHAR2(36 BYTE),
  STATUS             VARCHAR2(255 BYTE),
  CRITERIA           VARCHAR2(255 BYTE),
  CHANNEL            VARCHAR2(255 BYTE),
  USER_ID            VARCHAR2(255 BYTE),
  USER_NAME          VARCHAR2(255 BYTE),
  ORGANIZATION_ID    VARCHAR2(255 BYTE),
  ORGANIZATION_NAME  VARCHAR2(255 BYTE),
  PURPOSE_OF_USE     VARCHAR2(255 BYTE),
  CREATED_TIME       TIMESTAMP(6) WITH LOCAL TIME ZONE DEFAULT sysdate,
  LAST_UPDATED_TIME  TIMESTAMP(6) WITH LOCAL TIME ZONE,
  FHIR_RESOURCE      BLOB
)
LOB (FHIR_RESOURCE) STORE AS BASICFILE (TABLESPACE ADAPTER_LOBDATA01)
TABLESPACE ADAPTER_DATA01;

CREATE UNIQUE INDEX ADAPTER.SUBSCRIPTIONS_PK ON ADAPTER.SUBSCRIPTIONS
(SUBSCRIPTION_ID)
TABLESPACE ADAPTER_INDEX01;

CREATE UNIQUE INDEX ADAPTER.SUBSCRIPTIONS_UK1 ON ADAPTER.SUBSCRIPTIONS
(RESOURCE_ID)
TABLESPACE ADAPTER_INDEX01;

CREATE OR REPLACE TRIGGER ADAPTER.SUBSCRIPTION_ID_TRG
BEFORE INSERT
ON ADAPTER.SUBSCRIPTIONS
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
begin
  if :NEW.SUBSCRIPTION_ID is null then
    :NEW.SUBSCRIPTION_ID := SUBSCRIPTION_ID_SEQ.NEXTVAL;
  end if;
end;
/

ALTER TABLE ADAPTER.SUBSCRIPTIONS ADD (
  CONSTRAINT SUBSCRIPTIONS_PK
  PRIMARY KEY
  (SUBSCRIPTION_ID)
  USING INDEX ADAPTER.SUBSCRIPTIONS_PK
  ENABLE VALIDATE);

GRANT SELECT ON ADAPTER.BINARY_ID_SEQ TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.DOCUMENT_REFERENCE_ID_SEQ TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.SUBSCRIPTION_ID_SEQ TO ADAPTER_USER;

GRANT SELECT ON ADAPTER.BINARIES TO ADAPTER_READ;
GRANT SELECT, UPDATE, INSERT, DELETE ON ADAPTER.BINARIES TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.DOCUMENT_REFERENCES TO ADAPTER_READ;
GRANT SELECT, UPDATE, INSERT, DELETE ON ADAPTER.DOCUMENT_REFERENCES TO ADAPTER_USER;
GRANT SELECT ON ADAPTER.SUBSCRIPTIONS TO ADAPTER_READ;
GRANT SELECT, UPDATE, INSERT, DELETE ON ADAPTER.SUBSCRIPTIONS TO ADAPTER_USER;

CREATE PUBLIC SYNONYM BINARY_ID_SEQ FOR ADAPTER.BINARY_ID_SEQ;
CREATE PUBLIC SYNONYM DOCUMENT_REFERENCE_ID_SEQ FOR ADAPTER.DOCUMENT_REFERENCE_ID_SEQ;
CREATE PUBLIC SYNONYM SUBSCRIPTION_ID_SEQ FOR ADAPTER.SUBSCRIPTION_ID_SEQ;

CREATE PUBLIC SYNONYM BINARIES FOR ADAPTER.BINARIES;
CREATE PUBLIC SYNONYM DOCUMENT_REFERENCES FOR ADAPTER.DOCUMENT_REFERENCES;
CREATE PUBLIC SYNONYM SUBSCRIPTIONS FOR ADAPTER.SUBSCRIPTIONS;

-- Updates for CCM-196.
ALTER TABLE ADAPTER.CACHE ADD DATE_CREATED DATE DEFAULT SYSDATE;
-- end updates for CCM-196.

-- Updates for CCM-235: Updates radiology hold_period to include referenceDateTime -- 
-- clean up duplicate radiologies filters.  Should delete two (2) records.
DELETE FROM ADAPTER.INT_FAC_FILT WHERE ROOT_NAME = 'radiologies' AND OBJ_NAME = 'signingClinician.dateTime' and FILTER_ID = 7 AND FACILITY_ID = 1;
INSERT INTO ADAPTER.INT_FAC_FILT (ROOT_NAME, OBJ_NAME, FILTER_ID, FACILITY_ID, PARAM) VALUES ('radiologies', 'signingClinician.dateTime,referenceDateTime', 7, 1, '3');
-- updates radiology Date_Greater to include referenceDateTime --
UPDATE ADAPTER.INT_FAC_FILT SET OBJ_NAME = 'signingClinician.dateTime,referenceDateTime' WHERE ROOT_NAME = 'radiologies' AND FACILITY_ID = 1 AND FILTER_ID = 5;
-- end Updates for CCM-235.

-- Updates for CCM-258.
UPDATE ADAPTER.INT_FAC_FILT SET ROOT_NAME = 'visits.documents', PARAM = '5' WHERE ROOT_NAME = 'visits' AND OBJ_NAME IS NULL AND FILTER_ID = 8 AND FACILITY_ID = 1;
-- adds 3 day hold to mhv based visits documents
INSERT INTO ADAPTER.INT_FAC_FILT (FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM) VALUES (1,7,'visits.documents','signingClinician.dateTime',3);
INSERT INTO ADAPTER.INT_FAC_FILT (FACILITY_ID, FILTER_ID, ROOT_NAME, OBJ_NAME, PARAM) VALUES (1,5,'visits.documents','signingClinician.dateTime','0313101');
-- end Updates for CCM-258.

declare
  NEXT_VA_TYPE_ID ADAPTER.VA_TYPES.VA_TYPE_ID%TYPE;
begin
  NEXT_VA_TYPE_ID := ADAPTER.VA_TYPES_SEQ.NEXTVAL;

  insert into ADAPTER.VA_TYPES (VA_TYPE_ID, LOINC_CODE, LOINC_DESC, DOC_SPEC_TYPE, QUERYNAME)
  values (NEXT_VA_TYPE_ID, '34133-9', 'Summarization of episode note', 'C-CDA R2.1', '34133-9-C2');

  insert into ADAPTER.FACILITY_SUPPORTED_TYPES(FACILITY_ID, VA_TYPE_ID, IS_PREF_TYPE)
  select FACILITY_ID, NEXT_VA_TYPE_ID as VA_TYPE_ID, 'N' as IS_PREF_TYPE
  from ADAPTER.FACILITIES;
end;

commit;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;
