set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool 7.4.0_Update_Script_Backout.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/
SET DEFINE OFF;

declare
  NEW_VA_TYPE_ID ADAPTER.VA_TYPES.VA_TYPE_ID%TYPE;
begin
  select VA_TYPE_ID
  into NEW_VA_TYPE_ID
  from ADAPTER.VA_TYPES
  where LOINC_CODE = '34133-9' and DOC_SPEC_TYPE = 'C-CDA R2.1';
  
  delete from ADAPTER.FACILITY_SUPPORTED_TYPES
  where VA_TYPE_ID = NEW_VA_TYPE_ID;
  
  delete from ADAPTER.VA_TYPES
  where VA_TYPE_ID = NEW_VA_TYPE_ID;
end;
/

commit;


ALTER TABLE CACHE DROP DATE_CREATED;

commit;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;
