set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool 7.4.0_Update_Script.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/
SET DEFINE OFF;

-- fix VA_TYPES_TRG insert trigger to only set VA_TYPE_ID if new VA_TYPE_ID is null.
-- NOTE: this change WILL NOT be backed out since it's being done to fix
-- a trigger that was created incorrectly in the first place.
CREATE OR REPLACE TRIGGER ADAPTER.VA_TYPES_TRG
BEFORE INSERT
ON ADAPTER.VA_TYPES
FOR EACH ROW
BEGIN
  if :NEW.VA_TYPE_ID is null then
    :NEW.VA_TYPE_ID := ADAPTER.VA_TYPES_SEQ.NEXTVAL;
  end if;
END VA_TYPES_TRG;
/
declare
  NEXT_VA_TYPE_ID ADAPTER.VA_TYPES.VA_TYPE_ID%TYPE;
begin
  NEXT_VA_TYPE_ID := ADAPTER.VA_TYPES_SEQ.NEXTVAL;

  insert into ADAPTER.VA_TYPES (VA_TYPE_ID, LOINC_CODE, LOINC_DESC, DOC_SPEC_TYPE, QUERYNAME)
  values (NEXT_VA_TYPE_ID, '34133-9', 'Summarization of episode note', 'C-CDA R2.1', '34133-9-C2');

  insert into ADAPTER.FACILITY_SUPPORTED_TYPES(FACILITY_ID, VA_TYPE_ID, IS_PREF_TYPE)
  select FACILITY_ID, NEXT_VA_TYPE_ID as VA_TYPE_ID, 'N' as IS_PREF_TYPE
  from ADAPTER.FACILITIES;
end;
/

ALTER TABLE CACHE ADD DATE_CREATED DATE DEFAULT NULL;
ALTER TABLE CACHE MODIFY DATE_CREATED DEFAULT SYSDATE;

commit;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;


