set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool 7.3.0_Update_Script_Backout.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/
SET DEFINE OFF;

declare
  NEW_VA_TYPE_ID ADAPTER.VA_TYPES.VA_TYPE_ID%TYPE;
begin
  select VA_TYPE_ID
  into NEW_VA_TYPE_ID
  from ADAPTER.VA_TYPES
  where LOINC_CODE = '11506-3';
  
  delete from ADAPTER.FACILITY_SUPPORTED_TYPES
  where VA_TYPE_ID = NEW_VA_TYPE_ID;
  
  delete from ADAPTER.VA_TYPES
  where VA_TYPE_ID = NEW_VA_TYPE_ID;
end;
/

delete from ADAPTER.TRANSLATIONS
where SOURCE_CODESET = 'VAROUTE';

delete from ADAPTER.CODESETS
where CODESET = 'FDA-ROUTING';

commit;


/
SET DEFINE OFF;

-- US.01.02.07 - Send eHX  Files to Diameter Health (DH) and DQ Team Server
DROP PUBLIC SYNONYM DQ_TRANSMISSION_LOG;
DROP TRIGGER ADAPTER.DQ_TRANSMISSION_ID_TRG;
DROP TABLE ADAPTER.DQ_TRANSMISSION_LOG;
DROP SEQUENCE ADAPTER.DQ_TRANSMISSION_ID_SEQ;
-- end US.01.02.07 - Send eHX  Files to Diameter Health (DH) and DQ Team Server

-- CCM198 - Clinical Procedure Notes - 3-day hold
UPDATE ADAPTER.INT_FAC_FILT SET OBJ_NAME = 'signingClinician.dateTime' WHERE ROOT_NAME = 'clinicalProcedureNotes' and FAC_FILT_ID = 28;
UPDATE ADAPTER.INT_FAC_FILT SET OBJ_NAME = 'signingClinician.dateTime' WHERE ROOT_NAME = 'clinicalProcedureNotes' and FAC_FILT_ID = 11;
-- end  CCM198 - Clinical Procedure Notes - 3-day hold

commit;

-- CCM-138
alter table ADAPTER.INT_FAC_FILT drop column COND_ROOT_NAME;
alter table ADAPTER.INT_FAC_FILT drop column COND_OBJ_NAME;
alter table ADAPTER.INT_FAC_FILT drop column COND_PARAM;
alter table ADAPTER.INT_FAC_FILT drop column COND_FILTER_ID;

CREATE OR REPLACE VIEW ADAPTER.INT_FAC_FILT_VIEW AS
SELECT
FAC_FILT_ID,FACILITY_NAME,FACILITY_NUMBER,FILTER_NAME,ROOT_NAME,OBJ_NAME,PARAM
FROM
(
   (
      ADAPTER.INT_FAC_FILT S
      INNER JOIN ADAPTER.INT_FACILITIES F ON S.FACILITY_ID = F.FACILITY_ID
   )
   INNER JOIN ADAPTER.INT_FILT_CONST V ON S.FILTER_ID = V.FILTER_ID
);

delete from ADAPTER.INT_FILT_CONST where FILTER_NAME in ('CONTAINS_REGEX', 'NOT_CONTAINS_REGEX');

delete from ADAPTER.INT_FAC_FILT
where FILTER_ID = 7
and ROOT_NAME = 'consultnotes'
and OBJ_NAME = 'signingClinician.dateTime'
and PARAM = '30';

delete from ADAPTER.INT_FAC_FILT
where FILTER_ID = 7
and ROOT_NAME = 'progressNotes'
and OBJ_NAME = 'signingClinician.dateTime'
and PARAM = '30';

commit;
-- end CCM-138

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;
