set echo on
set feedback on
set serveroutput on
var start_date  varchar2(80);
var end_date    varchar2(80);
var sid         varchar2(10);
var host        varchar2(30);
var user        varchar2(30);


spool 7.3.0_Update_Script.log;

begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :start_date from dual;
  select instance_name into :sid from v$instance;
  select host_name into :host from v$instance;
  select user into :user from dual;

  dbms_output.put_line('Script executed on SID:  '||:sid);
  dbms_output.put_line('Script executed on host: '||:host);
  dbms_output.put_line('Script start date/time:  '||:start_date);
  dbms_output.put_line('Script executed by:      '||:user);
end;
/
SET DEFINE OFF;

-- fix VA_TYPES_TRG insert trigger to only set VA_TYPE_ID if new VA_TYPE_ID is null.
-- NOTE: this change WILL NOT be backed out since it's being done to fix
-- a trigger that was created incorrectly in the first place.
CREATE OR REPLACE TRIGGER ADAPTER.VA_TYPES_TRG
BEFORE INSERT
ON ADAPTER.VA_TYPES
FOR EACH ROW
BEGIN
  if :NEW.VA_TYPE_ID is null then
    :NEW.VA_TYPE_ID := ADAPTER.VA_TYPES_SEQ.NEXTVAL;
  end if;
END VA_TYPES_TRG;
/
declare
  NEXT_VA_TYPE_ID ADAPTER.VA_TYPES.VA_TYPE_ID%TYPE;
begin
  NEXT_VA_TYPE_ID := ADAPTER.VA_TYPES_SEQ.NEXTVAL;

  insert into ADAPTER.VA_TYPES (VA_TYPE_ID, LOINC_CODE, LOINC_DESC, DOC_SPEC_TYPE, QUERYNAME)
  values (NEXT_VA_TYPE_ID, '11506-3', 'Progress Note', 'HITSP 2.5', '11506-3');

  insert into ADAPTER.FACILITY_SUPPORTED_TYPES(FACILITY_ID, VA_TYPE_ID, IS_PREF_TYPE)
  select FACILITY_ID, NEXT_VA_TYPE_ID as VA_TYPE_ID, 'Y' as IS_PREF_TYPE
  from ADAPTER.FACILITIES;
end;
/

INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'VAROUTE', 'ID', 'FDA-ROUTING', 'C38238', 'INTRADERMAL');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'VAROUTE', 'IM', 'FDA-ROUTING', 'C28161', 'INTRAMUSCULAR');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'VAROUTE', 'NS', 'FDA-ROUTING', 'C38284', 'NASAL');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'VAROUTE', 'IV', 'FDA-ROUTING', 'C38276', 'INTRAVENOUS');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'VAROUTE', 'PO', 'FDA-ROUTING', 'C38288', 'ORAL');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'VAROUTE', 'SC', 'FDA-ROUTING', 'C38299', 'SUBCUTANEOUS');
INSERT INTO 
  ADAPTER.TRANSLATIONS (TRANSLATION_ID, SOURCE_CODESET, SOURCE_CODE, TARGET_CODESET, TARGET_CODE, DISPLAY_NAME) 
VALUES 
  (ADAPTER.TRANSLATION_ID_SEQ.NEXTVAL, 'VAROUTE', 'TD', 'FDA-ROUTING', 'C38305', 'TRANSDERMAL');
INSERT INTO ADAPTER.CODESETS 
   (CODESET_ID, CODESET, LOOKUP_TABLE, KEY_FIELD) 
VALUES 
   (33, 'FDA-ROUTING', 'TRANSLATIONS', 'TARGET_CODE');
  
/* CCM-138 changes */
alter table ADAPTER.INT_FAC_FILT add COND_ROOT_NAME    VARCHAR2(255 BYTE);
alter table ADAPTER.INT_FAC_FILT add COND_OBJ_NAME     VARCHAR2(255 BYTE);
alter table ADAPTER.INT_FAC_FILT add COND_PARAM        VARCHAR2(255 BYTE);
alter table ADAPTER.INT_FAC_FILT add COND_FILTER_ID		INTEGER;	

CREATE OR REPLACE VIEW ADAPTER.INT_FAC_FILT_VIEW AS
SELECT
FAC_FILT_ID,FACILITY_NAME,FACILITY_NUMBER,FILTER_NAME,ROOT_NAME,OBJ_NAME,PARAM,COND_ROOT_NAME,COND_OBJ_NAME,COND_PARAM,COND_FILTER_ID
FROM
(
   (
      ADAPTER.INT_FAC_FILT S
      INNER JOIN ADAPTER.INT_FACILITIES F ON S.FACILITY_ID = F.FACILITY_ID
   )
   INNER JOIN ADAPTER.INT_FILT_CONST V ON S.FILTER_ID = V.FILTER_ID
);

insert into ADAPTER.INT_FILT_CONST (filter_id, filter_name) values (9, 'CONTAINS_REGEX');
insert into ADAPTER.INT_FILT_CONST (filter_id, filter_name) values (10, 'NOT_CONTAINS_REGEX');
INSERT INTO ADAPTER.INT_FAC_FILT VALUES (110, 1, 7, 'consultnotes', 'signingClinician.dateTime', '30','consultnotes', 'nationalTitle', '^.*(?i)(C&P|C & P|Comp and Pen|Compensation and Pension|Compensation & Pension|Compensation&Pension).*$',null);
INSERT INTO ADAPTER.INT_FAC_FILT VALUES (111, 1, 7, 'progressNotes', 'signingClinician.dateTime', '30','progressNotes', 'nationalTitle', '^.*(?i)(C&P|C & P|Comp and Pen|Compensation and Pension|Compensation & Pension|Compensation&Pension).*$',null);
/*  end CCM-138 changes */

-- CCM198 - Clinical Procedure Notes - 3-day hold
UPDATE ADAPTER.INT_FAC_FILT SET OBJ_NAME = 'signingClinician.dateTime,referenceDateTime' WHERE ROOT_NAME = 'clinicalProcedureNotes' and FAC_FILT_ID = 28;
UPDATE ADAPTER.INT_FAC_FILT SET OBJ_NAME = 'signingClinician.dateTime,referenceDateTime' WHERE ROOT_NAME = 'clinicalProcedureNotes' and FAC_FILT_ID = 11;
-- end CCM198 - Clinical Procedure Notes - 3-day hold

-- US.01.02.07 - Send eHX  Files to Diameter Health (DH) and DQ Team Server
CREATE TABLE ADAPTER.DQ_TRANSMISSION_LOG
(
  DQ_TRANSMISSION_ID            NUMBER          NOT NULL,
  BATCH_ID                      VARCHAR2(255 BYTE),
  EVENT_TYPE                    VARCHAR2(255 BYTE),
  START_TIME                    TIMESTAMP(6)    NOT NULL,
  END_TIME                      TIMESTAMP(6),
  HOSTNAME                      VARCHAR2(255 BYTE), 
  LOCAL_DOC_ID                  VARCHAR2(255 BYTE),
  FILENAME                      VARCHAR2(255 BYTE),
  FILETYPE                      VARCHAR2(255 BYTE),
  FILESIZE                      NUMBER,
  DESTINATION                   VARCHAR2(255 BYTE),
  STATUS                        VARCHAR2(255 BYTE),
  REMOTE_DOC_ID                 VARCHAR2(255 BYTE),
  ERROR                         VARCHAR2(3000 BYTE)
)
TABLESPACE ADAPTER_DATA01;

CREATE UNIQUE INDEX ADAPTER.DQ_TRANSMISSION_LOG_PK ON ADAPTER.DQ_TRANSMISSION_LOG
(DQ_TRANSMISSION_ID)
TABLESPACE ADAPTER_INDEX01;

CREATE INDEX ADAPTER.NDX_DQTRANSLOG_START_TIME ON ADAPTER.DQ_TRANSMISSION_LOG
(START_TIME)
TABLESPACE ADAPTER_INDEX01;

CREATE INDEX ADAPTER.NDX_DQTRANSLOG_FILENAME ON ADAPTER.DQ_TRANSMISSION_LOG
(FILENAME)
TABLESPACE ADAPTER_INDEX01;

CREATE INDEX ADAPTER.NDX_DQTRANSLOG_LOCAL_DOC_ID ON ADAPTER.DQ_TRANSMISSION_LOG
(LOCAL_DOC_ID)
TABLESPACE ADAPTER_INDEX01;

CREATE SEQUENCE ADAPTER.DQ_TRANSMISSION_ID_SEQ
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER;

CREATE OR REPLACE TRIGGER ADAPTER.DQ_TRANSMISSION_ID_TRG 
BEFORE INSERT
ON ADAPTER.DQ_TRANSMISSION_LOG 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
declare
  N NUMBER;
begin
    if :NEW.DQ_TRANSMISSION_ID is null then
        select DQ_TRANSMISSION_ID_SEQ.NEXTVAL into N from DUAL;
        :new.DQ_TRANSMISSION_ID := N;
    end if;
end DQ_TRANSMISSION_ID_TRG;
/

ALTER TABLE ADAPTER.DQ_TRANSMISSION_LOG ADD (
  CONSTRAINT DQ_TRANSMISSION_LOG_PK
  PRIMARY KEY
  (DQ_TRANSMISSION_ID)
  USING INDEX ADAPTER.DQ_TRANSMISSION_LOG_PK
  ENABLE VALIDATE);
  
GRANT SELECT ON ADAPTER.DQ_TRANSMISSION_LOG TO ADAPTER_READ;

GRANT DELETE, INSERT, SELECT, UPDATE ON ADAPTER.DQ_TRANSMISSION_LOG TO ADAPTER_USER;

CREATE PUBLIC SYNONYM DQ_TRANSMISSION_LOG FOR ADAPTER.DQ_TRANSMISSION_LOG;
-- end US.01.02.07 - Send eHX  Files to Diameter Health (DH) and DQ Team Server


commit;

Set Define on;

Begin
  select to_char(sysdate, 'mm-dd-yyyy hh24:mi:ss') into :end_date from dual;
  dbms_output.put_line('Script end date/time:    '||:end_date);
  dbms_output.put_line('Script executed in '||(to_date(:end_date, 'mm_dd_yyyy hh24:mi:ss') - to_date(:start_date, 'mm-dd-yyyy hh24:mi:ss')) *24*60*60||' seconds');
end;
/

Spool off;


