package gov.va.med.nhin.adapter.weblogic;

import java.io.InputStream;
import java.util.logging.*;

import javax.management.*;
import javax.naming.*;

import weblogic.logging.*;

/**
 *
 * Weblogic startup class used to redirect java.util.logging output to
 * weblogic server log.
 *
 * @author David Vazquez
 */
public class LoggingStartup
{
    private static final Logger logger = Logger.getLogger(LoggingStartup.class.getName());

    static public void main(String[] args)
        throws Exception
    {
        LogManager logManager = LogManager.getLogManager();
        Logger weblogicLogger = LoggingHelper.getServerLogger();
        Logger rootLogger = Logger.getLogger("");

        logManager.reset();

        InputStream is = null;
        try
            {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("adapterLogging.properties");
            logManager.readConfiguration(is);
            }
        finally
            {
            if(is != null)
                {
                is.close();
                }
            }

        // uncomment this if you don't want java.util.logging output to go to
        // stderr/stdout which usually ends up in <domain>/server/logs/*.out file.
        /*for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }*/

        // Add the weblogic log handlers to the java.util.logging root logger.
        for (Handler handler : weblogicLogger.getHandlers()) {
            rootLogger.addHandler(handler);
        }

        // Register wllogger so that it can be manipulated through the mbean
        boolean alreadythere = !LogManager.getLogManager().addLogger(weblogicLogger);

        // Register mbean
        InitialContext ctx = null;
        String[] names = new String[] {"java:comp/jmx/runtime", "java:comp/env/jmx/runtime"};
        for (int i = 0; i < names.length; i++) {
            try {
                ctx = new InitialContext();
                MBeanServer mbeanServer = (MBeanServer)ctx.lookup(names[i]);
                mbeanServer.registerMBean(LogManager.getLoggingMXBean(),
                                          new ObjectName("java.util.logging:type=Logging"));
            }
            catch (Exception e) {
                logger.warning("Unable to register logger mbean with " + names[i] + ".");
            }
            finally {
                safeClose(ctx);
            }
        }

        logger.info("java.util.logging successfully redirected to weblogic server log.");
    }

    static private void safeClose(Context ctx)
    {
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (Exception e) {
        }
    }
}
