/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.server;

import java.io.IOException;
import javax.inject.Inject;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

/**
 *
 * @author david
 */
@ServerEndpoint("/SubscriptionWS")
public class SubscriptionWSEndpoint
{
    @Inject
    private SessionCache sessionCache;

    @OnMessage
    public void onMessage(String message, Session session)
    {
        try {
            if (message.startsWith("bind ")) {
                String subscriptionID = message.split(" ")[1];
                if (sessionCache.registerSubscriptionSession(subscriptionID, session)) {
                    session.getBasicRemote().sendText("bound " + subscriptionID);
                }
                else {
                    session.getBasicRemote().sendText("notbound " + subscriptionID);
                }
            }
            else if (message.startsWith("unbind ")) {
                String subscriptionID = message.split(" ")[1];
                if (sessionCache.unregisterSubscriptionSession(subscriptionID, session)) {
                    session.getBasicRemote().sendText("unbound " + subscriptionID);
                }
                else {
                    session.getBasicRemote().sendText("notunbound " + subscriptionID);
                }
            }
        }
        catch (IOException ioe) {
            // TODO: handle this exception properly.
        }
    }

    @OnClose
    public void onClose(Session session)
    {
        sessionCache.unregisterSession(session);
    }
}
