/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import gov.va.med.nhin.adapter.subscription.web.resourceprovider.BinaryResourceProvider;
import gov.va.med.nhin.adapter.subscription.web.resourceprovider.DocumentReferenceResourceProvider;
import gov.va.med.nhin.adapter.subscription.web.resourceprovider.SubscriptionResourceProvider;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
/**
 *
 * @author david_vetsez
 */
@Named("SubscriptionServlet")
@ApplicationScoped()
@WebServlet(urlPatterns = "/FHIR/*", displayName = "eHX FHIR Subscription Service")
public class SubscriptionServlet extends RestfulServer
{
    private SubscriptionResourceProvider subscriptionResourceProvider;
    private DocumentReferenceResourceProvider documentReferenceResourceProvider;
    private BinaryResourceProvider binaryResourceProvider;
    
    public SubscriptionServlet()
    {
        super(FhirContext.forDstu3());
    }
    
    @Override
    protected void initialize() throws ServletException
    {
        List<IResourceProvider> resourceProviders = new ArrayList<>();
        resourceProviders.add(subscriptionResourceProvider);
        resourceProviders.add(documentReferenceResourceProvider);
        resourceProviders.add(binaryResourceProvider);
        setResourceProviders(resourceProviders);
    }
    
    @Inject
    public void setSubscriptionResourceProvider(SubscriptionResourceProvider s)
    {
        this.subscriptionResourceProvider = s;
    }
    
    @Inject
    public void setDocumentReferenceResourceProvider(DocumentReferenceResourceProvider d)
    {
        this.documentReferenceResourceProvider = d;
    }

    @Inject
    public void setBinaryResourceProvider(BinaryResourceProvider binaryResourceProvider)
    {
        this.binaryResourceProvider = binaryResourceProvider;
    }
    
    @Produces
    @Override
    public FhirContext getFhirContext()
    {
        return super.getFhirContext();
    }
}
