/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.server;

import gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription.SubscriptionProvider;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.websocket.Session;
import org.hl7.fhir.dstu3.model.IdType;

/**
 *
 * @author david
 */
@ApplicationScoped
public class SessionCache
{
    @Inject
    private SubscriptionProvider subscriptionProvider;
    private final Map<String, Session> subscriptionIDToSessionMap = new ConcurrentHashMap<>();

    public boolean registerSubscriptionSession(String subscriptionID, Session session)
    {
        boolean ret;
        if (subscriptionProvider.read(new IdType("Subscription", subscriptionID)) != null) {
            subscriptionIDToSessionMap.put(subscriptionID, session);
            ret = true;
        }
        else {
            ret = false;
        }
        return ret;
    }

    public boolean unregisterSubscriptionSession(String subscriptionID, Session session)
    {
        return subscriptionIDToSessionMap.remove(subscriptionID) != null;
    }
    
    public void unregisterSession(Session session)
    {
        for (Iterator<Map.Entry<String, Session>> it = subscriptionIDToSessionMap.entrySet().iterator();
             it.hasNext();) {
            Map.Entry<String, Session> entry = it.next();
            if (entry.getValue().getId().equals(session.getId())) {
                it.remove();
            }
        }
    }

    public void pingSubscriber(String subscriptionID) throws IOException
    {
        Session session = subscriptionIDToSessionMap.get(subscriptionID);
        if (session != null) {
            session.getBasicRemote().sendText("ping " + subscriptionID);
        }
    }
}
