/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.resourceprovider;

import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.server.IResourceProvider;
import gov.va.med.nhin.adapter.subscription.web.process.DocumentProcessor;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.binary.BinaryProvider;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.hl7.fhir.dstu3.model.Binary;
import org.hl7.fhir.dstu3.model.IdType;

/**
 *
 * @author david_vetsez
 */
@ApplicationScoped()
@Named("BinaryResourceProvider")
public class BinaryResourceProvider implements IResourceProvider
{
    @Inject
    private DocumentProcessor documentProcessor;
    
    @Override
    public Class<Binary> getResourceType()
    {
        return Binary.class;
    }

    @Read
    public Binary read(@IdParam IdType id)
    {
        return documentProcessor.getDocument(id.getIdPart());
    }

    public void setDocumentProcessor(DocumentProcessor documentProcessor)
    {
        this.documentProcessor = documentProcessor;
    }
}
