/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription;

import gov.va.med.nhin.adapter.subscription.web.dao.InMemoryDAO;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Named;
import org.hl7.fhir.dstu3.model.IdType;

/**
 *
 * @author DNS   VAZQUD
 */
@Named("InMemmorySubscriptionProvider")
@ApplicationScoped()
@Alternative()
public class InMemorySubscriptionProvider implements SubscriptionProvider
{
    private InMemoryDAO<EHXSubscription> inMemoryDAO = new InMemoryDAO<>();

    @Override
    public Long create(EHXSubscription resource)
    {
        SubscriptionProvider.super.create(resource);
        return inMemoryDAO.store(resource);
    }

    @Override
    public EHXSubscription read(Long id)
    {
        return inMemoryDAO.findByID(id);
    }

    @Override
    public EHXSubscription read(IdType id)
    {
        return inMemoryDAO.findByResourceID(id.getIdPart());
    }

    @Override
    public void update(Long id, EHXSubscription resource)
    {
        SubscriptionProvider.super.update(id, resource);
        inMemoryDAO.update(id, resource);
    }

    @Override
    public EHXSubscription delete(Long id)
    {
        return inMemoryDAO.delete(id);
    }
}
