/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.documentquery;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.CeType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunitiesType;
import gov.hhs.fha.nhinc.common.nhinccommon.NhinTargetCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.PersonNameType;
import gov.hhs.fha.nhinc.common.nhinccommon.UserType;
import gov.hhs.fha.nhinc.common.nhinccommonentity.RespondingGatewayCrossGatewayQueryRequestType;
import gov.hhs.fha.nhinc.entitydocquery.EntityDocQuery;
import gov.hhs.fha.nhinc.entitydocquery.EntityDocQueryPortType;
import gov.va.med.nhin.adapter.subscription.web.annotations.Property;
import gov.va.med.nhin.adapter.subscription.web.dao.FacilityDAO;
import gov.va.med.nhin.adapter.subscription.web.entity.Facility;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXDocumentReference;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryRequest;
import oasis.names.tc.ebxml_regrep.xsd.query._3.AdhocQueryResponse;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.AdhocQueryType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ClassificationType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExternalIdentifierType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ExtrinsicObjectType;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.SlotType1;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.ValueListType;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.RegistryError;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.DocumentReference.DocumentReferenceContentComponent;
import org.hl7.fhir.dstu3.model.DocumentReference.DocumentReferenceContextComponent;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 * @author david
 */
@Named("WSDocumentQueryer")
@ApplicationScoped()
public class WSDocumentQueryer implements DocumentQueryer
{
    private EntityDocQuery entityDocQuery;
    private static final Logger log = LoggerFactory.getLogger(WSDocumentQueryer.class);

    @Inject
    @Property
    private String entityDocQueryWSDL;

    @Inject
    @Property
    private String vaAssigningAuthorityID;

    @Inject
    private FacilityDAO facilityDAO;

    @Override
    public DocumentQueryerResponse sendDocumentQuery(String forPatientID, String nhioHCID, EHXSubscription.Assertions assertions)
    {
        List<EHXDocumentReference> documentReferences;
        List<String> errors;
        boolean success;

        try {
            RespondingGatewayCrossGatewayQueryRequestType request
                                                          = buildRequest(forPatientID, nhioHCID, assertions);
            AdhocQueryResponse response = getPort().respondingGatewayCrossGatewayQuery(request);
            documentReferences = extractDocumentReferencesFromAdhocQueryResponse(forPatientID, response);
            errors = extractErrorsFromAdhocQueryResponse(response);
            success = !documentReferences.isEmpty() || errors.isEmpty();
        }
        catch (WebServiceException wse) {
            documentReferences = null;
            errors = new ArrayList<>();
            errors.add("Failied to invoke call to EntityDocQuery service - " + wse.getLocalizedMessage());
            success = false;
        }

        return new DocumentQueryerResponse(documentReferences, errors, success);
    }

    private RespondingGatewayCrossGatewayQueryRequestType buildRequest(String patientID,
                                                                       String hcid, EHXSubscription.Assertions assertions)
    {
        RespondingGatewayCrossGatewayQueryRequestType ret
                                                      = new RespondingGatewayCrossGatewayQueryRequestType();

        ret.setAdhocQueryRequest(buildAdhocQueryRequest(patientID, hcid));
        ret.setNhinTargetCommunities(buildNhinTargetCommunities(hcid));
        ret.setAssertion(buildAssertion(patientID, assertions));

        return ret;
    }

    private AdhocQueryRequest buildAdhocQueryRequest(String patientId, String hcid)
    {
        AdhocQueryRequest req = new AdhocQueryRequest();
        AdhocQueryType adhoc = new AdhocQueryType();

        {
            SlotType1 slot = new SlotType1();
            slot.setName("$XDSDocumentEntryPatientId");
            ValueListType vlt = new ValueListType();
            vlt.getValue().add(patientId + "^^^&" + vaAssigningAuthorityID + "&ISO");
            slot.setValueList(vlt);
            adhoc.getSlot().add(slot);
        }
        /*
        {  // TODO: read this from configuration.
            SlotType1 slot = new SlotType1();
            slot.setName("$XDSDocumentEntryClassCode");
            ValueListType vlt = new ValueListType();
            vlt.getValue().add("34133-9");
            slot.setValueList(vlt);
            adhoc.getSlot().add(slot);
        }
         */
        {
            SlotType1 slot = new SlotType1();
            slot.setName("$XDSDocumentEntryStatus");
            ValueListType vlt = new ValueListType();
            vlt.getValue().add("urn:ihe:iti:2010:StatusType:DeferredCreation");
            vlt.getValue().add("urn:oasis:names:tc:ebxmlregrep:StatusType:Approved");
            slot.setValueList(vlt);
            adhoc.getSlot().add(slot);
        }
        /*
        {
            SlotType1 slot = new SlotType1();
            slot.setName("$XDSDocumentEntryServiceStartTimeFrom");
            ValueListType vlt = new ValueListType();
            vlt.getValue().add("18660609000000");
            slot.setValueList(vlt);
            adhoc.getSlot().add(slot);
        }
        {
            SlotType1 slot = new SlotType1();
            slot.setName("$XDSDocumentEntryServiceStopTimeTo");
            ValueListType vlt = new ValueListType();
            vlt.getValue().add("20180609235959");
            slot.setValueList(vlt);
            adhoc.getSlot().add(slot);
        }
         */

        req.setAdhocQuery(adhoc);

        return req;
    }

    private AssertionType buildAssertion(String patientID, EHXSubscription.Assertions assertions)
    {
        AssertionType ret = new AssertionType();
        Facility homeFacility = getHomeFacility();

        ret.setAuthorized(true);

        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeFacility.getFullHomeCommunityId());
        homeCommunity.setName(homeFacility.getFacilityName());
        ret.setHomeCommunity(homeCommunity);

        UserType user = new UserType();
        user.setPersonName(buildPersonName(assertions.getUserName().asStringValue()));
        user.setUserName(assertions.getUserID().asStringValue());
        HomeCommunityType userOrganization = new HomeCommunityType();
        userOrganization.setHomeCommunityId(assertions.getOrganizationID().asStringValue());
        userOrganization.setName(assertions.getOrganizationName().asStringValue());
        userOrganization.setDescription(assertions.getSystemID().asStringValue());
        user.setOrg(userOrganization);
        CeType roleCoded = new CeType();
        roleCoded.setCode(assertions.getRole().asStringValue());
        user.setRoleCoded(roleCoded);
        ret.setUserInfo(user);

        CeType pouCoded = new CeType();
        pouCoded.setCode(assertions.getPurposeOfUse().asStringValue());
        ret.setPurposeOfDisclosureCoded(pouCoded);

        ret.getUniquePatientId().add(patientID + "^^^&" + vaAssigningAuthorityID + "&ISO");

        return ret;
    }

    private PersonNameType buildPersonName(String username)
    {
        PersonNameType ret = new PersonNameType();
        String[] parts = username.split(" ");

        ret.setGivenName(parts[0]);
        ret.setFamilyName(parts[parts.length - 1]);
        ret.setFullName(username);

        return ret;
    }

    private NhinTargetCommunitiesType buildNhinTargetCommunities(String hcid)
    {
        NhinTargetCommunitiesType ret = new NhinTargetCommunitiesType();
        NhinTargetCommunityType nhinTargetCommunity = new NhinTargetCommunityType();
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(hcid);
        nhinTargetCommunity.setHomeCommunity(homeCommunity);
        ret.getNhinTargetCommunity().add(nhinTargetCommunity);
        return ret;
    }

    private synchronized EntityDocQueryPortType getPort()
    {
        try {
            if (entityDocQuery == null) {
                entityDocQuery = new EntityDocQuery(new URL(entityDocQueryWSDL));
            }

            return entityDocQuery.getPort(new QName("urn:gov:hhs:fha:nhinc:entitydocquery", "EntityDocQueryPortSoap11"), EntityDocQueryPortType.class);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("entityDocQjueryWSDL is not set to a valid URL.  Fix the configuration.");
        }
    }

    private List<EHXDocumentReference> extractDocumentReferencesFromAdhocQueryResponse(String patientID, AdhocQueryResponse resp)
    {
        List<EHXDocumentReference> docs = new ArrayList<>();

        /*
		<ns1:AdhocQueryResponse status="urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success" xmlns:ns1="urn:oasis:names:tc:ebxml-regrep:xsd:query:3.0" xmlns:ns2="urn:oasis:names:tc:ebxml-regrep:xsd:rs:3.0" xmlns:ns3="urn:oasis:names:tc:ebxml-regrep:xsd:rim:3.0">
			<ns3:RegistryObjectList>
				<ns3:ExtrinsicObject id="urn:uuid:5bd8bbe6-600a-427d-8a50-30380b468bc7" home="urn:oid:2.16.840.1.113883.4.349.1" lid="2.25.247607127039652694019884901037845175251" objectType="urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1" status="urn:oasis:names:tc:ebxml-regrep:StatusType:Approved" mimeType="text/xml" isOpaque="false">
					 <ns3:Slot name="creationTime">
							<ns3:ValueList>
								 <ns3:Value>20170724152503</ns3:Value>
							</ns3:ValueList>
					 </ns3:Slot>
					 <ns3:Slot name="hash">
							<ns3:ValueList>
								 <ns3:Value>cea215d9611b4d40d791d1a6f21e0fd09c9dc773</ns3:Value>
							</ns3:ValueList>
					 </ns3:Slot>
					 <ns3:Slot name="languageCode">
							<ns3:ValueList>
								 <ns3:Value>en-US</ns3:Value>
							</ns3:ValueList>
					 </ns3:Slot>
					 <ns3:Slot name="serviceStartTime">
							<ns3:ValueList>
								 <ns3:Value>19600303000000</ns3:Value>
							</ns3:ValueList>
					 </ns3:Slot>
					 <ns3:Slot name="serviceStopTime">
							<ns3:ValueList>
								 <ns3:Value>20170724152503</ns3:Value>
							</ns3:ValueList>
					 </ns3:Slot>
					 <ns3:Slot name="size">
							<ns3:ValueList>
								 <ns3:Value>1056840</ns3:Value>
							</ns3:ValueList>
					 </ns3:Slot>
					 <ns3:Slot name="sourcePatientId">
							<ns3:ValueList>
								 <ns3:Value>1012581676V377803^^^&amp;2.16.840.1.113883.4.349.1&amp;ISO</ns3:Value>
							</ns3:ValueList>
					 </ns3:Slot>
					 <ns3:Slot name="repositoryUniqueId">
							<ns3:ValueList>
								 <ns3:Value>2.16.840.1.113883.4.349.1.1</ns3:Value>
							</ns3:ValueList>
					 </ns3:Slot>
					 <ns3:Name>
							<ns3:LocalizedString value="Department of Veterans Affairs Summarization of Episode Note"/>
					 </ns3:Name>
					 <ns3:VersionInfo versionName="1.1"/>
					 <ns3:Classification id="urn:uuid:afc899ab-e586-4ad1-884d-d09fe5cb98df" classificationScheme="urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d" classifiedObject="urn:uuid:5bd8bbe6-600a-427d-8a50-30380b468bc7" nodeRepresentation="">
							<ns3:Slot name="authorPerson">
								 <ns3:ValueList>
										<ns3:Value>Department of Veterans Affairs</ns3:Value>
								 </ns3:ValueList>
							</ns3:Slot>
							<ns3:Slot name="authorInstitution">
								 <ns3:ValueList>
										<ns3:Value>DEPARTMENT OF VETERANS AFFAIRS</ns3:Value>
								 </ns3:ValueList>
							</ns3:Slot>
					 </ns3:Classification>
					 <ns3:Classification id="urn:uuid:c8c3c611-3d0c-44de-90c8-a2ac906b5538" classificationScheme="urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a" classifiedObject="urn:uuid:5bd8bbe6-600a-427d-8a50-30380b468bc7" nodeRepresentation="34133-9">
							<ns3:Slot name="codingScheme">
								 <ns3:ValueList>
										<ns3:Value>2.16.840.1.113883.6.1</ns3:Value>
								 </ns3:ValueList>
							</ns3:Slot>
							<ns3:Name>
								 <ns3:LocalizedString value="Summarization of episode note"/>
							</ns3:Name>
					 </ns3:Classification>
					 <ns3:Classification id="urn:uuid:743ef770-90c3-4d56-b4c1-8b2f8232c3e5" classificationScheme="urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f" classifiedObject="urn:uuid:5bd8bbe6-600a-427d-8a50-30380b468bc7" nodeRepresentation="N">
							<ns3:Slot name="codingScheme">
								 <ns3:ValueList>
										<ns3:Value>2.16.840.1.113883.5.25</ns3:Value>
								 </ns3:ValueList>
							</ns3:Slot>
							<ns3:Name>
								 <ns3:LocalizedString value="Normal"/>
							</ns3:Name>
					 </ns3:Classification>
					 <ns3:Classification id="urn:uuid:371d9bae-fdae-4530-8da6-fe737b1d2e96" classificationScheme="urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d" classifiedObject="urn:uuid:5bd8bbe6-600a-427d-8a50-30380b468bc7" nodeRepresentation="urn:hl7-org:sdwg:ccda-structuredBody:1.1">
							<ns3:Slot name="codingScheme">
								 <ns3:ValueList>
										<ns3:Value>1.3.6.1.4.1.19376.1.2.3</ns3:Value>
								 </ns3:ValueList>
							</ns3:Slot>
							<ns3:Name>
								 <ns3:LocalizedString value="C-CDA R1.1 CCD Document"/>
							</ns3:Name>
					 </ns3:Classification>
					 <ns3:Classification id="urn:uuid:979eb517-946d-4d67-9484-c29b985ac0d2" classificationScheme="urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1" classifiedObject="urn:uuid:5bd8bbe6-600a-427d-8a50-30380b468bc7" nodeRepresentation="48311003">
							<ns3:Slot name="codingScheme">
								 <ns3:ValueList>
										<ns3:Value>2.16.840.1.113883.6.96</ns3:Value>
								 </ns3:ValueList>
							</ns3:Slot>
							<ns3:Name>
								 <ns3:LocalizedString value="Hospital-Veterans' Administration"/>
							</ns3:Name>
					 </ns3:Classification>
					 <ns3:Classification id="urn:uuid:62659995-4327-4b6e-80a3-67be568806a9" classificationScheme="urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead" classifiedObject="urn:uuid:5bd8bbe6-600a-427d-8a50-30380b468bc7" nodeRepresentation="394802001">
							<ns3:Slot name="codingScheme">
								 <ns3:ValueList>
										<ns3:Value>2.16.840.1.113883.6.96</ns3:Value>
								 </ns3:ValueList>
							</ns3:Slot>
							<ns3:Name>
								 <ns3:LocalizedString value="General Medicine"/>
							</ns3:Name>
					 </ns3:Classification>
					 <ns3:Classification id="urn:uuid:ad395ace-db5a-4f14-9808-b31e71e68fe1" classificationScheme="urn:uuid:f0306f51-975f-434e-a61c-c59651d33983" classifiedObject="urn:uuid:5bd8bbe6-600a-427d-8a50-30380b468bc7" nodeRepresentation="34133-9">
							<ns3:Slot name="codingScheme">
								 <ns3:ValueList>
										<ns3:Value>2.16.840.1.113883.6.1</ns3:Value>
								 </ns3:ValueList>
							</ns3:Slot>
							<ns3:Name>
								 <ns3:LocalizedString value="Summarization of episode note"/>
							</ns3:Name>
					 </ns3:Classification>
					 <ns3:ExternalIdentifier id="urn:uuid:ac6adbc0-b3b4-4186-b5a9-72df696420b5" registryObject="urn:uuid:5bd8bbe6-600a-427d-8a50-30380b468bc7" identificationScheme="urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab" value="2.25.247607127039652694019884901037845175251">
							<ns3:Name>
								 <ns3:LocalizedString value="XDSDocumentEntry.uniqueId"/>
							</ns3:Name>
					 </ns3:ExternalIdentifier>
					 <ns3:ExternalIdentifier id="urn:uuid:307123b7-0555-4233-85d8-0417b14f9e39" registryObject="urn:uuid:5bd8bbe6-600a-427d-8a50-30380b468bc7" identificationScheme="urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427" value="1012581676V377803^^^&amp;2.16.840.1.113883.4.349.1&amp;ISO">
							<ns3:Name>
								 <ns3:LocalizedString value="XDSDocumentEntry.patientId"/>
							</ns3:Name>
					 </ns3:ExternalIdentifier>
				</ns3:ExtrinsicObject>
			</ns3:RegistryObjectList>
		</ns1:AdhocQueryResponse>
         */
        if (resp.getRegistryObjectList() != null) {
            resp.getRegistryObjectList().getIdentifiable().stream().map((ii) -> ii.getValue()).filter((i) -> (i instanceof ExtrinsicObjectType)).forEachOrdered((i) -> {
                docs.add(extractDocumentReferenceFromExtrinsicObject(patientID, ExtrinsicObjectType.class.cast(i)));
            });
        }

        return docs;
    }

    private EHXDocumentReference extractDocumentReferenceFromExtrinsicObject(String patientID, ExtrinsicObjectType doc)
    {
        EHXDocumentReference ret = new EHXDocumentReference();

        ret.setIdElement(new IdType(ret.fhirType(), UUID.randomUUID().toString()));

        extractIdentifiers(doc.getExternalIdentifier(), ret);
        extractClassifications(doc.getClassification(), ret);
        extractSlots(doc.getSlot(), ret);
        extractRest(doc, patientID, ret);

        return ret;
    }

    private void extractIdentifiers(List<ExternalIdentifierType> externalIdentifiers, EHXDocumentReference documentReference)
    {
        //final String EBXML_RESPONSE_PATIENTID_IDENTIFICATION_SCHEME = "urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427";
        final String EBXML_RESPONSE_DOCID_IDENTIFICATION_SCHEME = "urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab";

        for (ExternalIdentifierType externalIdentifier : externalIdentifiers) {
            switch (externalIdentifier.getIdentificationScheme()) {
                case EBXML_RESPONSE_DOCID_IDENTIFICATION_SCHEME:
                    Identifier id = new Identifier();
                    id.setValue(externalIdentifier.getValue());
                    documentReference.setMasterIdentifier(id);
                    documentReference.setDocumentUniqueId(externalIdentifier.getValue());
                    break;

                default:
                    break;
            }
        }
    }

    private void extractClassifications(List<ClassificationType> classifications, EHXDocumentReference documentReference)
    {
        final String EBXML_RESPONSE_CLASSCODE_CLASS_SCHEME = "urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a";
        final String EBXML_RESPONSE_FORMATCODE_CLASS_SCHEME = "urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d";
        final String EBXML_RESPONSE_TYPECODE_CLASS_SCHEME = "urn:uuid:f0306f51-975f-434e-a61c-c59651d33983";
        final String EBXML_RESPONSE_AUTHOR_CLASS_SCHEME = "urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d";
        
        for (ClassificationType classification : classifications) {
            switch (classification.getClassificationScheme()) {
                case EBXML_RESPONSE_CLASSCODE_CLASS_SCHEME:
                    CodeableConcept cls = new CodeableConcept();
                    Coding clsCoding = new Coding();
                    clsCoding.setCode(classification.getNodeRepresentation());
                    clsCoding.setSystem("http://loinc.org");
                    clsCoding.setDisplay(getLocalizedName(classification));
                    cls.addCoding(clsCoding);
                    documentReference.setClass_(cls);
                    break;

                case EBXML_RESPONSE_FORMATCODE_CLASS_SCHEME:
                    DocumentReferenceContentComponent drcc = new DocumentReferenceContentComponent();
                    Coding formatCoding = new Coding();
                    formatCoding.setCode(classification.getNodeRepresentation());
                    formatCoding.setSystem("urn:oid:1.3.6.1.4.1.19376.1.2.3");
                    formatCoding.setDisplay(getLocalizedName(classification));
                    drcc.setFormat(formatCoding);
                    documentReference.getContentFirstRep().setFormat(formatCoding);
                    break;

                case EBXML_RESPONSE_TYPECODE_CLASS_SCHEME:
                    CodeableConcept type = new CodeableConcept();
                    Coding typeCoding = new Coding();
                    typeCoding.setCode(classification.getNodeRepresentation());
                    typeCoding.setSystem("http://loinc.org");
                    typeCoding.setDisplay(getLocalizedName(classification));
                    type.addCoding(typeCoding);
                    documentReference.setType(type);
                    break;
                    
                case EBXML_RESPONSE_AUTHOR_CLASS_SCHEME:
                    break;
                    
                default:
                    break;
            }
        }
    }

    private String getLocalizedName(ClassificationType fromClassification)
    {
        String ret = null;
        
        if (fromClassification.getName() != null
            && fromClassification.getName().getLocalizedString() != null
            && !fromClassification.getName().getLocalizedString().isEmpty()) {
            ret = fromClassification.getName().getLocalizedString().get(0).getValue();
        }
        
        return ret;
    }
    
    private void extractSlots(List<SlotType1> slots, EHXDocumentReference documentReference)
    {
        final SimpleDateFormat SDF = new SimpleDateFormat("YYYYMMddHHmmss");
        DocumentReferenceContentComponent drcc = documentReference.getContentFirstRep();
        Attachment attachment = new Attachment();
        drcc.setAttachment(attachment);

        // Be sure created is set even if it's not provided in the document entry.
        documentReference.setCreated(new Date());

        documentReference.setContext(new DocumentReferenceContextComponent());

        for (SlotType1 slot : slots) {
            String value = slot.getValueList().getValue().get(0);
            switch (slot.getName()) {
                case "size":
                    attachment.setSize(Integer.parseInt(value));
                    break;

                case "hash":
                    attachment.setHash(value.getBytes());
                    break;

                case "languageCode":
                    attachment.setLanguage(value);
                    break;

                case "repositoryUniqueId":
                    documentReference.setRepositoryUniqueId(value);
                    break;

                case "creationTime":
                    try {
                        documentReference.setCreated(SDF.parse(value));
                    }
                    catch (ParseException pe) {
                        // use default value.
                    }
                    break;

                case "serviceStartTime":
                    try {
                        documentReference.getContext().getPeriod().setStart(SDF.parse(value));
                    }
                    catch (ParseException pe) {
                    }
                    break;

                case "serviceStopTime":
                    try {
                        documentReference.getContext().getPeriod().setEnd(SDF.parse(value));
                    }
                    catch (ParseException pe) {
                    }
                    break;

                default:
                    break;
            }
        }
    }

    private void extractRest(ExtrinsicObjectType docEntry, String patientID, EHXDocumentReference documentReference)
    {
        Reference patient = new Reference();
        patient.setReference("Patient/" + patientID);
        documentReference.setSubject(patient);

        documentReference.setHomeCommunityId(docEntry.getHome());

        Attachment attachment = documentReference.getContent().get(0).getAttachment();
        attachment.setContentType(docEntry.getMimeType());
        attachment.setUrl("Binary/" + documentReference.getIdElement().getIdPart());
        documentReference.getContent().get(0).getAttachment().setContentType(docEntry.getMimeType());

        if (docEntry.getName().getLocalizedString().size() > 0) {
            documentReference.setDescription(docEntry.getName().getLocalizedString().get(0).getValue());
        }
        else {
            documentReference.setDescription("<<<NO TITLE>>>");
        }
    }

    private List<String> extractErrorsFromAdhocQueryResponse(AdhocQueryResponse resp)
    {
        List<String> ret = new ArrayList<>();

        if (resp.getRegistryErrorList() != null) {
            for (RegistryError re : resp.getRegistryErrorList().getRegistryError()) {
                ret.add(String.format("%s - %s - %s - %s - %s",
                                      re.getLocation(),
                                      re.getSeverity(),
                                      re.getErrorCode(),
                                      re.getCodeContext(),
                                      re.getValue()));

            }
        }

        return ret;
    }

    private Facility getHomeFacility()
    {
        return facilityDAO.findByFacilityNumber("VA");
    }

    public void setEntityDocQuery(EntityDocQuery entityDocQuery)
    {
        this.entityDocQuery = entityDocQuery;
    }

    public void setEntityDocQueryWSDL(String entityDocQueryWSDL)
    {
        this.entityDocQueryWSDL = entityDocQueryWSDL;
    }

    public void setVaAssigningAuthorityID(String vaAssigningAuthorityID)
    {
        this.vaAssigningAuthorityID = vaAssigningAuthorityID;
    }

    public void setFacilityDAO(FacilityDAO facilityDAO)
    {
        this.facilityDAO = facilityDAO;
    }
}
