/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.documentquery;

import gov.va.med.nhin.adapter.subscription.web.resource.EHXDocumentReference;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Named;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.DocumentReference.DocumentReferenceContentComponent;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;

/**
 *
 * @author david
 */
@Named("MockDocumentQueryer")
@ApplicationScoped()
@Alternative()
public class MockDocumentQueryer implements DocumentQueryer
{
    @Override
    public DocumentQueryerResponse sendDocumentQuery(String forPatientID, String nhioHCID, EHXSubscription.Assertions assertions)
    {
        System.out.println("sendDocumentQuery(" + forPatientID + ", " + nhioHCID + ", " + assertions + ")");

        try {
            Thread.sleep((long)(Math.random() * 10000L));
        }
        catch (InterruptedException ie) {}
        
        final List<EHXDocumentReference> ret = new ArrayList<>();
        final EHXDocumentReference dr = new EHXDocumentReference();

        dr.setHomeCommunityId(nhioHCID);
        dr.setRepositoryUniqueId(nhioHCID);
        dr.setDocumentUniqueId("doc-id-1234567");
        
        // Master Identifier.
        Identifier masterIdentifier = new Identifier();
        masterIdentifier.setValue("doc-id-1234567");
        masterIdentifier.setSystem("urn:id:1.3.4.4.5.6.7");
        dr.setMasterIdentifier(masterIdentifier);
        
        // Status
        dr.setStatus(Enumerations.DocumentReferenceStatus.CURRENT);
        
        // Description.
        dr.setDescription("Document for " + forPatientID + " from " + nhioHCID);
        
        // Type
        CodeableConcept type = new CodeableConcept();
        Coding typeCoding = new Coding();
        typeCoding.setSystem("http://ihe.net/connectathon/classCodes");
        typeCoding.setCode("History and Physical");
        typeCoding.setDisplay("History and Physical");
        type.addCoding(typeCoding);
        dr.setType(type);
        
        // Class
        CodeableConcept cls = new CodeableConcept();
        Coding clsCoding = new Coding();
        clsCoding.setSystem("http://loinc.org");
        clsCoding.setCode("34133-9");
        clsCoding.setDisplay("Summarization of Episode Note");
        cls.addCoding(clsCoding);
        dr.setClass_(cls);

        // Subjeect
        Reference patient = new Reference();
        patient.setReference("Patient/" + forPatientID);
        dr.setSubject(patient);
        
        // Created and Indexed.
        Date submissionTime = new Date();
        dr.setCreated(submissionTime);
        dr.setIndexed(submissionTime);
        
        // Author
        List<Reference> authors = new ArrayList<>();
        Reference author = new Reference();
        author.setReference("The Author");
        authors.add(author);
        dr.setAuthor(authors);
        
        // Content
        List<DocumentReferenceContentComponent> content = new ArrayList<>();
        DocumentReferenceContentComponent c = new DocumentReferenceContentComponent();
        Attachment attachment = new Attachment();
        attachment.setUrl("Binary/12345");
        attachment.setSize(65536);
        attachment.setContentType("text/xml");
        c.setAttachment(attachment);
        content.add(c);
        dr.setContent(content);
        
        ret.add(dr);
        return new DocumentQueryerResponse(ret, null, true);
    }
}
