/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.announce;

import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientPortType;
import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientResponseType;
import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientService;
import gov.va.med.nhin.adapter.announcepatient.AnnouncePatientType;
import gov.va.med.nhin.adapter.permission.UserInfoType;
import gov.va.med.nhin.adapter.subscription.web.annotations.Property;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import java.net.MalformedURLException;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/**
 *
 * @author david
 */
@Named("WSPatientAnnouncer")
@ApplicationScoped()
public class WSPatientAnnouncer implements PatientAnnouncer
{
    private AnnouncePatientService announcePatientService;

    @Inject
    @Property
    private String announcePatientServiceWSDL;
    
    @Override
    public int sendAnnouncePatient(String forPatientId,
                                   String nhioHCID,
                                   EHXSubscription.Assertions assertions)
    {
        int ret;

        try {
            AnnouncePatientType request = buildRequest(forPatientId, nhioHCID, assertions);
            AnnouncePatientResponseType response = getPort().announcePatient(request);
            ret = response.getReturn();
        }
        catch (WebServiceException | MalformedURLException e) {
            ret = -1;
        }

        return ret;
    }

    private AnnouncePatientType buildRequest(String patientId,
                                             String hcid,
                                             EHXSubscription.Assertions assertions)
    {
        AnnouncePatientType ret = new AnnouncePatientType();
        
        ret.setPatientId(patientId);
        
        AnnouncePatientType.Facilities facilities = new AnnouncePatientType.Facilities();
        facilities.getFacility().add(hcid);
        ret.setFacilities(facilities);
        
        UserInfoType userInfo = new UserInfoType();
        userInfo.setUserId(assertions.getUserID().getValue());
        userInfo.setFullName(assertions.getUserName().getValue());
        userInfo.setAuthenticationMethod("Password");
        userInfo.setSystemId(assertions.getSystemID().getValue());
        userInfo.setRole(assertions.getRole().getValue());
        ret.setUserInfo(userInfo);
        
        return ret;
    }

    private synchronized AnnouncePatientPortType getPort() throws MalformedURLException
    {
        if (announcePatientService == null) {
            URL url = new URL(announcePatientServiceWSDL);
            QName qname = new QName("urn:gov:va:med:nhin:adapter:announcepatient", "AnnouncePatientService");
            announcePatientService = new AnnouncePatientService(url, qname);
        }

        return announcePatientService.getAnnouncePatientPort();
    }

    public void setAnnouncePatientServiceWSDL(String announcePatientServiceWSDL)
    {
        this.announcePatientServiceWSDL = announcePatientServiceWSDL;
    }
}
