/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.proxy.aatohcidmapper;

import gov.va.med.nhin.adapter.subscription.web.dao.FacilityDAO;
import gov.va.med.nhin.adapter.subscription.web.entity.Facility;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;

/**
 *
 * @author david
 */
@Named("FaciiltyDAOAssigningAuthorityToHomeCommunityMapper")
@ApplicationScoped()
public class FaciltyDAOAssigningAuthorityToHomeCommuinityMapper implements AssigningAuthorityToHomeCommunityMapper
{
    @Inject
    private FacilityDAO facilityDAO;
    
    @Override
    public List<String> getHomeCommunities(String assigningAuthority)
    {
        List<String> ret = new ArrayList<>();
        List<Facility> correlatedFacilities = facilityDAO.findByAssigningAuthorityAndOutAllowed(assigningAuthority);
        for (Facility f : correlatedFacilities) {
            ret.add(f.getFullHomeCommunityId());
        }
        return ret;
    }

    public void setFacilityDAO(FacilityDAO facilityDAO)
    {
        this.facilityDAO = facilityDAO;
    }
}
