/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.process;

import gov.va.med.nhin.adapter.subscription.web.event.NotificationEvent;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription.SubscriptionProvider;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import gov.va.med.nhin.adapter.subscription.web.server.SessionCache;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

/**
 *
 * @author david_vetsez
 */
@ApplicationScoped
public class WebSocketNotificationProcessor
{
    @Inject
    private SessionCache sessionCache;
    @Inject
    private SubscriptionProvider subscriptionProvider;

    public void processNotification(NotificationEvent event)
    {
        EHXSubscription subscription = subscriptionProvider.read(event.getSubscriptionID());
        int retries = 5;
        
        do {
            try {
                sessionCache.pingSubscriber(subscription.getIdElement().getIdPart());
                retries = 0;
            }
            catch (IOException ioe) {
                try {
                    Thread.sleep(500);
                }
                catch (InterruptedException ie) {
                    retries = 0;
                }
            }
        }
        while (--retries > 0);
    }

    public void setSubscriptionProvider(SubscriptionProvider subscriptionProvider)
    {
        this.subscriptionProvider = subscriptionProvider;
    }

    public void setSessionCache(SessionCache sessionCache)
    {
        this.sessionCache = sessionCache;
    }
}
