/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.process;

import gov.va.med.nhin.adapter.subscription.web.annotations.Updated;
import gov.va.med.nhin.adapter.subscription.web.event.NHIOEvent;
import gov.va.med.nhin.adapter.subscription.web.event.NotificationEvent;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription.SubscriptionProvider;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.hl7.fhir.dstu3.model.Subscription;

/**
 *
 * @author david_vetsez
 */
@ApplicationScoped
public class SubscriptionUpdateProcessor
{
    @Inject
    private SubscriptionProvider subscriptionProvider;
    @Inject
    private Event<NotificationEvent> notificationEvent;
    
    public void processSubscriptionUpdate(@Observes @Updated NHIOEvent event)
    {
        boolean fireEvent = subscriptionProvider.readWithUpdate(event.getSubscriptionID(), (subscription) -> {
            boolean ret = false;
            
            // update the status of the NHIO in the subscription.
            subscription.updateNHIOStatus(event.getHCID(), event.getStatus(), event.getProcessingStage(), event.getErrors());

            if (subscription.getStatus() == Subscription.SubscriptionStatus.ACTIVE) {
                ret = true;

                // turn off subscription when all NHIOs have completed processing.
                if (subscription.allDone()) {
                    subscription.setStatus(Subscription.SubscriptionStatus.OFF);
                }
            }
            return ret;
        });
        
        if (fireEvent) {
            notificationEvent.fire(new NotificationEvent(event.getSubscriptionID(), event.hasNewDocuments()));
        }
    }

    public void setSubscriptionProvider(SubscriptionProvider subscriptionProvider)
    {
        this.subscriptionProvider = subscriptionProvider;
    }

    public void setNotificationEvent(Event<NotificationEvent> notificationEvent)
    {
        this.notificationEvent = notificationEvent;
    }
}
