/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.process;

import gov.va.med.nhin.adapter.subscription.web.annotations.Created;
import gov.va.med.nhin.adapter.subscription.web.annotations.Property;
import gov.va.med.nhin.adapter.subscription.web.event.NHIOEvent;
import gov.va.med.nhin.adapter.subscription.web.event.NotificationEvent;
import gov.va.med.nhin.adapter.subscription.web.event.SubscriptionEvent;
import gov.va.med.nhin.adapter.subscription.web.proxy.aatohcidmapper.AssigningAuthorityToHomeCommunityMapper;
import gov.va.med.nhin.adapter.subscription.web.proxy.correlationretriever.CorrelationRetriever;
import gov.va.med.nhin.adapter.subscription.web.proxy.nhioretriever.NHIORetriever;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription.SubscriptionProvider;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription.NHIOStatus;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Subscription;

/**
 *
 * @author david_vetsez
 */
@Stateless()
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
public class SubscriptionProcessor
{
    @Inject
    private NHIORetriever nhioRetriever;
    @Inject
    private CorrelationRetriever correlationRetriever;
    @Inject
    @Created
    private Event<NHIOEvent> nhioEvent;
    @Inject
    private Event<NotificationEvent> notificationEvent;
    @Inject
    private SubscriptionProvider subscriptionProvider;
    @Inject
    private AssigningAuthorityToHomeCommunityMapper assigningAuthorityToHomeCommunityMapper;
    @Inject
    @Property
    private boolean announceEnabled;

    @Asynchronous()
    public void processSubscriptionCreated(@Observes @Created SubscriptionEvent event)
    {
        EHXSubscription subscription = subscriptionProvider.read(event.getSubscriptionID());
        
        // Update status to ACTIVE to show that subscription is being processed.
        // Send an update to the SubscriptionResourceProvider to make the change
        // in the database.
        subscription.setStatus(Subscription.SubscriptionStatus.ACTIVE);
        
        String patientID = subscription.getPatientID();

        // Get the list of NHIOs given the setting of announcePatient.
        List<String> nhios;
        if (announceEnabled && subscription.isAnnounce()) {
            nhios = nhioRetriever.getNHIOs();
        }
        else {
            nhios = getNHIOsFromPatientCorrelations(patientID, subscription.getAssertions());
        }

        // Add NHIO status entry for each NHIO that we're going to process.
        for (String nhio : nhios) {
            subscription.addNHIOStatus(nhio, EHXSubscription.NHIOStatus.StatusType.NEW, EHXSubscription.NHIOStatus.ProcessingStageType.STARTING);
        }
        
        subscriptionProvider.update(event.getSubscriptionID(), subscription);
        
        notificationEvent.fire(new NotificationEvent(event.getSubscriptionID(), true));
        
        // fire event for each NHIO.
        for (NHIOStatus nhioStatus : subscription.getNHIOStatuses()) {
            nhioEvent.fire(new NHIOEvent(event.getSubscriptionID(), nhioStatus.getHCID(), nhioStatus.getStatus(), nhioStatus.getProcessingStage(), null));
        }
    }
    
    private List<String> getNHIOsFromPatientCorrelations(String patientID, EHXSubscription.Assertions assertions)
    {
        List<String> ret = new ArrayList<>();
        Set<String> hcids = new HashSet<>();
        List<Identifier> correlatedPatientIDs = correlationRetriever.getCorrelations(patientID, assertions);
        for (Identifier i : correlatedPatientIDs) {
            List<String> correlatedHomeCommunities = assigningAuthorityToHomeCommunityMapper.getHomeCommunities(i.getSystem());
            for (String hcid : correlatedHomeCommunities) {
                hcids.add(hcid);
            }
        }
        
        for (String hcid : hcids) {
            ret.add(hcid);
        }
        
        return ret;
    }
    
    public void setNHIORetriever(NHIORetriever nhioRetriever)
    {
        this.nhioRetriever = nhioRetriever;
    }

    public void setCorrelationRetriever(CorrelationRetriever correlationRetriever)
    {
        this.correlationRetriever = correlationRetriever;
    }

    public void setNHIOEvent(Event<NHIOEvent> event)
    {
        this.nhioEvent = event;
    }

    public void setSubscriptionProvier(SubscriptionProvider subscriptionProvier)
    {
        this.subscriptionProvider = subscriptionProvier;
    }

    public void setAssigningAuthorityToHomeCommunityMapper(AssigningAuthorityToHomeCommunityMapper assigningAuthorityToHomeCommunityMapper)
    {
        this.assigningAuthorityToHomeCommunityMapper = assigningAuthorityToHomeCommunityMapper;
    }
}
