/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.process;

import ca.uhn.fhir.util.ElementUtil;
import gov.va.med.nhin.adapter.subscription.web.annotations.Property;
import gov.va.med.nhin.adapter.subscription.web.event.NotificationEvent;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription.SubscriptionProvider;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import static org.hl7.fhir.dstu3.model.Subscription.SubscriptionChannelType.RESTHOOK;
import static org.hl7.fhir.dstu3.model.Subscription.SubscriptionChannelType.WEBSOCKET;

/**
 *
 * @author david
 */
@Stateless()
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
public class NotificationEventProcessor
{
    @Inject
    private SubscriptionProvider subscriptionProvider;
    @Inject
    private RestHookNotificationProcessor restHookNotificationProcessor;
    @Inject
    private WebSocketNotificationProcessor webSocketNotificationProcessor;
    @Inject
    @Property
    private boolean notifyAll;
    
    @Asynchronous
    public void fireEvent(@Observes NotificationEvent notificationEvent)
    {
        EHXSubscription subscription = subscriptionProvider.read(notificationEvent.getSubscriptionID());
        
        if (notifyAll || notificationEvent.hasNewDocuments()) {
            switch (subscription.getChannel().getType()) {
                case RESTHOOK:
                    if (!ElementUtil.isEmpty(subscription.getChannel().getEndpoint())) {
                        restHookNotificationProcessor.processNotification(notificationEvent);
                    }
                    break;

                case WEBSOCKET:
                    webSocketNotificationProcessor.processNotification(notificationEvent);
                    break;

                default:
                    break;
            }
        }
    }
}
