/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.process;

import gov.va.med.nhin.adapter.subscription.web.annotations.Created;
import gov.va.med.nhin.adapter.subscription.web.annotations.Property;
import gov.va.med.nhin.adapter.subscription.web.annotations.Updated;
import gov.va.med.nhin.adapter.subscription.web.event.NHIOEvent;
import gov.va.med.nhin.adapter.subscription.web.proxy.announce.PatientAnnouncer;
import gov.va.med.nhin.adapter.subscription.web.proxy.documentquery.DocumentQueryer;
import gov.va.med.nhin.adapter.subscription.web.proxy.documentquery.DocumentQueryerResponse;
import gov.va.med.nhin.adapter.subscription.web.proxy.documentretrieve.DocumentRetrieverResponse;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.documentreference.DocumentReferenceProvider;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription.SubscriptionProvider;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXDocumentReference;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription.NHIOStatus;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.hl7.fhir.dstu3.model.Reference;

/**
 *
 * @author david_vetsez
 */
@Stateless()
@TransactionAttribute(value = TransactionAttributeType.SUPPORTS)
@Named("NHIOProcessor")
public class NHIOProcessor
{
    @Inject
    private SubscriptionProvider subscriptionProvider;
    @Inject
    private DocumentReferenceProvider documentReferenceProvider;
    @Inject
    private PatientAnnouncer patientAnnouncer;
    @Inject
    private DocumentQueryer documentQueryer;
    @Inject
    private DocumentProcessor documentProcessor;
    @Inject
    @Updated
    private Event<NHIOEvent> nhioEvent;
    @Inject
    @Property
    private boolean announceEnabled;

    @Asynchronous()
    public void processNHIO(@Observes @Created NHIOEvent event)
    {
        EHXSubscription subscription = subscriptionProvider.read(event.getSubscriptionID());
        String patientID = subscription.getPatientID();
        String hcid = event.getHCID();
        boolean announceSuccess;

        if (announceEnabled && subscription.isAnnounce()) {
            nhioEvent.fire(new NHIOEvent(event.getSubscriptionID(), event.getHCID(), NHIOStatus.StatusType.PROCESSING, NHIOStatus.ProcessingStageType.ANNOUNCE));
            announceSuccess = patientAnnouncer.sendAnnouncePatient(patientID, hcid, subscription.getAssertions()) > 0;
            if (announceSuccess) {
                nhioEvent.fire(new NHIOEvent(event.getSubscriptionID(), event.getHCID(), NHIOStatus.StatusType.PROCESSING, NHIOStatus.ProcessingStageType.ANNOUNCE_SUCCESS));
            }
            else {
                nhioEvent.fire(new NHIOEvent(event.getSubscriptionID(), event.getHCID(), NHIOStatus.StatusType.DONE, NHIOStatus.ProcessingStageType.ANNOUNCE_FAILURE));
            }
        }
        else {
            announceSuccess = true;
        }

        if (announceSuccess) {
            nhioEvent.fire(new NHIOEvent(event.getSubscriptionID(), event.getHCID(), NHIOStatus.StatusType.PROCESSING, NHIOStatus.ProcessingStageType.DOCUMENT_QUERY));
            DocumentQueryerResponse dqr = documentQueryer.sendDocumentQuery(patientID, hcid, subscription.getAssertions());

            if (dqr.isSuccess()) {
                nhioEvent.fire(new NHIOEvent(event.getSubscriptionID(),
                                             event.getHCID(),
                                             !dqr.getDocumentReferences().isEmpty() ? NHIOStatus.StatusType.PROCESSING : NHIOStatus.StatusType.DONE,
                                             NHIOStatus.ProcessingStageType.DOCUMENT_QUERY_SUCCESS,
                                             dqr.getErrors()));
                if (!dqr.getDocumentReferences().isEmpty()) {
                    for (EHXDocumentReference dr : dqr.getDocumentReferences()) {
                        dr.setSubscription(new Reference(subscription.getId()));
                        documentReferenceProvider.create(dr);
                    }

                    if (subscription.isAutoDocRetrieve()) {
                        nhioEvent.fire(new NHIOEvent(event.getSubscriptionID(), event.getHCID(), NHIOStatus.StatusType.PROCESSING, NHIOStatus.ProcessingStageType.DOCUMENT_RETRIEVE));
                        int i = 0;
                        for (EHXDocumentReference dr : dqr.getDocumentReferences()) {
                            DocumentRetrieverResponse drr = documentProcessor.getDocument(dr);
                            if (drr.isSuccess()) {
                                NHIOStatus.StatusType stat = (++i < dqr.getDocumentReferences().size()
                                    ? NHIOStatus.StatusType.PROCESSING
                                    : NHIOStatus.StatusType.DONE);
                                nhioEvent.fire(new NHIOEvent(event.getSubscriptionID(), event.getHCID(), stat, NHIOStatus.ProcessingStageType.DOCUMENT_RETRIEVE_SUCCESS, true, drr.getErrors()));
                            }
                            else {
                                nhioEvent.fire(new NHIOEvent(event.getSubscriptionID(), event.getHCID(), NHIOStatus.StatusType.DONE, NHIOStatus.ProcessingStageType.DOCUMENT_RETRIEVE_FAILURE, drr.getErrors()));
                                break;
                            }
                        }
                    }
                    else {
                        nhioEvent.fire(new NHIOEvent(event.getSubscriptionID(), event.getHCID(), NHIOStatus.StatusType.DONE, NHIOStatus.ProcessingStageType.DOCUMENT_QUERY_SUCCESS, true));
                    }
                }
            }
            else {
                nhioEvent.fire(new NHIOEvent(event.getSubscriptionID(), event.getHCID(), NHIOStatus.StatusType.DONE, NHIOStatus.ProcessingStageType.DOCUMENT_QUERY_FAILURE, dqr.getErrors()));
            }
        }
    }

    public void setSubscriptionProvider(SubscriptionProvider subscriptionProvider)
    {
        this.subscriptionProvider = subscriptionProvider;
    }

    public void setDocumentReferenceProvider(DocumentReferenceProvider documentReferenceProvider)
    {
        this.documentReferenceProvider = documentReferenceProvider;
    }

    public void setPatientAnnouncer(PatientAnnouncer patientAnnouncer)
    {
        this.patientAnnouncer = patientAnnouncer;
    }

    public void setDocumentQueryer(DocumentQueryer documentQueryer)
    {
        this.documentQueryer = documentQueryer;
    }

    public void setNhioEvent(Event<NHIOEvent> nhioEvent)
    {
        this.nhioEvent = nhioEvent;
    }

    public void setDocumentProcessor(DocumentProcessor documentProcessor)
    {
        this.documentProcessor = documentProcessor;
    }
}
