/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.process;

import gov.va.med.nhin.adapter.subscription.web.proxy.documentretrieve.DocumentRetriever;
import gov.va.med.nhin.adapter.subscription.web.proxy.documentretrieve.DocumentRetrieverResponse;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.binary.BinaryProvider;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.documentreference.DocumentReferenceProvider;
import gov.va.med.nhin.adapter.subscription.web.proxy.provider.subscription.SubscriptionProvider;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXDocumentReference;
import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.hl7.fhir.dstu3.model.Binary;
import org.hl7.fhir.dstu3.model.IdType;

/**
 *
 * @author DNS   VAZQUD
 */
@Named("GetDocumentProcessor")
@ApplicationScoped()
public class DocumentProcessor
{
    @Inject
    private BinaryProvider binaryProvider;
    @Inject
    private DocumentReferenceProvider documentReferenceProvider;
    @Inject
    private SubscriptionProvider subscriptionProvider;
    @Inject
    private DocumentRetriever documentRetriever;
    
    public Binary getDocument(String documentID)
    {
        IdType binaryID = new IdType("Binary", documentID);
        IdType documentReferenceID = new IdType("DocumentReference", documentID);
        Binary ret = binaryProvider.read(binaryID);
        
        if (ret == null) {
            EHXDocumentReference documentReference = documentReferenceProvider.read(documentReferenceID);
            if (documentReference != null) {
                ret = getDocument(documentReference).getBinary();
            }
        }
        
        return ret;
    }
    
    public DocumentRetrieverResponse getDocument(EHXDocumentReference documentReference)
    {
        DocumentRetrieverResponse ret;
        EHXSubscription subscription = subscriptionProvider.read(new IdType(documentReference.getSubscription().getReference()));
        ret = documentRetriever.sendRetrieveDocument(documentReference, subscription.getAssertions());
        if (ret.getBinary() != null) {
            binaryProvider.create(ret.getBinary());
        }
        return ret;
    }
}
