/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.event;

import gov.va.med.nhin.adapter.subscription.web.resource.EHXSubscription;
import java.util.List;
/**
 *
 * @author david_vetsez
 */
public class NHIOEvent extends Event
{
    private final Long subscriptionID;
    private final String hcid;
    private final EHXSubscription.NHIOStatus.ProcessingStageType processingStage;
    private final EHXSubscription.NHIOStatus.StatusType status;
    private final List<String> errors;
    private final boolean newDocuments;

    public NHIOEvent(Long subscriptionID, String hcid, EHXSubscription.NHIOStatus.StatusType status, EHXSubscription.NHIOStatus.ProcessingStageType processingStage)
    {
        this(subscriptionID, hcid, status, processingStage, false, null);
    }

    public NHIOEvent(Long subscriptionID, String hcid, EHXSubscription.NHIOStatus.StatusType status, EHXSubscription.NHIOStatus.ProcessingStageType processingStage, boolean newDocuments)
    {
        this(subscriptionID, hcid, status, processingStage, newDocuments, null);
    }

    public NHIOEvent(Long subscriptionID, String hcid, EHXSubscription.NHIOStatus.StatusType status, EHXSubscription.NHIOStatus.ProcessingStageType processingStage, List<String> errors)
    {
        this(subscriptionID, hcid, status, processingStage, false, errors);
    }   
    
    public NHIOEvent(Long subscriptionID, String hcid, EHXSubscription.NHIOStatus.StatusType status, EHXSubscription.NHIOStatus.ProcessingStageType processingStage, boolean newDocuments, List<String> errors)
    {
        this.subscriptionID = subscriptionID;
        this.hcid = hcid;
        this.status = status;
        this.processingStage = processingStage;
        this.newDocuments = newDocuments;
        this.errors = errors;
    }

    public Long getSubscriptionID()
    {
        return subscriptionID;
    }

    public String getHCID()
    {
        return hcid;
    }

    public EHXSubscription.NHIOStatus.ProcessingStageType getProcessingStage()
    {
        return processingStage;
    }

    public boolean hasNewDocuments()
    {
        return newDocuments;
    }

    public EHXSubscription.NHIOStatus.StatusType getStatus()
    {
        return status;
    }

    public List<String> getErrors()
    {
        return errors;
    }
}
