/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *
 * @author DNS   VAZQUD
 */
@Entity
@Table(name = "SUBSCRIPTIONS")
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "Subscription.findAll", query = "SELECT s FROM Subscription s")
    , @NamedQuery(name = "Subscription.findBySubscriptionId", query = "SELECT s FROM Subscription s WHERE s.subscriptionId = :subscriptionId")
    , @NamedQuery(name = "Subscription.findByResourceId", query = "SELECT s FROM Subscription s WHERE s.resourceId = :resourceId")
    , @NamedQuery(name = "Subscription.findByStatus", query = "SELECT s FROM Subscription s WHERE s.status = :status")
    , @NamedQuery(name = "Subscription.findByCriteria", query = "SELECT s FROM Subscription s WHERE s.criteria = :criteria")
    , @NamedQuery(name = "Subscription.findByChannel", query = "SELECT s FROM Subscription s WHERE s.channel = :channel")
    , @NamedQuery(name = "Subscription.findByUserId", query = "SELECT s FROM Subscription s WHERE s.userId = :userId")
    , @NamedQuery(name = "Subscription.findByUserName", query = "SELECT s FROM Subscription s WHERE s.userName = :userName")
    , @NamedQuery(name = "Subscription.findByOrganizationId", query = "SELECT s FROM Subscription s WHERE s.organizationId = :organizationId")
    , @NamedQuery(name = "Subscription.findByOrganizationName", query = "SELECT s FROM Subscription s WHERE s.organizationName = :organizationName")
    , @NamedQuery(name = "Subscription.findByPurposeOfUse", query = "SELECT s FROM Subscription s WHERE s.purposeOfUse = :purposeOfUse")
    , @NamedQuery(name = "Subscription.findByCreatedTime", query = "SELECT s FROM Subscription s WHERE s.createdTime = :createdTime")
    , @NamedQuery(name = "Subscription.findByLastUpdatedTime", query = "SELECT s FROM Subscription s WHERE s.lastUpdatedTime = :lastUpdatedTime")})
@SequenceGenerator(name = "subscriptionIdGenerator", sequenceName = "SUBSCRIPTION_ID_SEQ", allocationSize = 1)
public class Subscription implements Serializable
{
    private static final long serialVersionUID = 1L;
    // @Max(value=?)  @Min(value=?)//if you know range of your decimal fields consider using these annotations to enforce field validation
    @Id
    @Basic(optional = false)
    @NotNull
    @Column(name = "SUBSCRIPTION_ID")
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "subscriptionIdGenerator")
    private BigDecimal subscriptionId;
    @Size(max = 36)
    @Column(name = "RESOURCE_ID")
    private String resourceId;
    @Size(max = 255)
    @Column(name = "STATUS")
    private String status;
    @Size(max = 255)
    @Column(name = "CRITERIA")
    private String criteria;
    @Size(max = 255)
    @Column(name = "CHANNEL")
    private String channel;
    @Size(max = 255)
    @Column(name = "USER_ID")
    private String userId;
    @Size(max = 255)
    @Column(name = "USER_NAME")
    private String userName;
    @Size(max = 255)
    @Column(name = "ORGANIZATION_ID")
    private String organizationId;
    @Size(max = 255)
    @Column(name = "ORGANIZATION_NAME")
    private String organizationName;
    @Size(max = 255)
    @Column(name = "PURPOSE_OF_USE")
    private String purposeOfUse;
    @Column(name = "CREATED_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date createdTime;
    @Column(name = "LAST_UPDATED_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date lastUpdatedTime;
    @Lob
    @Column(name = "FHIR_RESOURCE")
    private byte[] fhirResource;

    public Subscription()
    {
    }

    public Subscription(BigDecimal subscriptionId)
    {
        this.subscriptionId = subscriptionId;
    }

    public BigDecimal getSubscriptionId()
    {
        return subscriptionId;
    }

    public void setSubscriptionId(BigDecimal subscriptionId)
    {
        this.subscriptionId = subscriptionId;
    }

    public String getResourceId()
    {
        return resourceId;
    }

    public void setResourceId(String resourceId)
    {
        this.resourceId = resourceId;
    }

    public String getStatus()
    {
        return status;
    }

    public void setStatus(String status)
    {
        this.status = status;
    }

    public String getCriteria()
    {
        return criteria;
    }

    public void setCriteria(String criteria)
    {
        this.criteria = criteria;
    }

    public String getChannel()
    {
        return channel;
    }

    public void setChannel(String channel)
    {
        this.channel = channel;
    }

    public String getUserId()
    {
        return userId;
    }

    public void setUserId(String userId)
    {
        this.userId = userId;
    }

    public String getUserName()
    {
        return userName;
    }

    public void setUserName(String userName)
    {
        this.userName = userName;
    }

    public String getOrganizationId()
    {
        return organizationId;
    }

    public void setOrganizationId(String organizationId)
    {
        this.organizationId = organizationId;
    }

    public String getOrganizationName()
    {
        return organizationName;
    }

    public void setOrganizationName(String organizationName)
    {
        this.organizationName = organizationName;
    }

    public String getPurposeOfUse()
    {
        return purposeOfUse;
    }

    public void setPurposeOfUse(String purposeOfUse)
    {
        this.purposeOfUse = purposeOfUse;
    }

    public Date getCreatedTime()
    {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime)
    {
        this.createdTime = createdTime;
    }

    public Date getLastUpdatedTime()
    {
        return lastUpdatedTime;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime)
    {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public byte[] getFhirResource()
    {
        return fhirResource;
    }

    public void setFhirResource(byte[] fhirResource)
    {
        this.fhirResource = fhirResource;
    }

    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (subscriptionId != null ? subscriptionId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription) object;
        if ((this.subscriptionId == null && other.subscriptionId != null) || (this.subscriptionId != null && !this.subscriptionId.equals(other.subscriptionId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString()
    {
        return "gov.va.med.nhin.adapter.subscription.web.entity.Subscription[ subscriptionId=" + subscriptionId + " ]";
    }

}
