/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 *
 * @author david_vetsez
 */
@Entity
@Table(name = "FACILITIES")
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "Facility.findAll", query = "SELECT f FROM Facility f"),
    @NamedQuery(name = "Facility.findByFacilityId", query = "SELECT f FROM Facility f WHERE f.facilityId = :facilityId"),
    @NamedQuery(name = "Facility.findByFacilityNumber", query = "SELECT f FROM Facility f WHERE f.facilityNumber = :facilityNumber"),
    @NamedQuery(name = "Facility.findByHomeCommunityId", query = "SELECT f FROM Facility f WHERE f.homeCommunityId = :homeCommunityId"),
    @NamedQuery(name = "Facility.findByFacilityName", query = "SELECT f FROM Facility f WHERE f.facilityName = :facilityName"),
    @NamedQuery(name = "Facility.findByFullHomeCommunityId", query = "SELECT f FROM Facility f WHERE f.fullHomeCommunityId = :fullHomeCommunityId"),
    @NamedQuery(name = "Facility.findByAcpCheck", query = "SELECT f FROM Facility f WHERE f.acpCheck = :acpCheck"),
    @NamedQuery(name = "Facility.findByUseSpecVersion", query = "SELECT f FROM Facility f WHERE f.useSpecVersion = :useSpecVersion"),
    @NamedQuery(name = "Facility.findAllOutAllowed", query = "SELECT f FROM Facility f WHERE f.facilitiesOperation.onOffBoard = 'Y' AND f.facilitiesOperation.outAllowPatientDicovery = 'Y' AND f.facilitiesOperation.outAllowDocQuery = 'Y' AND f.facilitiesOperation.outAllowDocRetrieve = 'Y'"),
    @NamedQuery(name = "Facility.findByAA", query = "SELECT f FROM Facility f JOIN FacilitiesToAa a JOIN AssigningAuthority b WHERE b.assigningAuthorityOid = :aaOID"),
    @NamedQuery(name = "Facility.findByAAAndOutAllowed", query = "SELECT f FROM Facility f JOIN FacilitiesToAa a JOIN AssigningAuthority b WHERE b.assigningAuthorityOid = :aaOID AND f.facilitiesOperation.onOffBoard = 'Y' AND f.facilitiesOperation.outAllowPatientDicovery = 'Y' AND f.facilitiesOperation.outAllowDocQuery = 'Y' AND f.facilitiesOperation.outAllowDocRetrieve = 'Y'")
})
public class Facility implements Serializable
{
    private static final long serialVersionUID = 1L;
    // @Max(value=?)  @Min(value=?)//if you know range of your decimal fields consider using these annotations to enforce field validation
    @Id
    @Basic(optional = false)
    @NotNull
    @Column(name = "FACILITY_ID")
    private BigDecimal facilityId;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 10)
    @Column(name = "FACILITY_NUMBER")
    private String facilityNumber;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(name = "HOME_COMMUNITY_ID")
    private String homeCommunityId;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(name = "FACILITY_NAME")
    private String facilityName;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(name = "FULL_HOME_COMMUNITY_ID")
    private String fullHomeCommunityId;
    @Column(name = "ACP_CHECK")
    private Character acpCheck;
    @Size(max = 5)
    @Column(name = "USE_SPEC_VERSION")
    private String useSpecVersion;
    @OneToOne(cascade = CascadeType.ALL, mappedBy = "facility")
    private FacilitiesOperation facilitiesOperation;
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "facilityId")
    private Collection<FacilitiesToAa> facilitiesToAaCollection;

    public Facility()
    {
    }

    public Facility(BigDecimal facilityId)
    {
        this.facilityId = facilityId;
    }

    public Facility(BigDecimal facilityId, String facilityNumber, String homeCommunityId, String facilityName, String fullHomeCommunityId)
    {
        this.facilityId = facilityId;
        this.facilityNumber = facilityNumber;
        this.homeCommunityId = homeCommunityId;
        this.facilityName = facilityName;
        this.fullHomeCommunityId = fullHomeCommunityId;
    }

    public BigDecimal getFacilityId()
    {
        return facilityId;
    }

    public void setFacilityId(BigDecimal facilityId)
    {
        this.facilityId = facilityId;
    }

    public String getFacilityNumber()
    {
        return facilityNumber;
    }

    public void setFacilityNumber(String facilityNumber)
    {
        this.facilityNumber = facilityNumber;
    }

    public String getHomeCommunityId()
    {
        return homeCommunityId;
    }

    public void setHomeCommunityId(String homeCommunityId)
    {
        this.homeCommunityId = homeCommunityId;
    }

    public String getFacilityName()
    {
        return facilityName;
    }

    public void setFacilityName(String facilityName)
    {
        this.facilityName = facilityName;
    }

    public String getFullHomeCommunityId()
    {
        return fullHomeCommunityId;
    }

    public void setFullHomeCommunityId(String fullHomeCommunityId)
    {
        this.fullHomeCommunityId = fullHomeCommunityId;
    }

    public Character getAcpCheck()
    {
        return acpCheck;
    }

    public void setAcpCheck(Character acpCheck)
    {
        this.acpCheck = acpCheck;
    }

    public String getUseSpecVersion()
    {
        return useSpecVersion;
    }

    public void setUseSpecVersion(String useSpecVersion)
    {
        this.useSpecVersion = useSpecVersion;
    }

    public FacilitiesOperation getFacilitiesOperation()
    {
        return facilitiesOperation;
    }

    public void setFacilitiesOperation(FacilitiesOperation facilitiesOperation)
    {
        this.facilitiesOperation = facilitiesOperation;
    }

    @XmlTransient
    public Collection<FacilitiesToAa> getFacilitiesToAaCollection()
    {
        return facilitiesToAaCollection;
    }

    public void setFacilitiesToAaCollection(Collection<FacilitiesToAa> facilitiesToAaCollection)
    {
        this.facilitiesToAaCollection = facilitiesToAaCollection;
    }

    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (facilityId != null ? facilityId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }

        final Facility other = (Facility) obj;
        return Objects.equals(this.facilityId, other.facilityId);
    }

    @Override
    public String toString()
    {
        return "gov.va.med.nhin.adapter.ehx.subscription.service.web.entity.Facility[ facilityId=" + facilityId + " ]";
    }

}
