/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
/**
 *
 * @author david_vetsez
 */
@Entity
@Table(name = "FACILITIES_TO_AAS")
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "FacilitiesToAa.findAll", query = "SELECT f FROM FacilitiesToAa f")
    , @NamedQuery(name = "FacilitiesToAa.findByFacilityToAaId", query = "SELECT f FROM FacilitiesToAa f WHERE f.facilityToAaId = :facilityToAaId")})
public class FacilitiesToAa implements Serializable
{
    private static final long serialVersionUID = 1L;
    // @Max(value=?)  @Min(value=?)//if you know range of your decimal fields consider using these annotations to enforce field validation
    @Id
    @Basic(optional = false)
    @NotNull
    @Column(name = "FACILITY_TO_AA_ID")
    private BigDecimal facilityToAaId;
    @JoinColumn(name = "ASSIGNING_AUTHORITY_ID", referencedColumnName = "ASSIGNING_AUTHORITY_ID")
    @ManyToOne(optional = false)
    private AssigningAuthority assigningAuthorityId;
    @JoinColumn(name = "FACILITY_ID", referencedColumnName = "FACILITY_ID")
    @ManyToOne(optional = false)
    private Facility facilityId;

    public FacilitiesToAa()
    {
    }

    public FacilitiesToAa(BigDecimal facilityToAaId)
    {
        this.facilityToAaId = facilityToAaId;
    }

    public BigDecimal getFacilityToAaId()
    {
        return facilityToAaId;
    }

    public void setFacilityToAaId(BigDecimal facilityToAaId)
    {
        this.facilityToAaId = facilityToAaId;
    }

    public AssigningAuthority getAssigningAuthorityId()
    {
        return assigningAuthorityId;
    }

    public void setAssigningAuthorityId(AssigningAuthority assigningAuthorityId)
    {
        this.assigningAuthorityId = assigningAuthorityId;
    }

    public Facility getFacilityId()
    {
        return facilityId;
    }

    public void setFacilityId(Facility facilityId)
    {
        this.facilityId = facilityId;
    }

    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (facilityToAaId != null ? facilityToAaId.hashCode() : 0);
        return hash;
    }

		@Override
		public boolean equals( Object obj ) {
			if ( this == obj ) {
				return true;
			}
			if ( obj == null ) {
				return false;
			}
			if ( getClass() != obj.getClass() ) {
				return false;
			}
			final FacilitiesToAa other = (FacilitiesToAa) obj;

			return Objects.equals( this.facilityToAaId, other.facilityToAaId );
		}

    @Override
    public String toString()
    {
        return "gov.va.med.nhin.adapter.ehx.subscription.service.web.entity.FacilitiesToAa[ facilityToAaId=" + facilityToAaId + " ]";
    }
    
}
