/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *
 * @author DNS   VAZQUD
 */
@Entity
@Table(name = "BINARIES")
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "Binary.findAll", query = "SELECT b FROM Binary b")
    , @NamedQuery(name = "Binary.findByBinaryId", query = "SELECT b FROM Binary b WHERE b.binaryId = :binaryId")
    , @NamedQuery(name = "Binary.findByResourceId", query = "SELECT b FROM Binary b WHERE b.resourceId = :resourceId")
    , @NamedQuery(name = "Binary.findByCreatedTime", query = "SELECT b FROM Binary b WHERE b.createdTime = :createdTime")
    , @NamedQuery(name = "Binary.findByLastUpdatedTime", query = "SELECT b FROM Binary b WHERE b.lastUpdatedTime = :lastUpdatedTime")})
@SequenceGenerator(name = "binaryIdGenerator", sequenceName = "BINARY_ID_SEQ", allocationSize = 1)
public class Binary implements Serializable
{
    private static final long serialVersionUID = 1L;
    // @Max(value=?)  @Min(value=?)//if you know range of your decimal fields consider using these annotations to enforce field validation
    @Id
    @Basic(optional = false)
    @NotNull
    @Column(name = "BINARY_ID")
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "binaryIdGenerator")
    private BigDecimal binaryId;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 36)
    @Column(name = "RESOURCE_ID")
    private String resourceId;
    @Basic(optional = false)
    @NotNull
    @Column(name = "CREATED_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date createdTime;
    @Basic(optional = false)
    @NotNull
    @Column(name = "LAST_UPDATED_TIME")
    @Temporal(TemporalType.TIMESTAMP)
    private Date lastUpdatedTime;
    @Lob
    @Column(name = "FHIR_RESOURCE")
    private byte[] fhirResource;

    public Binary()
    {
    }

    public Binary(BigDecimal binaryId)
    {
        this.binaryId = binaryId;
    }

    public Binary(BigDecimal binaryId, String resourceId, Date createdTime, Date lastUpdatedTime)
    {
        this.binaryId = binaryId;
        this.resourceId = resourceId;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public BigDecimal getBinaryId()
    {
        return binaryId;
    }

    public void setBinaryId(BigDecimal binaryId)
    {
        this.binaryId = binaryId;
    }

    public String getResourceId()
    {
        return resourceId;
    }

    public void setResourceId(String resourceId)
    {
        this.resourceId = resourceId;
    }

    public Date getCreatedTime()
    {
        return createdTime;
    }

    public void setCreatedTime(Date createdTime)
    {
        this.createdTime = createdTime;
    }

    public Date getLastUpdatedTime()
    {
        return lastUpdatedTime;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime)
    {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public byte[] getFhirResource()
    {
        return fhirResource;
    }

    public void setFhirResource(byte[] fhirResource)
    {
        this.fhirResource = fhirResource;
    }

    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (binaryId != null ? binaryId.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object)
    {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Binary)) {
            return false;
        }
        Binary other = (Binary)object;
        if ((this.binaryId == null && other.binaryId != null) || (this.binaryId != null && !this.binaryId.equals(other.binaryId))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString()
    {
        return "gov.va.med.nhin.adapter.subscription.web.entity.Binary[ binaryId=" + binaryId + " ]";
    }
    
}
