/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
/**
 *
 * @author david_vetsez
 */
@Entity
@Table(name = "ASSIGNING_AUTHORITIES")
@XmlRootElement
@NamedQueries({
    @NamedQuery(name = "AssigningAuthority.findAll", query = "SELECT a FROM AssigningAuthority a")
    , @NamedQuery(name = "AssigningAuthority.findByAssigningAuthorityId", query = "SELECT a FROM AssigningAuthority a WHERE a.assigningAuthorityId = :assigningAuthorityId")
    , @NamedQuery(name = "AssigningAuthority.findByAssigningAuthorityOid", query = "SELECT a FROM AssigningAuthority a WHERE a.assigningAuthorityOid = :assigningAuthorityOid")
    , @NamedQuery(name = "AssigningAuthority.findByAssigningAuthorityName", query = "SELECT a FROM AssigningAuthority a WHERE a.assigningAuthorityName = :assigningAuthorityName")})
public class AssigningAuthority implements Serializable
{
    private static final long serialVersionUID = 1L;
    // @Max(value=?)  @Min(value=?)//if you know range of your decimal fields consider using these annotations to enforce field validation
    @Id
    @Basic(optional = false)
    @NotNull
    @Column(name = "ASSIGNING_AUTHORITY_ID")
    private BigDecimal assigningAuthorityId;
    @Basic(optional = false)
    @NotNull
    @Size(min = 1, max = 255)
    @Column(name = "ASSIGNING_AUTHORITY_OID")
    private String assigningAuthorityOid;
    @Size(max = 2048)
    @Column(name = "ASSIGNING_AUTHORITY_NAME")
    private String assigningAuthorityName;
    @OneToMany(cascade = CascadeType.ALL, mappedBy = "assigningAuthorityId")
    private Collection<FacilitiesToAa> facilitiesToAaCollection;

    public AssigningAuthority()
    {
    }

    public AssigningAuthority(BigDecimal assigningAuthorityId)
    {
        this.assigningAuthorityId = assigningAuthorityId;
    }

    public AssigningAuthority(BigDecimal assigningAuthorityId, String assigningAuthorityOid)
    {
        this.assigningAuthorityId = assigningAuthorityId;
        this.assigningAuthorityOid = assigningAuthorityOid;
    }

    public BigDecimal getAssigningAuthorityId()
    {
        return assigningAuthorityId;
    }

    public void setAssigningAuthorityId(BigDecimal assigningAuthorityId)
    {
        this.assigningAuthorityId = assigningAuthorityId;
    }

    public String getAssigningAuthorityOid()
    {
        return assigningAuthorityOid;
    }

    public void setAssigningAuthorityOid(String assigningAuthorityOid)
    {
        this.assigningAuthorityOid = assigningAuthorityOid;
    }

    public String getAssigningAuthorityName()
    {
        return assigningAuthorityName;
    }

    public void setAssigningAuthorityName(String assigningAuthorityName)
    {
        this.assigningAuthorityName = assigningAuthorityName;
    }

    @XmlTransient
    public Collection<FacilitiesToAa> getFacilitiesToAaCollection()
    {
        return facilitiesToAaCollection;
    }

    public void setFacilitiesToAaCollection(Collection<FacilitiesToAa> facilitiesToAaCollection)
    {
        this.facilitiesToAaCollection = facilitiesToAaCollection;
    }

    @Override
    public int hashCode()
    {
        int hash = 0;
        hash += (assigningAuthorityId != null ? assigningAuthorityId.hashCode() : 0);
        return hash;
    }

		@Override
		public boolean equals( Object obj ) {
			if ( this == obj ) {
				return true;
			}
			if ( obj == null ) {
				return false;
			}
			if ( getClass() != obj.getClass() ) {
				return false;
			}
			final AssigningAuthority other = (AssigningAuthority) obj;
			return Objects.equals( this.assigningAuthorityId, other.assigningAuthorityId );
		}

    @Override
    public String toString()
    {
        return "gov.va.med.nhin.adapter.ehx.subscription.service.web.entity.AssigningAuthority[ assigningAuthorityId=" + assigningAuthorityId + " ]";
    }
    
}
