/*
 * DAO class for Subscription object.
 */
package gov.va.med.nhin.adapter.subscription.web.dao;

import gov.va.med.nhin.adapter.subscription.web.entity.Subscription;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

@ApplicationScoped
@Named("SubscriptionDAO")
public class SubscriptionDAO
{
    @PersistenceContext
    private EntityManager entityManager;

    public void store(Subscription subscription)
    {
        entityManager.persist(subscription);
    }
    
    public void update(Subscription subscription)
    {
        entityManager.merge(subscription);
    }
    
    public Subscription findBySubscriptionID(BigDecimal subscriptionID)
    {
        return findBySubscriptionID(subscriptionID, LockModeType.NONE);
    }
    
    public Subscription findBySubscriptionID(BigDecimal subscriptionID, LockModeType lockMode)
    {
        return entityManager.find(Subscription.class, subscriptionID, lockMode);
    }
    
    public Subscription findByResourceID(String resourceID)
    {
        Subscription ret;
        Query query = entityManager.createNamedQuery("Subscription.findByResourceId");
        query.setParameter("resourceId", resourceID);
        try {
            ret = (Subscription)query.getSingleResult();
        }
        catch (NoResultException nre) {
            ret = null;
        }
        
        return ret;
    }
    
    /*
    return Subscriptions matches to subscription clearance date
    */
    public List<Subscription> findBySubscriptionClearanceDate(Date date)
    {
        Query query = entityManager.createNamedQuery("Subscription.findBySubscriptionClearanceDate");
        query.setParameter("subscriptionClearanceDate", date);
        return query.getResultList();
    }
    /*
    return all Subscriptions
    */
    public List<Subscription> findAllSubscriptions()
    {
        Query query = entityManager.createNamedQuery("Subscription.findAll");
        return query.getResultList();
    }
    
    public void setEntityManager(EntityManager entityManager)
    {
        this.entityManager = entityManager;
    }
}