/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.hl7.fhir.dstu3.model.Resource;
/**
 *
 * @author david_vetsez
 */
public class InMemoryDAO<T extends Resource>
{
    private final Map<Long, T> dataStore = new ConcurrentHashMap<>();
    private final AtomicLong idCounter = new AtomicLong();

    public Long store(T resource)
    {
        Long id = idCounter.getAndIncrement();
        dataStore.put(id, resource);
        return id;
    }

    public void update(Long id, T resource)
    {
        dataStore.put(id, resource);
    }

    public T delete(Long id)
    {
        return dataStore.remove(id);
    }
    
    public T findByID(Long id)
    {
        return dataStore.get(id);
    }

    public T findByResourceID(String id)
    {
        T ret;

        List<T> results = find((T resource) -> {
            return resource.getIdElement().getIdPart().equals(id);
        });

        if (results.size() > 1) {
            throw new RuntimeException("Too many results.");
        }
        else if (results.isEmpty()) {
            ret = null;
        }
        else {
            ret = results.get(0);
        }

        return ret;
    }

    public List<T> find(Predicate<T> action)
    {
        List<T> ret = new ArrayList<>();

        dataStore.values().forEach((T t) -> {
            if (action.test(t)) {
                ret.add(t);
            }
        });

        return ret;
    }
}
