/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.dao;

import gov.va.med.nhin.adapter.subscription.web.entity.Facility;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/**
 *
 * @author david_vetsez
 */
@ApplicationScoped
@Named("FacilityDAO")
public class FacilityDAO
{
    private EntityManager entityManager;

    public EntityManager getEntityManager()
    {
        return entityManager;
    }

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager)
    {
        this.entityManager = entityManager;
    }
    
    public List<Facility> findAllOutAllowed()
    {
        Query query = entityManager.createNamedQuery("Facility.findAllOutAllowed");
        return query.getResultList();
    }
    
    public List<Facility> findByAssigningAuthorityAndOutAllowed(String assigningAuthorityID)
    {
        Query query = entityManager.createNamedQuery("Facility.findByAAAndOutAllowed");
        query.setParameter("aaOID", assigningAuthorityID);
        return query.getResultList();
    }
    
    public Facility findByFacilityNumber(String facilityNumber)
    {
        Facility ret;
    
        Query query = entityManager.createNamedQuery("Facility.findByFacilityNumber");
        query.setParameter("facilityNumber", facilityNumber);
        try {
            ret = (Facility)query.getSingleResult();
        }
        catch (NoResultException nre) {
            ret = null;
        }
        
        return ret;
    }
}

