/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.subscription.web.dao;

import java.math.BigDecimal;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import gov.va.med.nhin.adapter.subscription.web.entity.DocumentReference;
import java.util.List;

/**
 *
 * @author DNS   VAZQUD
 */
@Named("DocumentReferenceDAO")
@ApplicationScoped()
public class DocumentReferenceDAO
{
    @PersistenceContext
    private EntityManager entityManager;

    public void store(DocumentReference documentReference)
    {
        entityManager.persist(documentReference);
    }

    public void update(DocumentReference documentReference)
    {
        entityManager.merge(documentReference);
    }

    public DocumentReference findByDocumentReferenceID(BigDecimal documentReferenceID)
    {
        return entityManager.find(DocumentReference.class, documentReferenceID);
    }

    public DocumentReference findByResourceID(String resourceID)
    {
        DocumentReference ret;
        Query query = entityManager.createNamedQuery("DocumentReference.findByResourceId");
        query.setParameter("resourceId", resourceID);
        try {
            ret = (DocumentReference) query.getSingleResult();
        }
        catch (NoResultException nre) {
            ret = null;
        }

        return ret;
    }

    public List<DocumentReference> findByPatientIDAndLastUpdatedTime(String patientID,
                                                                     Date lastUpdatedTime)
    {
        Query query = entityManager.createNamedQuery("DocumentReference.findByPatientIdAndLastUpdatedTime");
        query.setParameter("patientId", patientID);
        query.setParameter("lastUpdatedTime", lastUpdatedTime);
        return query.getResultList();
    }

    public void setEntityManager(EntityManager entityManager)
    {
        this.entityManager = entityManager;
    }
}
